;; Code from SICP section 4.1

(define (tagged-list? exp tag)
  (if (pair? exp)
      (eq? (car exp) tag)
      false))

(define (make-if predicate consequent alternative)
  (list 'if predicate consequent alternative))

(define (last-exp? seq) (null? (cdr seq)))
(define (first-exp seq) (car seq))

(define (sequence->exp seq)
  (cond ((null? seq) seq)
        ((last-exp? seq) (first-exp seq))
        (else (make-begin seq))))

(define (make-begin seq) (cons 'begin seq))

(define (cond-clauses exp) (cdr exp))

(define (cond-else-clause? clause)
  (eq? (cond-predicate clause) 'else))

(define (cond-predicate clause) (car clause))

(define (cond-actions clause) (cdr clause))

(define (cond->if exp)
  (expand-clauses (cond-clauses exp)))

(define (expand-clauses clauses)
  (if (null? clauses)
      'false                          ; no else clause
      (let ((first (car clauses))
            (rest (cdr clauses)))
        (if (cond-else-clause? first)
            (if (null? rest)
                (sequence->exp (cond-actions first))
                (error "ELSE clause isn't last -- COND->IF"
                       clauses))
            (make-if (cond-predicate first)
                     (sequence->exp (cond-actions first))
                     (expand-clauses rest))))))

;; Code for syntax processor (two versions)

;; Version without predicate-stat for if
(define (process exp)
  (cond ((tagged-list? exp 'quote)
         exp)
        ((tagged-list? exp 'set!)
         (list 'set! (cadr exp) (process (caddr exp))))
        ((tagged-list? exp 'define)
         (cons 'define (cons (cadr exp) (map process (cddr exp)))))
        ((tagged-list? exp 'if)
         (cons 'if (map process (cdr exp))))
        ((tagged-list? exp 'lambda)
         (cons 'lambda (cons (cadr exp) (map process (cddr exp)))))
        ((tagged-list? exp 'begin)
         (cons 'begin (map process (cdr exp))))
        ((tagged-list? exp 'cond)
         (process (cond->if exp)))
        ((tagged-list? exp 'let)
         (cons 'let (cons (map (lambda (clause)
                                 (list (car clause) (process (cadr clause))))
                               (cadr exp))
                          (map process (cddr exp)))))
        ((pair? exp) (map process exp))
        (else exp)))

;; Version with predicate-stat for if
(define predicate-id 0)
(define (process exp)
  (cond ((tagged-list? exp 'quote)
         exp)
        ((tagged-list? exp 'set!)
         (list 'set! (cadr exp) (process (caddr exp))))
        ((tagged-list? exp 'define)
         (cons 'define (cons (cadr exp) (map process (cddr exp)))))
        ((tagged-list? exp 'if)
         (set! predicate-id (+ predicate-id 1))
         (cons 'if (cons (list 'predicate-stat
                               predicate-id
                               (process (cadr exp)))
                         (map process (cddr exp)))))
        ((tagged-list? exp 'lambda)
         (cons 'lambda (cons (cadr exp) (map process (cddr exp)))))
        ((tagged-list? exp 'begin)
         (cons 'begin (map process (cdr exp))))
        ((tagged-list? exp 'cond)
         (process (cond->if exp)))
        ((tagged-list? exp 'let)
         (cons 'let (cons (map (lambda (clause)
                                 (list (car clause) (process (cadr clause))))
                               (cadr exp))
                          (map process (cddr exp)))))
        ((pair? exp) (map process exp))
        (else exp)))

