;;; Code for interactive functional programming exercise

(define (run-io io-proc)
  (define (get-input-stream)
    (cons-stream (delay (read)) (get-input-stream)))
  (define (display-output-stream stream)
    (if (stream-null? stream)
	'end
	(begin
	  (display (stream-car stream))
	  (newline)
	  (display-output-stream (stream-cdr stream)))))
  (display-output-stream (io-proc (get-input-stream))))

(define (io-sqrt input-stream)
  (cons-stream
   "Enter a number or q to quit:"
   (let ((input (force (stream-car input-stream))))
     (if (eq? input 'q)
	 the-empty-stream
	 (cons-stream
	  "The square root is:"
	  (cons-stream
	   (sqrt input)
	   (io-sqrt (stream-cdr input-stream))))))))
