;;; Code for a queue exercise

;;; Queue implementation from SICP 3.3.2

(define (front-ptr queue) (car queue))
(define (rear-ptr queue) (cdr queue))
(define (set-front-ptr! queue item) (set-car! queue item))
(define (set-rear-ptr! queue item) (set-cdr! queue item))

(define (empty-queue? queue) (null? (front-ptr queue)))
(define (make-queue) (cons '() '()))

(define (front-queue queue)
  (if (empty-queue? queue)
      (error "FRONT called with an empty queue" queue)
      (car (front-ptr queue))))

(define (insert-queue! queue item)
  (let ((new-pair (cons item '())))
    (cond ((empty-queue? queue)
           (set-front-ptr! queue new-pair)
           (set-rear-ptr! queue new-pair)
           queue)
          (else
           (set-cdr! (rear-ptr queue) new-pair)
           (set-rear-ptr! queue new-pair)
           queue)))) 

(define (delete-queue! queue)
  (cond ((empty-queue? queue)
         (error "DELETE! called with an empty queue" queue))
        (else
         (set-front-ptr! queue (cdr (front-ptr queue)))
         queue))) 

;;; The two length-queues

(define (length-queue-x queue)
  (define (iter left count rear)
    (cond ((null? left) count)
	  ((eq? left rear) (+ count 1))
	  (else (iter (cdr left) (+ count 1) rear))))
  (iter (front-ptr queue) 0 (rear-ptr queue)))

(define (length-queue-y queue)
  (define (list-length l)
    (if (null? l)
	0
	(+ 1 (list-length (cdr l)))))
  (list-length (front-ptr queue)))

;;; The expressions in the problem statement

;; (define q (make-queue))
;; (define x 0)
;; (define y 0)
;; (insert-queue! q 'a)
;; (insert-queue! q 'b)
;; (insert-queue! q 'c)
;; (parallel-execute
;;  (lambda ()
;;    (delete-queue! q)
;;    (insert-queue! q 'd)
;;    (delete-queue! q)
;;    (insert-queue! q 'e)
;;    (insert-queue! q 'f)
;;    (insert-queue! q 'g))
;;  (lambda ()
;;    (set! x (length-queue-x q)))
;;  (lambda ()
;;    (set! y (length-queue-y q))))
