;;;
;;; A simple 3x3 noughts and crosses game for Scheme
;;; Placed in the public domain by the author, Riku Saikkonen.
;;;
;;; Note that the move-wins? procedure (internal to make-board) is not
;;; complete, and saving and loading games are not fully implemented.
;;; It's your job to complete these.
;;;
;;; Evaluate (play) to start the game.
;;;

;;;
;;; The game board (an "object" in the style of SICP chapter 3)
;;;

;; Makes a board object for holding the state of the board
(define (make-board)
  (let ((board (list (list #f #f #f)
                     (list #f #f #f)
                     (list #f #f #f)))
        (winner #f)
        (moves-left 9))
    (define (move-wins? x y player)
      ;; XXX write this procedure!
      #f)
    (define (legal-move? x y)
      (and (<= 0 x 2)
           (<= 0 y 2)
           (not (list-ref (list-ref board y) x))))
    (define (make-move! x y player)
      (set-car! (list-tail (list-ref board y) x)
                player)
      (set! moves-left (- moves-left 1))
      (if (move-wins? x y player)
          (set! winner player))
      'ok)
    (define (get-win-state)
      (cond (winner winner)
            ((= moves-left 0) 'draw)
            (else 'unfinished)))
    (define (draw-board)
      (for-each
       (lambda (row)
         (for-each
          (lambda (cell)
            (display (cadr (assq cell '((#f " .") (x " X") (o " O"))))))
          row)
         (newline))
       board))
    (define (board-dispatch m)
      (cond ((eq? m 'legal-move?) legal-move?)
            ((eq? m 'make-move!) make-move!)
            ((eq? m 'get-win-state) get-win-state)
            ((eq? m 'draw-board) draw-board)
            (else (error "BOARD: Invalid message received" m))))
    board-dispatch))

;;;
;;; Playing the game
;;;

;; Asks the user with a prompt, and repeats this until the answer is
;; among the given choices
(define (ask-for-choice prompt choices)
  (display prompt)
  (let ((answer (read)))
    (if (memq answer choices)
        answer
        (ask-for-choice prompt choices))))

;; Asks the user a y/n question and returns #t (y) or #f (n)
(define (ask-for-yn prompt)
  (eq? (ask-for-choice prompt '(y n))
       'y))

;; Announce the end of a game
;; state = draw or quit or the winning player's name (x or o)
(define (announce-game-end state)
  (cond ((eq? state 'quit)
         (display "The game was quit.")
         (newline))
        ((eq? state 'draw)
         (display "The game is a draw!")
         (newline))
        (else
         (display "Player ")
         (display state)
         (display " won the game!")
         (newline))))

;; Plays one game
(define (play-a-game do-load)
  (let ((board (make-board))
        (current-player #f))
    (define (ask-for-first-player)
      (set! current-player
            (ask-for-choice "Who goes first (x or o)? " '(x o))))
    (define (next-player)
      (set! current-player
            (if (eq? current-player 'x) 'o 'x)))
    (define (load-game)
      (with-input-from-file "oandx.savegame"
        (lambda ()
          ;; XXX write this procedure!
          'unfinished)))
    (define (save-game)
      (with-output-to-file "oandx.savegame"
        (lambda ()
          ;; XXX write this procedure!
          'unfinished)))
    (define (move x y)
      (cond ((not ((board 'legal-move?) x y))
             (display "Illegal move!")
             (newline)
             (game-loop))
            (else
             ((board 'make-move!) x y current-player)
             (let ((state ((board 'get-win-state))))
               (cond ((eq? state 'unfinished)
                      (next-player)
                      (game-loop))
                     (else
                      (announce-game-end state)))))))
    (define (display-board)
      ((board 'draw-board))
      (display "Player ")
      (display current-player)
      (display "'s turn.")
      (newline))
    (define (init-game)
      (if do-load
          (load-game)
          (ask-for-first-player)))
    (define (game-loop)
      (display-board)
      (let ((row (ask-for-choice "Row (1-3) or s=save or q=quit? "
                                 '(1 2 3 s q))))
        (cond ((eq? row 's) (save-game))
              ((eq? row 'q) (announce-game-end 'quit))
              (else
               (let ((col (ask-for-choice "Column (1-3)? "
                                          '(1 2 3))))
                 ;; move calls game-loop again if the game continues
                 (move (- col 1) (- row 1)))))))
    (init-game)
    (game-loop)))

;; Plays as many games as the user wants
(define (play)
  (define (play-loop)
    (play-a-game (ask-for-yn "Load a saved game (y or n)? "))
    (if (ask-for-yn "Play again (y or n)? ")
        (play-loop)
        'end-of-game))
  (display "*** The game of 3x3 noughts and crosses ***")
  (newline)
  (play-loop))

