;;; Code for elevator object exercise

(define (ask object message . args)
  (apply (object message) (cons object args)))

(define (make-elevator min-floor max-floor)
  (let ((current-floor min-floor))
    (define (go-down! self)
      (if (= current-floor min-floor)
	  (error "ELEVATOR: Can't go down")
	  (set! current-floor (- current-floor 1))))
    (define (go-up! self)
      (if (= current-floor max-floor)
	  (error "ELEVATOR: Can't go up")
	  (set! current-floor (+ current-floor 1))))
    (define (get-floor self)
      current-floor)
    (define (dispatch m)
      (cond ((eq? m 'go-down!) go-down!)
	    ((eq? m 'go-up!) go-up!)
	    ((eq? m 'get-floor) get-floor)
	    (else (error "ELEVATOR: Invalid message received" m))))
    dispatch))

(define (make-better-elevator min-floor max-floor)
  (let ((parent (make-elevator min-floor max-floor)))
    (define (go-to-floor! self new-floor)
      (let ((current (ask self 'get-floor)))
	(cond ((< current new-floor)
	       (ask self 'go-up!)
	       (go-to-floor! self new-floor))
	      ((> current new-floor)
	       (ask self 'go-down!)
	       (go-to-floor! self new-floor))
	      (else
	       'done))))
    (define (dispatch m)
      (cond ((eq? m 'go-to-floor!) go-to-floor!)
	    (else (parent m))))
    dispatch))

(define (make-displaying-elevator min-floor max-floor)
  (let ((parent (make-better-elevator min-floor max-floor)))
    (define (go-up! self)
      (display "going up")
      (newline)
      (ask parent 'go-up!))
    (define (go-down! self)
      (display "going down")
      (newline)
      (ask parent 'go-down!))
    (define (dispatch m)
      (cond ((eq? m 'go-up!) go-up!)
	    ((eq? m 'go-down!) go-down!)
	    (else (parent m))))
    dispatch))

;;(define (make-carrying-elevator min-floor max-floor)
;;  (let ((parent (make-better-elevator min-floor max-floor))
;;	<??>)
;;    <??>
;;    (define (dispatch m)
;;      <??>)
;;    dispatch))
