(define (ask object message . args)
  (apply (object message) (cons object args)))

(define (make-account initial-balance)
  (let ((balance initial-balance))
    (define (withdraw-1! self) 
      (if (= balance 0)
          (error "ACCOUNT: Insufficient funds")
          (set! balance (- balance 1))))
    (define (deposit-1! self)
      (set! balance (+ balance 1)))
    (define (get-balance self)
      balance)
    (define (dispatch m)
      (cond ((eq? m 'withdraw-1!) withdraw-1!)
            ((eq? m 'deposit-1!) deposit-1!)
            ((eq? m 'get-balance) get-balance)
            (else (error "ACCOUNT: Invalid message received" m))))
    dispatch))

(define (make-better-account initial-balance)
  (let ((parent (make-account initial-balance)))
    (define (withdraw! self amount)
      (if (> amount 0)
          (begin
            (ask self 'withdraw-1!)
            (withdraw! self (- amount 1)))))
    (define (deposit! self amount)
      (if (> amount 0)
          (begin
            (ask self 'deposit-1!)
            (deposit! self (- amount 1)))))
    (define (dispatch m)
      (cond ((eq? m 'withdraw!) withdraw!)
            ((eq? m 'deposit!) deposit!)
            (else (parent m))))
    dispatch))

(define (make-displaying-account initial-balance)
  (let ((parent (make-better-account initial-balance)))
    (define (withdraw-1! self)
      (display "ACCOUNT: withdrawing ")
      (newline)
      (ask parent 'withdraw-1!))
    (define (deposit-1! self)
      (display "ACCOUNT: depositing amount ")
      (newline)
      (ask parent 'deposit-1!))
    (define (dispatch m)
      (cond ((eq? m 'withdraw-1!) withdraw-1!)
            ((eq? m 'deposit-1!) deposit-1!)
            (else (parent m))))
    dispatch))

;; (define (make-protected-account initial-balance passwd)
;;   (let ((parent (make-better-account initial-balance))
;;         <??>)
;;     <??>
;;     (define (dispatch m)
;;       <??>)
;;     dispatch))
