;;;
;;; Hierarkia - Scheme Implementation
;;; human.scm: Player object for human player
;;;
;;; Copyright 2003 Sami Virpioja, Ilari Lhteenmki
;;;
;;; ---
;;;
;;; This file is part of Hierarkia - Scheme Implementation.
;;;
;;; Hierarkia - Scheme Implementation is free software; you can redistribute 
;;; it and/or modify it under the terms of the GNU General Public License as 
;;; published by the Free Software Foundation; either version 2 of the 
;;; License, or (at your option) any later version.
;;;
;;; Hierarkia - Scheme Implementation  is distributed in the hope that it will 
;;; be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
;;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General 
;;; Public License for more details.
;;;
;;; You should have received a copy of the GNU General Public License along 
;;; with Hierarkia - Scheme Implementation; if not, write to the Free Software
;;; Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
;;;
;;; ---
;;;
;;; See README for more details.
;;;
;;; This file defines an object for human player. All functionality
;;; is in the (G)UI object, which is given as parameter to the 
;;; procedure make-human-player.
;;;

(define (make-human-player gui)
  
  (define (get-move board turn prev-move allowed-moves)
    (let ((moves (hash-table-map allowed-moves (lambda (key value) 
                                                 (list key value)))))
      (cond ((and (= (length moves) 1)
                  (list? (cadr (car moves)))
                  (eq? (car (car (cadr (car moves)))) 'destroy))
             (list (car (car moves)) (car (cadr (car moves)))))
            ((= (length moves) 0) 'pass)
            (else
             (gui 'get-player-action board turn allowed-moves)))))

  (define (dispatch m . args)
    (cond ((eq? m 'get-move) (apply get-move args))
          ((eq? m 'get-player-type) 'human)
	  (else (error "MAKE-HUMAN-PLAYER: unknown message" m))))

  dispatch)
