/*****************************************************************************
 *
 *                           SerialNumberTransform.java
 *
 * Copyright 1998-2003 Kary Frmling
 * Source code distributed under GNU LESSER GENERAL PUBLIC LICENSE,
 * included in the LICENSE.txt file in the topmost directory
 *
 *****************************************************************************/

package fi.faidon.protection;

/**
 * Utility class for Faidon internal use, which transforms an evaluation version
 * serial number into the corresponding registered version number.
 *
 * @author Kary FR&Auml;MLING
 */
public class SerialNumberTransform extends SerialNumberManager {
    //--------------------------------------------------------------------------------------
    // Protected constants.
    //--------------------------------------------------------------------------------------
    
    //--------------------------------------------------------------------------------------
    // Public methods.
    //--------------------------------------------------------------------------------------
    
    //=============================================================================
    // main
    //=============================================================================
    /**
     * Main program which takes an evaluation version serial number as input
     * and outputs the corresponding registered version serial number.
     *
     * @author Kary FR&Auml;MLING
     */
    //=============================================================================
    public static void main(String[] argv) {
	String	new_number;
	SerialNumberTransform	snt;
	
	// Verify that we have an input argument.
	if ( argv.length < 1 ) {
	    System.out.println("No serial number given as argument!");
	    System.exit(1);
	}
	
	// You can test with this one: "FADNJVG1.0-519824-05182351238"
	
	// Get the new serial number.
	snt = new SerialNumberTransform();
	new_number = snt.getRegisteredNumber(argv[0]);
	
	// Write it out with the result of a verification test that it is
	// valid.
	System.out.println(new_number);
	System.out.println(snt.verifySerialNumber(new_number));
    }
    
    //=============================================================================
    // getRegisteredNumber
    //=============================================================================
    /**
     * Create a registered serial number using the given evaluation serial number.
     */
    //=============================================================================
    public String getRegisteredNumber(String evalNumber) {
	// Split up the number into parts.
	if ( !getFieldsFromSerialNo(evalNumber) ) return "";
	
	// Recompose it with the type code changed to the registered type.
	type = REGISTERED_VERSION_TYPE;
	
	// Get the new number.
	return makeSerialNoFromFields();
    }
    
}


