/*****************************************************************************
 *
 *                                 RegActivate.java
 *
 * Copyright 1998-2003 Kary Frmling
 * Source code distributed under GNU LESSER GENERAL PUBLIC LICENSE,
 * included in the LICENSE.txt file in the topmost directory
 *
 *****************************************************************************/

package fi.faidon.protection;

import java.io.*;
import java.util.zip.*;

/**
 * Program that transforms an evaluation version package into a registered
 * one.
 *
 * @author Kary FR&Auml;MLING
 */
public class RegActivate {
    //=============================================================================
    // main
    //=============================================================================
    /**
     * Program entry point. Input arguments are:
     * - The path of the package to activate.
     * - The registration serial number given by Faidon Oy-Ab.
     *
     * @author Kary FR&Auml;MLING
     */
    //=============================================================================
    public static void main(String[] argv) {
	File		src_file, dst_file;
	ZipEntry	entry;
	FileInputStream		fis;
	ZipInputStream		zis;
	FileOutputStream	fos;
	ZipOutputStream		zos;
	byte[]		byte_buf = new byte[1024];
	int		nbr_bytes_read;
	String	zip_entry_name;
	boolean	write_entry;
	String	version = "";
	String	serial_no = "";
	SerialNumberManager		em = new SerialNumberManager();
	
	// Verify that we have an input argument.
	if ( argv.length < 2 ) {
	    System.err.println("Required input arguments: <package file path> <serial number>");
	    System.exit(1);
	}
	
	// Verify that the file exists.
	src_file = new File(argv[0]);
	if ( !src_file.exists() )  {
	    System.err.println("Package file not found!");
	    System.exit(1);
	}
	
	// Go ahead and copy the archive into a new file. We remove any
	// old "RegInfo" entry found and add the new one at the end.
	try {
	    fis = new FileInputStream(src_file);
	    zis = new ZipInputStream(fis);
	    dst_file = new File(SerialNumberManager.STR_TMP_PACKAGE_FILE_NAME);
	    fos = new FileOutputStream(dst_file);
	    zos = new ZipOutputStream(fos);
	    
	    // Copy all the entries from the source file to the destination
	    // file.
	    while ( (entry = zis.getNextEntry()) != null ) {
		// Get the name of the entry. We don't write any eventual existing
		// registration entries.
		write_entry = true;
		zip_entry_name = entry.getName();
		if ( zip_entry_name.equals(SerialNumberManager.STR_REG_INFO_ENTRY_NAME) )
		    write_entry = false;
		
		// Write the entry into the destination file unless it is
		// a registration entry.
		if ( write_entry ) zos.putNextEntry(new ZipEntry(zip_entry_name));
		while ( (nbr_bytes_read = zis.read(byte_buf)) >= 0 ) {
		    if ( write_entry ) zos.write(byte_buf, 0, nbr_bytes_read);
		}
		
		// Close entries both sides.
		if ( write_entry ) zos.closeEntry();
		zis.closeEntry();
	    }
	    
	    // Add a new entry to the end of the file with the new serial number.
	    zos.putNextEntry(new ZipEntry(SerialNumberManager.STR_REG_INFO_ENTRY_NAME));
	    zos.write(argv[1].getBytes());
	    zos.closeEntry();
	    
	    // Close everything.
	    zis.close();
	    fis.close();
	    zos.close();
	    fos.close();
	    
	    // Delete the old package file and replace it with the new one.
	    src_file.delete();
	    if ( !dst_file.renameTo(src_file) ) {
		System.err.println("Error renaming the new package file!");
		System.err.println("Try doing it manually instead: rename " +
		SerialNumberManager.STR_TMP_PACKAGE_FILE_NAME + " " + argv[0]);
		System.exit(1);
	    }
	} catch ( IOException ioe ) { System.err.println(ioe); }
	
	// Give a success message.
	System.out.println("Operation completed successfully!");
    }
}
