/*****************************************************************************
 *
 *                                 GetRegInfo.java
 *
 * Copyright 1998-2003 Kary Frmling
 * Source code distributed under GNU LESSER GENERAL PUBLIC LICENSE,
 * included in the LICENSE.txt file in the topmost directory
 *
 *****************************************************************************/

package fi.faidon.protection;

import java.io.*;
import java.util.zip.*;

/**
 * Program that display the registration info of a package.
 *
 * @author Kary FR&Auml;MLING
 */
public class GetRegInfo {
    //=============================================================================
    // main
    //=============================================================================
    /**
     * Program entry point. Input arguments are:
     * - The path of the package to examine.
     *
     * @author Kary FR&Auml;MLING
     */
    //=============================================================================
    public static void main(String[] argv) {
	File		src_file, dst_file;
	ZipEntry	entry;
	FileInputStream		fis;
	ZipInputStream		zis;
	byte[]		byte_buf = new byte[1024];
	int		nbr_bytes_read;
	String	zip_entry_name;
	String	version = "";
	String	serial_no = "";
	SerialNumberManager		em = new SerialNumberManager();
	
	// Verify that we have an input argument.
	if ( argv.length < 1 ) {
	    System.err.println("Required input arguments: <package file path>");
	    System.exit(1);
	}
	
	// Verify that the file exists.
	src_file = new File(argv[0]);
	if ( !src_file.exists() )  {
	    System.err.println("Package file not found!");
	    System.exit(1);
	}
	
	// Go through the entries and read the interesting ones.
	try {
	    fis = new FileInputStream(src_file);
	    zis = new ZipInputStream(fis);
	    while ( (entry = zis.getNextEntry()) != null ) {
		// Get the name of the entry. We don't write any eventual existing
		// registration entries.
		zip_entry_name = entry.getName();
		
		// Write the entry into the destination file unless it is
		// a registration entry.
		while ( (nbr_bytes_read = zis.read(byte_buf)) >= 0 ) {
		    if ( zip_entry_name.equals(SerialNumberManager.STR_REG_INFO_ENTRY_NAME) ) {
			System.out.println(new String(byte_buf, 0, nbr_bytes_read));
		    }
		}
		
		// Close entries both sides.
		zis.closeEntry();
	    }
	    
	    // Close everything.
	    zis.close();
	    fis.close();
	    
	} catch ( IOException ioe ) { System.err.println(ioe); }
	
	// Give a success message.
	System.out.println("Operation completed successfully!");
    }
}
