/*****************************************************************************
 *
 *                                EvalActivate.java
 *
 * Copyright 1998-2003 Kary Frmling
 * Source code distributed under GNU LESSER GENERAL PUBLIC LICENSE,
 * included in the LICENSE.txt file in the topmost directory
 *
 *****************************************************************************/

package fi.faidon.protection;

import java.io.*;
import java.util.zip.*;

/**
 * Program that activates the evaluation period for the given program/bean/
 * class package.
 *
 * @author Kary FR&Auml;MLING
 */
public class EvalActivate {
    //=============================================================================
    // main
    //=============================================================================
    /**
     * Program entry point. It takes the path of the package to activate as
     * input argument.
     *
     * @author Kary FR&Auml;MLING
     */
    //=============================================================================
    public static void main(String[] argv) {
	int			i;
	File		src_file, dst_file;
	ZipEntry	entry;
	FileInputStream		fis;
	ZipInputStream		zis;
	FileOutputStream	fos;
	ZipOutputStream		zos;
	byte[]		byte_buf = new byte[1024];
	int		nbr_bytes_read;
	String	version = "";
	String	serial_no = "";
	SerialNumberManager		em = new SerialNumberManager();
	
	// Verify that we have an input argument.
	if ( argv.length < 1 ) {
	    System.err.println("No package path given as argument!");
	    System.exit(1);
	}
	
	// Verify that the file exists.
	src_file = new File(argv[0]);
	if ( !src_file.exists() )  {
	    System.err.println("Package file not found!");
	    System.exit(1);
	}
	
	// Go ahead and copy the archive into a new file and add the
	// "RegInfo" entry at the end.
	try {
	    fis = new FileInputStream(src_file);
	    zis = new ZipInputStream(fis);
	    dst_file = new File(SerialNumberManager.STR_TMP_PACKAGE_FILE_NAME);
	    fos = new FileOutputStream(dst_file);
	    zos = new ZipOutputStream(fos);
	    
	    // Copy all the entries from the source file to the destination
	    // file.
	    while ( (entry = zis.getNextEntry()) != null ) {
		// Write the entry into the destination file.
		zos.putNextEntry(new ZipEntry(entry.getName()));
		while ( (nbr_bytes_read = zis.read(byte_buf)) >= 0 ) {
		    // See if it is the serial number entry and get the serial
		    // number if so.
		    if ( entry.getName().equals(SerialNumberManager.STR_VERSION_ENTRY_NAME) ) {
			version = new String(byte_buf, 0, nbr_bytes_read);
			// Get substring up to the first newline.
			for ( i = 0 ; i < version.length() && version.charAt(i) != '\n' ; i++ ) ;
			if ( i < version.length() ) version = version.substring(0, i - 1);
		    }
		    
		    // Write the bytes.
		    zos.write(byte_buf, 0, nbr_bytes_read);
		}
		
		// Close entries both sides.
		zis.closeEntry();
		zos.closeEntry();
	    }
	    
	    // Add a new entry to the end of the file.
	    zos.putNextEntry(new ZipEntry(SerialNumberManager.STR_REG_INFO_ENTRY_NAME));
	    serial_no = em.getSerialNumber(version, true);
	    zos.write(serial_no.getBytes());
	    zos.closeEntry();
	    
	    // Close everything.
	    zis.close();
	    fis.close();
	    zos.close();
	    fos.close();
	    
	    // Delete the old package file and replace it with the new one.
	    src_file.delete();
	    if ( !dst_file.renameTo(src_file) ) {
		System.err.println("Error renaming the new package file!");
		System.err.println("Try doing it manually instead: rename " +
		SerialNumberManager.STR_TMP_PACKAGE_FILE_NAME + " " + argv[0]);
		System.exit(1);
	    }
	} catch ( IOException ioe ) { System.err.println(ioe); }
	
	// Give a success message.
	System.out.println("Operation completed successfully!");
    }
}
