/*****************************************************************************
 *
 *                            Version1JVGHeader.java
 *
 * Created by Kary FRAMLING 4/5/1998
 *
 * Copyright 1998-2003 Kary Frmling
 * Source code distributed under GNU LESSER GENERAL PUBLIC LICENSE,
 * included in the LICENSE.txt file in the topmost directory
 *
 *****************************************************************************/

package fi.faidon.jvg;

import java.util.Date;
import java.io.Serializable;

/**
 * Version 1 default JVG header.
 *
 * @author Kary FR&Auml;MLING 4/5/1998
 */
public class Version1JVGHeader extends JVGHeader implements Serializable {
    //-----------------------------------------------------------------
    // Public methods.
    //-----------------------------------------------------------------
    
    //=============================================================================
    // Constructor
    //=============================================================================
    /**
     * Construct a new version 1 JVG header.
     *
     * @author Kary FR&Auml;MLING 4/5/1998
     */
    //=============================================================================
    public Version1JVGHeader() {
	idJVGVersion = "1.0";
	creator = "Faidon JVG package version 1.0";
	creationTime = new Date();
	javaVersion = System.getProperty("java.version");
	javaVendor = System.getProperty("java.vendor");
	javaVendorURL = System.getProperty("java.vendor.url");
	osName = System.getProperty("os.name");
	osArch = System.getProperty("os.arch");
	osVersion = System.getProperty("os.version");
    }
    
}

