/*****************************************************************************
 *
 *                                  JVGHeader.java
 *
 * Created by Kary FRAMLING 4/5/1998
 *
 * Copyright 1998-2003 Kary Frmling
 * Source code distributed under GNU LESSER GENERAL PUBLIC LICENSE,
 * included in the LICENSE.txt file in the topmost directory
 *
 *****************************************************************************/

package fi.faidon.jvg;

import java.util.Date;
import java.io.Serializable;

/**
 * Abstract class that defines the minimal set of fields and methods for a JVG
 * file header. This class is useful for being able to identify the header record
 * in a JVG file, no matter what its' contents are. It is sufficient if it extends
 * the JVGHeader class. This also means that modifying the JVG header for new
 * versions won't give any compatibility problems. The header should always be
 * the first object in the graphics operations vector. It is not compulsory, though.
 * You can have a JVG file without header, which means that default settings
 * (whatever they are) apply.
 * <P>
 * The JVG definition actually has no restrictions for inserting various objects into
 * the operations vector. A program may therefore add any objects it wants, the only
 * rules are:
 * <UL>
 * <LI> If there is a header object, it should be the first one.
 * <LI>	GraphicsOperation objects should be followed by the appropriate objects, but there may
 * be any other objects too.
 * </UL>
 *
 * @author Kary FR&Auml;MLING 4/5/1998
 */
public abstract class JVGHeader implements Serializable {
    //-----------------------------------------------------------------
    // Public fields.
    //-----------------------------------------------------------------
    
    /**
     * Version identifier string. A "version" operation can also be included.
     */
    public String	idJVGVersion;
    
    /**
     * Creator identifier string. Usually a string identifying the creating application.
     */
    public String	creator;
    
    /**
     * Creation date and time.
     */
    public Date		creationTime;
    
    /**
     * System and Java version identifier strings.
     */
    public String	javaVersion;
    public String	javaVendor;
    public String	javaVendorURL;
    public String	osName;
    public String	osArch;
    public String	osVersion;
    
}

