/*****************************************************************************
 *														                     *
 *                            GraphicsOperation.java 
 * 
 * Class for implementing graphics operations. Its' main purpose is, 
 * in fact, to define the constants for various operations. 
 * 
 * Created by Kary FRAMLING 12/4/1998 
 *
 * Copyright 1998-2003 Kary Frmling
 * Source code distributed under GNU LESSER GENERAL PUBLIC LICENSE,
 * included in the LICENSE.txt file in the topmost directory
 *
 *****************************************************************************/

package fi.faidon.jvg;

import java.io.Serializable;

/**
 * Class for implementing graphics operations. Its' main purpose is,
 * in fact, to define the constants for various operations.
 *
 * @author Kary FR&Auml;MLING 12/4/1998
 */
public class GraphicsOperation implements Serializable
{
	//--------------------------------------------------------------------------------------
	// Public constants.
	//--------------------------------------------------------------------------------------
	public static final int		NOP = 0x00;
	public static final int		VERSION = 0x01;

	public static final int		CLEAR_RECT = 0x20; 
	public static final int		CLIP_RECT = 0x21;
	public static final int		COPY_AREA = 0x22;
	public static final int		DRAW_3D_RECT = 0x23; 
	public static final int		DRAW_ARC = 0x24; 
	public static final int		DRAW_IMAGE_AT_POINT = 0x25;
	public static final int		DRAW_IMAGE_IN_RECT = 0x26;
	public static final int		DRAW_IMAGE_AT_POINT_WITH_BGCOLOR = 0x27;
	public static final int		DRAW_IMAGE_IN_RECT_WITH_BGCOLOR = 0x28;
	public static final int		DRAW_SUBIMAGE_IN_RECT = 0x29;
	public static final int		DRAW_SUBIMAGE_IN_RECT_WITH_BGCOLOR = 0x2A;
	public static final int		DRAW_LINE = 0x2B; 
	public static final int		DRAW_OVAL = 0x2C; 
	public static final int		DRAW_POLYGON = 0x2D;
	public static final int		DRAW_POLYLINE = 0x2E; 
	public static final int		DRAW_RECT = 0x2F;
	public static final int		DRAW_ROUND_RECT = 0x30;
	public static final int		DRAW_STRING = 0x31;
	public static final int		FILL_3D_RECT = 0x32;
	public static final int		FILL_ARC = 0x33;
	public static final int		FILL_OVAL = 0x34;
	public static final int		FILL_POLYGON = 0x35;
	public static final int		FILL_RECT = 0x36;
	public static final int		FILL_ROUND_RECT = 0x37; 
	public static final int		SET_CLIP = 0x38;
	public static final int		SET_COLOR = 0x39;
	public static final int		SET_FONT = 0x3A;
	public static final int		SET_PAINT_MODE = 0x3B;
	public static final int		SET_XOR_MODE = 0x3C;
	public static final int		TRANSLATE = 0x3D;
	public static final int		SET_BG_COLOR = 0x3E;	// Not recordable with Graphics, 
														// but might be useful when importing, 
														// for instance. 

	//--------------------------------------------------------------------------------------
	// Private constants.
	//--------------------------------------------------------------------------------------
	private final boolean	OBLIGATORY_REGISTRATION = false;

	//--------------------------------------------------------------------------------------
	// Private variables.
	//--------------------------------------------------------------------------------------
	private int		operation;

	//--------------------------------------------------------------------------------------
	// Public methods.
	//--------------------------------------------------------------------------------------

	//=============================================================================
	// Constructor
	//=============================================================================
	/**
	 * Construct a new graphics operation with the give operation code.
	 *
	 * @author Kary FR&Auml;MLING 12/4/1998
	 */
	//=============================================================================
	public GraphicsOperation(int opCode)
	{
		operation = opCode;
	}

	//=============================================================================
	// getOperation
	//=============================================================================
	/**
	 * Return the operation code.
	 *
	 * @author Kary FR&Auml;MLING 12/4/1998
	 */
	//=============================================================================
	public int getOperation()
	{
		return operation;
	}

	//=============================================================================
	// setOperation
	//=============================================================================
	/**
	 * Set the operation code.
	 *
	 * @author Kary FR&Auml;MLING 12/4/1998
	 */
	//=============================================================================
	public void setOperation(int opCode)
	{
		operation = opCode;
	}


}

