/*****************************************************************************
 *
 *                           JPEGComponentInfo.java
 *
 * Copyright 1998-2003 Kary Frmling
 * Source code distributed under GNU LESSER GENERAL PUBLIC LICENSE,
 * included in the LICENSE.txt file in the topmost directory
 *
 *****************************************************************************/

package fi.faidon.jis;

import java.io.IOException;

/**
 * Class for implementing the jpeg_component_info type of the JPEG library.
 *
 * @author Kary FR&Auml;MLING
 */

public class JPEGComponentInfo {
    //--------------------------------------------------------------------------------------
    // Public fields.
    //--------------------------------------------------------------------------------------
    /**
     * These values are fixed over the whole image.
     * For compression, they must be supplied by parameter setup;
     * for decompression, they are read from the SOF marker.
     */
    public int	componentID;		// identifier for this component (0..255).
    public int	componentIndex;		// its index in SOF or cinfo->comp_info[].
    public int	hSampFactor;		// horizontal sampling factor (1..4).
    public int	vSampFactor;		// vertical sampling factor (1..4).
    public int	quantTblNo;			// quantization table selector (0..3).
    
    /**
     * These values may vary between scans.
     * For compression, they must be supplied by parameter setup;
     * for decompression, they are read from the SOS marker.
     * The decompressor output side may not use these variables.
     */
    public int	dcTblNo;			// DC entropy table selector (0..3).
    public int	acTblNo;			// AC entropy table selector (0..3).
    
    /* Remaining fields should be treated as private by applications. */
    
    /* These values are computed during compression or decompression startup: */
	/* Component's size in DCT blocks.
	 * Any dummy blocks added to complete an MCU are not counted; therefore
	 * these values do not depend on whether a scan is interleaved or not.
	 */
    public int		widthInBlocks;
    public int		heightInBlocks;
    
	/* Size of a DCT block in samples.  Always DCTSIZE for compression.
	 * For decompression this is the size of the output from one DCT block,
	 * reflecting any scaling we choose to apply during the IDCT step.
	 * Values of 1,2,4,8 are likely to be supported.  Note that different
	 * components may receive different IDCT scalings.
	 */
    public int	DCTscaledSize;
    
	/* The downsampled dimensions are the component's actual, unpadded number
	 * of samples at the main buffer (preprocessing/compression interface), thus
	 * downsampled_width = ceil(image_width * Hi/Hmax)
	 * and similarly for height.  For decompression, IDCT scaling is included, so
	 * downsampled_width = ceil(image_width * Hi/Hmax * DCT_scaled_size/DCTSIZE)
	 */
    public int	downsampledWidth;		// Actual width in samples.
    public int	downsampledHeight;		// Actual height in samples.
    
	/* This flag is used only for decompression.  In cases where some of the
	 * components will be ignored (eg grayscale output from YCbCr image),
	 * we can skip most computations for the unused components.
	 */
    public boolean	componentNeeded;	/* do we need the value of this component? */
    
    /* These values are computed before starting a scan of the component. */
    /* The decompressor output side may not use these variables. */
    int MCUwidth;		/* number of blocks per MCU, horizontally */
    int MCUheight;		/* number of blocks per MCU, vertically */
    int MCUblocks;		/* MCU_width * MCU_height */
    int MCUsampleWidth;		/* MCU width in samples, MCU_width*DCT_scaled_size */
    int lastColWidth;		/* # of non-dummy blocks across in last MCU */
    int lastRowHeight;		/* # of non-dummy blocks down in last MCU */
    
	/* Saved quantization table for component; NULL if none yet saved.
	 * See jdinput.c comments about the need for this information.
	 * This field is currently used only for decompression.
	 */
    //  JQUANT_TBL * quant_table;
    
    /* Private per-component storage for DCT or IDCT subsystem. */
    //  void * dct_table;
    
    //--------------------------------------------------------------------------------------
    // Public methods.
    //--------------------------------------------------------------------------------------
    
    //=============================================================================
    // setComp
    //=============================================================================
    /**
     * Set the JPEG colorspace, and choose colorspace-dependent default values.
     *
     * See the macro SET_COMP in jcparam.c of IJG Jpeg-6a library.
     */
    //=============================================================================
    public void setComp(int id, int index, int hsamp, int vsamp, int quant, int dctbl, int actbl) {
	componentID = id;
	componentIndex = index;
	hSampFactor = hsamp;
	vSampFactor = vsamp;
	quantTblNo = quant;
	dcTblNo = dctbl;
	acTblNo = actbl;
    }
    
} // End of class

