/*****************************************************************************
 *
 *                       IndexColorModelSerializer.java
 *
 * Class for saving AWT IndexColorModel as serialized objects.
 * This requires saving the RGB and alpha arrays.
 *
 * Created by Kary FRAMLING 24/4/1998
 *
 * Copyright 1998-2003 Kary Frmling
 * Source code distributed under GNU LESSER GENERAL PUBLIC LICENSE,
 * included in the LICENSE.txt file in the topmost directory
 *
 *****************************************************************************/

package fi.faidon.jis;

import java.io.*;
import java.awt.*;
import java.awt.image.*;
import java.util.zip.*;

/**
 * Class for saving AWT IndexColorModel as serialized objects.
 *
 * @author Kary FR&Auml;MLING
 */
public class IndexColorModelSerializer implements Serializable {
    
    IndexColorModel		model;
    
    //-----------------------------------------------------------------
    // main
    //-----------------------------------------------------------------
    /**
     * Test main function.
     */
    //-----------------------------------------------------------------
    public static void main(String[] argv) {
	System.exit(0);
    }
    
    //-----------------------------------------------------------------
    // Constructor
    //-----------------------------------------------------------------
    /**
     * Default constructor.
     */
    //-----------------------------------------------------------------
    public IndexColorModelSerializer() {
    }
    
    //-----------------------------------------------------------------
    // Constructor
    //-----------------------------------------------------------------
    /**
     * Constructor which initializes the IndexColorModel. This is
     * useful mainly for writing the model to the disk.
     */
    //-----------------------------------------------------------------
    public IndexColorModelSerializer(IndexColorModel m) {
	model = m;
    }
    
    //-----------------------------------------------------------------
    // getModel
    //-----------------------------------------------------------------
    /**
     * Return the IndexColorModel.
     */
    //-----------------------------------------------------------------
    public IndexColorModel getModel() {
	return model;
    }
    
    //-----------------------------------------------------------------
    // setModel
    //-----------------------------------------------------------------
    /**
     * Set the IndexColorModel.
     */
    //-----------------------------------------------------------------
    public void setModel(IndexColorModel m) {
	model = m;
    }
    
    //-----------------------------------------------------------------
    // writeObject
    //-----------------------------------------------------------------
    /**
     * Write the IndexColorModel to the output stream.
     */
    //-----------------------------------------------------------------
    private void writeObject(ObjectOutputStream stream)
    throws IOException {
	// Elementary verifications.
	if ( model == null ) return;
	
	// Get map size and initialize byte array.
	int map_size = model.getMapSize();
	
	// Write out RGB arrays.
	byte[] red_bytes = new byte[map_size];
	byte[] green_bytes = new byte[map_size];
	byte[] blue_bytes = new byte[map_size];
	model.getReds(red_bytes);
	stream.writeObject(red_bytes);
	model.getGreens(green_bytes);
	stream.writeObject(green_bytes);
	model.getBlues(blue_bytes);
	stream.writeObject(blue_bytes);
	
	// Write out alpha array or transparency pixel
	if ( model.getTransparentPixel() >= 0 ) {
	    stream.writeObject(new Integer(model.getTransparentPixel()));
	}
	else {
	    byte[] alpha_bytes = new byte[map_size];
	    model.getAlphas(alpha_bytes);
	    stream.writeObject(alpha_bytes);
	}
    }
    
    //-----------------------------------------------------------------
    // readObject
    //-----------------------------------------------------------------
    /**
     * Read the saved IndexColorModel values from the output stream and
     * set out "model" property to a new IndexColorModel object
     * using these values.
     */
    //-----------------------------------------------------------------
    private void readObject(ObjectInputStream stream)
    throws IOException, ClassNotFoundException {
	byte[]	reds, greens, blues, alphas;
	
	// Read in the arrays.
	reds = (byte[]) stream.readObject();
	greens = (byte[]) stream.readObject();
	blues = (byte[]) stream.readObject();
	
	// See if we have a transparency pixel value or alpha values.
	// Create the corresponding IndexColorModel.
	Object next_object = stream.readObject();
	if ( next_object instanceof Integer ) {
	    model = new IndexColorModel(8, reds.length, reds, greens, blues, ((Integer) next_object).intValue());
	}
	else {
	    model = new IndexColorModel(8, reds.length, reds, greens, blues, (byte[]) next_object);
	}
    }
}

