/*****************************************************************************
 *
 *                          ImageSaverObjectBeanInfo.java 
 * 
 * Bean info class for the ImageSaverObject bean. Just defines an icon for 
 * now	
 * 
 * Java source created by Kary FRAMLING 18/3/1998 
 *
 * Copyright 1998-2003 Kary Frmling
 * Source code distributed under GNU LESSER GENERAL PUBLIC LICENSE,
 * included in the LICENSE.txt file in the topmost directory
 *
 *****************************************************************************/

package fi.faidon.jis;

import java.beans.*;
import java.awt.*;

public class ImageSaverObjectBeanInfo extends SimpleBeanInfo
{
	//--------------------------------------------------------------------------------------
	// Public methods.
	//--------------------------------------------------------------------------------------

	//=============================================================================
	// getIcon
	//=============================================================================
	/**
	 * Return the bean icon depending on the icon kind wanted.
	 *
	 * @author Kary FR&Auml;ling 18/3/1998.
	 */
	//=============================================================================
	public Image getIcon(int iconKind) 
	{
		String	icon_name;
		Image	icon_image;

		// Get the name of the bean icon image.
		switch ( iconKind ) {
		case BeanInfo.ICON_COLOR_16x16:
			icon_name = "ImageSaverObjectIconColor16x16.gif";
			break;
		case BeanInfo.ICON_COLOR_32x32:
			icon_name = "ImageSaverObjectIconColor32x32.gif";
			break;
		case BeanInfo.ICON_MONO_16x16:
			icon_name = "ImageSaverObjectIconMono16x16.gif";
			break;
		case BeanInfo.ICON_MONO_32x32:
			icon_name = "ImageSaverObjectIconMono32x32.gif";
			break;
		default:
			return null;
		}
		icon_image = loadImage("images/" + icon_name);
		return icon_image;
	}

}


