/*****************************************************************************
 *
 *                       DirectColorModelSerializer.java
 *
 * Class for saving AWT DirectColorModels as serialized objects.
 * This requires saving the pixel size (nbr of bits), RVB mask and
 * eventually the alpha mask if any.
 *
 * Created by Kary FRAMLING 16/5/1998
 *
 * Copyright 1998-2003 Kary Frmling
 * Source code distributed under GNU LESSER GENERAL PUBLIC LICENSE,
 * included in the LICENSE.txt file in the topmost directory
 *
 *****************************************************************************/

package fi.faidon.jis;

import java.io.*;
import java.awt.*;
import java.awt.image.*;
import java.util.zip.*;

/**
 * Class for saving AWT DirectColorModels as serialized objects.
 *
 * @author Kary FR&Auml;MLING
 */
public class DirectColorModelSerializer implements Serializable {
    
    DirectColorModel		model;
    
    //-----------------------------------------------------------------
    // main
    //-----------------------------------------------------------------
    /**
     * Test main function.
     */
    //-----------------------------------------------------------------
/*	public static void main(String[] argv)
	{
		System.exit(0);
	}
 */
    //-----------------------------------------------------------------
    // Constructor
    //-----------------------------------------------------------------
    /**
     * Default constructor.
     */
    //-----------------------------------------------------------------
    public DirectColorModelSerializer() {
    }
    
    //-----------------------------------------------------------------
    // Constructor
    //-----------------------------------------------------------------
    /**
     * Constructor which initializes the DirectColorModel. This is
     * useful mainly for writing the model to the disk.
     */
    //-----------------------------------------------------------------
    public DirectColorModelSerializer(DirectColorModel m) {
	model = m;
    }
    
    //-----------------------------------------------------------------
    // getModel
    //-----------------------------------------------------------------
    /**
     * Return the DirectColorModel.
     */
    //-----------------------------------------------------------------
    public DirectColorModel getModel() {
	return model;
    }
    
    //-----------------------------------------------------------------
    // setModel
    //-----------------------------------------------------------------
    /**
     * Set the DirectColorModel.
     */
    //-----------------------------------------------------------------
    public void setModel(DirectColorModel m) {
	model = m;
    }
    
    //-----------------------------------------------------------------
    // writeObject
    //-----------------------------------------------------------------
    /**
     * Write the key parameters of the DirectColorModel to the output
     * stream.
     */
    //-----------------------------------------------------------------
    private void writeObject(ObjectOutputStream stream)
    throws IOException {
	// Elementary verifications.
	if ( model == null ) return;
	
	// Get pixel size and write it out.
	stream.writeObject(new Integer(model.getPixelSize()));
	
	// Alpha and RGB masks.
	stream.writeObject(new Integer(model.getAlphaMask()));
	stream.writeObject(new Integer(model.getRedMask()));
	stream.writeObject(new Integer(model.getGreenMask()));
	stream.writeObject(new Integer(model.getBlueMask()));
    }
    
    //-----------------------------------------------------------------
    // readObject
    //-----------------------------------------------------------------
    /**
     * Read the saved DirectColorModel values from the output stream and
     * set out "model" property to a new IndexColorModel object
     * using these values.
     */
    //-----------------------------------------------------------------
    private void readObject(ObjectInputStream stream)
    throws IOException, ClassNotFoundException {
	int		pixel_size, alpha_mask, red_mask, green_mask, blue_mask;
	
	// Read pixel size.
	pixel_size = ((Integer) stream.readObject()).intValue();
	
	// Alpha and RGB masks.
	alpha_mask = ((Integer) stream.readObject()).intValue();
	red_mask = ((Integer) stream.readObject()).intValue();
	green_mask = ((Integer) stream.readObject()).intValue();
	blue_mask = ((Integer) stream.readObject()).intValue();
	
	// See if we have a alpha mask or not and construct the color model
	// accordingly.
	if ( alpha_mask == 0 ) {
	    model = new DirectColorModel(pixel_size, red_mask, green_mask, blue_mask);
	}
	else {
	    model = new DirectColorModel(pixel_size, alpha_mask, red_mask, green_mask, blue_mask);
	}
    }
}

