/*****************************************************************************
 *
 *                            FileOpenButtonBean.java
 *
 * Bean for showing a file opening dialog and storing the path of the file.
 * All bean observers are notified about the change.
 *
 * Created by Kary FRAMLING 16/3/1998
 *
 * Copyright 1998-2003 Kary Frmling
 * Source code distributed under GNU LESSER GENERAL PUBLIC LICENSE,
 * included in the LICENSE.txt file in the topmost directory
 *
 *****************************************************************************/

package fi.faidon.gui;

import java.io.*;
import java.io.Serializable;
import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.*;

public class FileOpenButtonBean extends Button implements  Serializable, ActionListener {
    
    //--------------------------------------------------------------------------------------
    // Private constants.
    //--------------------------------------------------------------------------------------
    private static final String	MY_BUTTON_LABEL = "Open file...";
    
    //--------------------------------------------------------------------------------------
    // Public fields.
    //--------------------------------------------------------------------------------------
    
    //--------------------------------------------------------------------------------------
    // Private fields.
    //--------------------------------------------------------------------------------------
    private String	filePath;
    private String	fileDirectory;
    private String	fileName;
    private PropertyChangeSupport changes = new	PropertyChangeSupport(this);
    
    //--------------------------------------------------------------------------------------
    // Public methods.
    //--------------------------------------------------------------------------------------
    public static void main(String[] argv) {
	Frame f = new Frame("Test FileOpenButtonBean");
	FileOpenButtonBean fb = new FileOpenButtonBean();
	f.setLayout(new FlowLayout());
	f.add(fb);
	f.setSize(250, 200);
	f.show();
    }
    
    //=============================================================================
    // Constructor
    //=============================================================================
    /**
     * Initialize the component size so that we dont stay invisible.
     *
     * @author Kary FR&Auml;ING 16/3/1998
     */
    //=============================================================================
    public FileOpenButtonBean() {
	super(MY_BUTTON_LABEL);
	
	// Catch actions myself.
	addActionListener(this);
    }
    
    //=============================================================================
    // getFilePath
    //=============================================================================
    /**
     * Get the complete file path.
     *
     * @author Kary FR&Auml;ING 16/3/1998
     */
    //=============================================================================
    public String getFilePath() { return filePath; }
    
    //=============================================================================
    // getFileDirectory
    //=============================================================================
    /**
     * Get the file directory.
     *
     * @author Kary FR&Auml;ING 16/3/1998
     */
    //=============================================================================
    public String getFileDirectory() { return fileDirectory; }
    
    //=============================================================================
    // getFileName
    //=============================================================================
    /**
     * Get the file name.
     *
     * @author Kary FR&Auml;ING 16/3/1998
     */
    //=============================================================================
    public String getFileName() { return fileName; }
    
    //=============================================================================
    // actionPerformed {OVERRIDE}
    //=============================================================================
    /**
     * Catch mouse clicks on us.
     *
     * @author Kary FR&Auml;ING 16/3/1998
     */
    //=============================================================================
    public void actionPerformed(ActionEvent e) {
	// Show file open dialog.
	FileDialog the_dialog = new FileDialog(new Frame(), "Open file");
	the_dialog.show();
	
	// Get file and directory names.
	fileDirectory = the_dialog.getDirectory();
	fileName = the_dialog.getFile();
	filePath = fileDirectory + fileName;
	
	// Notify listening beans.
	changes.firePropertyChange("fileDirectory", null, fileDirectory);
	changes.firePropertyChange("fileName", null, fileName);
	changes.firePropertyChange("filePath", null, filePath);
    }
    
    //-----------------------------------------------------------------
    /**
     * PropertyChangeSupport methods.
     */
    //-----------------------------------------------------------------
    public void addPropertyChangeListener(PropertyChangeListener l) {
	changes.addPropertyChangeListener(l);
    }
    
    public void removePropertyChangeListener(PropertyChangeListener l) {
	changes.removePropertyChangeListener(l);
    }
    
}

