
/*****************************************************************************
 *														                     *
 *                            RecordingTest.java                             *
 *                                                                           *
 * Created by Kary FRAMLING 27/4/1998                                        *
 *                                                                           *
 *****************************************************************************/

import java.io.*;
import java.awt.*;
import java.awt.event.*;
import java.awt.image.*;
import java.util.Vector;
import fi.faidon.jvg.*;

/**
 * Small application for creating a GraphicsRecording and saving it onto 
 * disk in the JVG format.
 *
 * @author Kary FR&Auml;MLING 27/4/1998
 */
public class RecordingTest extends Frame implements ActionListener
{

	Button	exitButton;

    //-----------------------------------------------------------------
	// main
    //-----------------------------------------------------------------
	/**
	 * Test main function.
	 *
	 * @author Kary FR&Auml;MLING
	 */
    //-----------------------------------------------------------------
	public static void main(String[] argv)
	{
		Vector	ops;
		Image	img;

		// Check that we have a file name.
		if ( argv.length < 1 ) {
			System.out.println("No image file specified!");
			System.exit(1);
		}

		// Create the frame and display everything.
		new RecordingTest(argv[0]);
	}

    //-----------------------------------------------------------------
	// Constructor
    //-----------------------------------------------------------------
	/**
	 * Create a new instance using the image at path "path".
	 *
	 * @author Kary FR&Auml;MLING
	 */
    //-----------------------------------------------------------------
	public RecordingTest(String path)
	{
		RecordingImagePanel ip = new RecordingImagePanel(path);
		initFrame(ip);
	}

    //-----------------------------------------------------------------
	// initFrame
    //-----------------------------------------------------------------
	/**
	 * Set up the frame.
	 *
	 * @author Kary FR&Auml;MLING
	 */
    //-----------------------------------------------------------------
	private void initFrame(RecordingImagePanel ip)
	{
		setLayout(new BorderLayout());
		add("Center", ip);
		Panel button_panel = new Panel();
		add("South", button_panel);
		button_panel.setLayout(new FlowLayout());
		exitButton = new Button("Exit");
		exitButton.addActionListener(this);
		button_panel.add(exitButton);
		setSize(550, 500);
		show();
	}

    //-----------------------------------------------------------------
	// actionPerformed
    //-----------------------------------------------------------------
	/**
	 * Exit no matter what button is pressed.
	 *
	 * @author Kary FR&Auml;MLING
	 */
    //-----------------------------------------------------------------
	public void actionPerformed(ActionEvent e) 
	{
		System.exit(0);
	}

}

/**
 * Panel extending class for showing the graphics operations.
 *
 * @author Kary FR&Auml;MLING 27/4/1998
 */
class RecordingImagePanel extends Panel
{
	String	imagePath;
	GraphicsRecording	recording;

    //-----------------------------------------------------------------
	// Constructor
    //-----------------------------------------------------------------
	/**
	 * Create a new instance using the image at path "path".
	 *
	 * @author Kary FR&Auml;MLING
	 */
    //-----------------------------------------------------------------
	public RecordingImagePanel(String path)
	{
		imagePath = path;
	}

    //-----------------------------------------------------------------
	// paint {OVERRIDE}
    //-----------------------------------------------------------------
	/**
	 * Create a new recording if we don't have one yet and then display 
	 * it. The display becomes very flickery if we have a lot of pixmap 
	 * images to display, so it is useful to either override "imageUpdate" 
	 * or check that every image is ready. 
	 *
	 * @author Kary FR&Auml;MLING
	 */
    //-----------------------------------------------------------------
	public void paint(Graphics g) 
	{
		Image	img;
		Image[]	recording_imgs;

		// If we have no recording yet, then create it, do the drawing and save it to file.
		if ( recording == null ) {

			// Create a RecorderGraphics that records the operations. We could also 
			// do this with a Graphics object of a Component, but this is not 
			// necessary here.
			RecorderGraphics rg = new RecorderGraphics(g);

			// Get the images.
			img = Toolkit.getDefaultToolkit().getImage("Image1.jpg");

			// Do a number of drawing operations.
			rg.drawImage(img, 0, 0, 99, 99, this);
			rg.drawLine(100, 0, 199, 99);
			rg.copyArea(0, 0, 75, 75, 200, 0);
			rg.setColor(Color.gray);
			rg.fill3DRect(300, 0, 99, 99, false);
			rg.draw3DRect(300, 0, 99, 99, false);
			rg.clearRect(340, 40, 20, 20);
			rg.drawArc(400, 0, 100, 100, -45, 135);
			rg.fillArc(400, 20, 80, 80, -45, 135);
			rg.setColor(Color.black);
			rg.drawOval(0, 100, 200, 100);
			rg.drawRoundRect(0, 100, 100, 100, 20, 40);
			rg.fillRoundRect(20, 120, 60, 60, 10, 20);
			rg.setColor(Color.lightGray);
			rg.fillOval(110, 140, 80, 20);
			rg.setColor(Color.red);
			rg.drawString("This is a RecordingTest!", 230, 160);
			rg.setColor(Color.green);
			int[] xpoints1 = {200, 300, 399, 350, 300, 250};
			int[] ypoints1 = {150, 100, 150, 199, 175, 199};
			rg.drawPolygon(xpoints1, 
                           ypoints1,
                           xpoints1.length);
			rg.setColor(Color.blue);
			int[] xpoints2 = {400, 450, 499, 475, 450, 425};
			int[] ypoints2 = {150, 100, 150, 199, 175, 199};
			rg.fillPolygon(xpoints2, 
                           ypoints2,
                           xpoints2.length);
			rg.setColor(Color.black);
			int[] xpoints3 = {0, 50, 99, 75, 50, 25};
			int[] ypoints3 = {250, 200, 250, 299, 275, 299};
			rg.drawPolyline(xpoints3, 
                           ypoints3,
                           xpoints3.length);
			rg.drawRect(100, 200, 99, 99);
			rg.setXORMode(Color.yellow);
			rg.drawRect(100, 220, 99, 60);
			rg.drawRect(100, 240, 99, 20);
			rg.setPaintMode();
			rg.fillRect(120, 220, 40, 40);
			rg.fillRect(140, 240, 40, 40);
			rg.setClip(220, 220, 80, 80);
			rg.fillRect(200, 200, 99, 99);
			rg.setClip(0, 0, getSize().width, getSize().height);
			Font f = rg.getFont();
			rg.setFont(new Font(f.getName(), Font.BOLD|Font.ITALIC, 18));
			rg.drawString("Big, bold and italic string", 300, 260);

			// Get the recording.
			recording = rg.getRecording();

			// Save the recording into the given file.
			recording.saveToFile(new File(imagePath));
		}

		// Play the recording. 
		recording.playIt(g, this);
	}

    //-----------------------------------------------------------------
	// imageUpdate {OVERRIDE}
    //-----------------------------------------------------------------
	/**
	 * Update only when images are complete to reduce flickering. 
	 *
	 * @author Kary FR&Auml;MLING
	 */
    //-----------------------------------------------------------------
	public boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height)
	{
		if ( (infoflags & ALLBITS) > 0 ) {
			return super.imageUpdate(img, infoflags, x, y, width, height);
		}
		else {
			return true;
		}
	}

}

