
/*****************************************************************************
 *														                     *
 *                                   PNGReadDemo.java                        *
 *                                                                           *
 * Created by Kary FRAMLING 7/6/1998                                         *
 *                                                                           *
 *****************************************************************************/

import java.io.*;
import java.awt.*;
import fi.faidon.jvg.*;

/**
 * Example application for reading a PNG file. 
 *
 * @author Kary FR&Auml;MLING 7/6/1998
 */
public class PNGReadDemo
{

	//--------------------------------------------------------------------------------------
	// Public methods.
	//--------------------------------------------------------------------------------------

	//=============================================================================
	// main
	//=============================================================================
	/**
	 * Main program. Takes the name of the PNG file as argument.
	 *
	 * @author Kary FR&Auml;MLING 7/6/1998
	 */
	//=============================================================================
	public static void main(String[] argv)
	{
		// Check that we have a file name.
		if ( argv.length < 1 ) {
			System.out.println("No image file specified!");
			System.exit(1);
		}

		// New PICTReaderDemo frame.
		//new PNGReadDemo(argv[0]);
		PNGReader pr = new PNGReader();
		pr.setVerbose(true);
		pr.setImageFile(argv[0]);
		Image img = pr.getImage();
		if ( img != null ) {
			ImageFrame f = new ImageFrame(img);
			f.setSize(550, 500);
			f.show();
		}
	}
}



