
/*****************************************************************************
 *														                     *
 *                                  PICTShowDemo.java                        *
 *                                                                           *
 * Created by Kary FRAMLING 4/5/1998                                         *
 *                                                                           *
 *****************************************************************************/

import java.io.*;
import java.awt.*;
import fi.faidon.jvg.*;

/**
 * Example application for showing a PICT image in a frame. 
 *
 * @author Kary FR&Auml;MLING 5/5/1998
 */
public class PICTShowDemo
{

	//--------------------------------------------------------------------------------------
	// Private fields.
	//--------------------------------------------------------------------------------------
	private Frame	mainFrame;
	private Panel	mainPanel;
	private Canvas	drawCanvas;

	//--------------------------------------------------------------------------------------
	// Public methods.
	//--------------------------------------------------------------------------------------

	//=============================================================================
	// main
	//=============================================================================
	/**
	 * Main program. Takes the name of the PICT file as argument.
	 *
	 * @author Kary FR&Auml;MLING 5/5/1998
	 */
	//=============================================================================
	public static void main(String[] argv)
	{
		// Check that we have a file name.
		if ( argv.length < 1 ) {
			System.out.println("No image file specified!");
			System.exit(1);
		}

		// New PICTReaderDemo frame.
		new PICTShowDemo(argv[0]);
	}

	//=============================================================================
	// Constructor
	//=============================================================================
	/**
	 * Construct a new frame for showing the image at "path".
	 *
	 * @author Kary FR&Auml;MLING 5/5/1998
	 */
	//=============================================================================
	public PICTShowDemo(String path)
	{
		mainFrame = new Frame();
		mainFrame.setLayout(new FlowLayout());
		mainPanel = new Panel();
		mainPanel.setLayout(new FlowLayout());
//		mainPanel.setBackground(Color.yellow);
		mainFrame.add(mainPanel);
		drawCanvas = new PRDImageShowCanvas(path, 700, 500);
		mainPanel.add(drawCanvas);
		mainFrame.pack();
		mainFrame.show();
	}

}

/**
 * Override Canvas for showing out PICT image. 
 *
 * @author Kary FR&Auml;MLING 5/5/1998
 */
class PRDImageShowCanvas extends Canvas
{
	//--------------------------------------------------------------------------------------
	// Private fields.
	//--------------------------------------------------------------------------------------
	private String		filePath;
	private Image		myImage;
	private PICTReader	pr;

	//--------------------------------------------------------------------------------------
	// Public methods.
	//--------------------------------------------------------------------------------------

	//=============================================================================
	// Constructor
	//=============================================================================
	/**
	 * Initialize image path and canvas size.
	 *
	 * @author Kary FR&Auml;MLING 5/5/1998
	 */
	//=============================================================================
	public PRDImageShowCanvas(String path, int width, int height)
	{
		filePath = path;
		setSize(width, height);
	}

	//=============================================================================
	// paint
	//=============================================================================
	/**
	 * Paint the PICT. This could of course be optimized by offscreen drawing.
	 *
	 * @author Kary FR&Auml;MLING 5/5/1998
	 */
	//=============================================================================
	public void paint(Graphics g)
	{
		if ( pr == null ) {
			pr = new PICTReader();
			pr.setImageFile(filePath);
		}
		pr.playIt(g, this);
	}
}


