
/*****************************************************************************
 *														                     *
 *                                  PICTLister.java                          *
 *                                                                           *
 * Created by Kary FRAMLING 7/5/1998                                         *
 *                                                                           *
 *****************************************************************************/

import java.io.*;
import java.awt.*;
import fi.faidon.jvg.*;

/**
 * Example application for listing the contents of a PICT file. 
 *
 * @author Kary FR&Auml;MLING 7/5/1998
 */
public class PICTLister
{

	//=============================================================================
	// main
	//=============================================================================
	/**
	 * Program entry point.
	 *
	 * @author Kary FR&Auml;MLING 31/3/1998
	 */
	//=============================================================================
	public static void main(String[] argv)
	{
		// Verify that we have a picture file name.
		if ( argv.length < 1 ) {
			System.out.println("Usage: PICTread <name of PICT file>");
			System.exit(1);
		}
 
		PICTReader pr = new PICTReader();
		pr.setVerbose(true);
		pr.setImageFile(argv[0]);
		pr.readPICTFile();
		System.exit(0);
	}
}
