
/*****************************************************************************
 *														                     *
 *                          ImageSaveApplication.java                        *
 *                                                                           *
 * Small application for demonstrating the image saving beans.               *
 *                                                                           *
 * Created by Kary FRAMLING 16/3/1998                                        *
 *                                                                           *
 *****************************************************************************/

import java.io.*;
import java.awt.*;
import java.beans.*;
import java.awt.image.ImageObserver;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import fi.faidon.jis.*;
import fi.faidon.gui.*;

public class ImageSaveApplication extends Frame	
		implements ActionListener, PropertyChangeListener
{
	//--------------------------------------------------------------------------------------
	// Private constants.
	//--------------------------------------------------------------------------------------

	//--------------------------------------------------------------------------------------
	// Public fields.
	//--------------------------------------------------------------------------------------

	//--------------------------------------------------------------------------------------
	// Private fields.
	//--------------------------------------------------------------------------------------
	ImageSaverObject	saver;
	ImageShowBean		imageBean;
	FileOpenButtonBean	fileBean;
	Button				quitButton;
	Button				saveTIFFImageButton;
	Button				saveTargaImageButton;
	Button				savePICTImageButton;
	Button				saveBMPImageButton;
	Button				savePNGImageButton;

	//--------------------------------------------------------------------------------------
	// Public methods.
	//--------------------------------------------------------------------------------------
	public static void main(String[] argv)
	{
		new ImageSaveApplication();
	}

	//=============================================================================
	// Constructor
	//=============================================================================
	/**
	 * Set up contents, size and show it.
	 *
	 * Java code by KF 16/3/1998
	 */
	//=============================================================================
	public ImageSaveApplication()
	{
		// Create frame and set layout.
		super("ImageSaveApplication");
		setLayout(new BorderLayout());

		// Create and add image showing bean, file selector bean, save button
		// and quit button. 
		Panel ip = new Panel();
		ip.setLayout(new FlowLayout());
		add("Center", ip);
		imageBean = new ImageShowBean();
		ip.add(imageBean);
		Panel bp = new Panel();
		bp.setLayout(new FlowLayout());
		add("South", bp);
		fileBean = new FileOpenButtonBean();
		bp.add(fileBean);
		saveTIFFImageButton = new Button("Save TIFF");
		saveTIFFImageButton.addActionListener(this);
		bp.add(saveTIFFImageButton);
		saveTargaImageButton = new Button("Save Targa");
		saveTargaImageButton.addActionListener(this);
		bp.add(saveTargaImageButton);
		savePICTImageButton = new Button("Save PICT");
		savePICTImageButton.addActionListener(this);
		bp.add(savePICTImageButton);
		saveBMPImageButton = new Button("Save BMP");
		saveBMPImageButton.addActionListener(this);
		bp.add(saveBMPImageButton);
		savePNGImageButton = new Button("Save PNG");
		savePNGImageButton.addActionListener(this);
		bp.add(savePNGImageButton);
		quitButton = new Button("Quit");
		quitButton.addActionListener(this);
		bp.add(quitButton);

		// Create the image saver object.
		saver = new ImageSaverObject();

		// Set up the connections between the beans.
		setupBeanConnections();

		// Set initial size of the frame and show it.
		setSize(550, 400);
		show();
	}

	//=============================================================================
	// actionPerformed {OVERRIDE}
	//=============================================================================
	/**
	 * Catch Quit button action.
	 *
	 * Java code by KF 16/3/1998
	 */
	//=============================================================================
	public void actionPerformed(ActionEvent e)
	{
		// Quit?
		if ( e.getSource() == quitButton ) {
			// Wait until saving is ready.
			while ( (saver.checkSave() & ( ImageObserver.ALLBITS | ImageObserver.ABORT | ImageObserver.ERROR )) == 0 ) {
				try { Thread.sleep(100); } 
				catch ( InterruptedException ie ) { System.exit(1); }
			}
			System.exit(0);
		}
		// Save image?
		else if ( e.getSource() == saveTIFFImageButton ) {
			saver.saveAsTIFF();
		}
		else if ( e.getSource() == saveTargaImageButton) {
			saver.saveAsTarga();
		}
		else if ( e.getSource() == savePICTImageButton) {
			saver.saveAsPICT();
		}
		else if ( e.getSource() == saveBMPImageButton) {
			saver.saveAsBMP();
		}
		else if ( e.getSource() == savePNGImageButton) {
			// PNG isn't initially included in the JIS package, so we treat this 
			// more or less elegantly. 
			try {
				saver.saveAsPNG();
			}
			catch ( NoClassDefFoundError err ) {
				System.out.println("PNGImageSaver not found, verify that you have a package that supports PNG!");
			}
		}
	}

	//=============================================================================
	// propertyChange {OVERRIDE}
	//=============================================================================
	/**
	 * Dispatch property change events here. This would normally be done by the 
	 * bean application construction environment.
	 *
	 * Java code by KF 16/3/1998
	 */
	//=============================================================================
	public void propertyChange(PropertyChangeEvent evt)
	{
		if ( evt.getSource() == fileBean && evt.getPropertyName() == "filePath" ) {
			imageBean.setImagePath(fileBean.getFilePath());
		}
		else if	( evt.getSource() == imageBean && evt.getPropertyName() == "image" ) {
			saver.setSaveImage(imageBean.getImage());
		}
	}

	//--------------------------------------------------------------------------------------
	// Private methods.
	//--------------------------------------------------------------------------------------

	//=============================================================================
	// setupBeanConnections
	//=============================================================================
	/**
	 * Set up bean connections manually.
	 *
	 * Java code by KF 16/3/1998
	 */
	//=============================================================================
	private void setupBeanConnections()
	{
		// Set up the FileOpenButton -> ImageShowBean connection.
		imageBean.setImagePath(fileBean.getFilePath());
		fileBean.addPropertyChangeListener(this);

		// Set up ImageShowBean -> ImageSaverObject image connection.
		saver.setSaveImage(imageBean.getImage());
		imageBean.addPropertyChangeListener(this);
	}

}

