/*****************************************************************************
 *														                     *
 *                               ImageFrame.java                             *
 *                                                                           *
 * Created by Kary FRAMLING 28/4/1998                                        *
 *                                                                           *
 *****************************************************************************/

import java.awt.*;
import java.awt.event.*;
import fi.faidon.jvg.*;

/**
 * Simple utility class for displaying a window with two panels, one 
 * for displaying an Image or a GraphicsRecording and another for 
 * displaying an exit button.
 *
 * @author Kary FR&Auml;MLING 28/4/1998
 */
public class ImageFrame extends Frame implements ActionListener
{
	Button	exitButton;

    //-----------------------------------------------------------------
	// Constructor
    //-----------------------------------------------------------------
	/**
	 * Constructor for displaying an image.
	 *
	 * @author Kary FR&Auml;MLING
	 */
    //-----------------------------------------------------------------
	public ImageFrame(Image theImage)
	{
		IFImagePanel ip = new IFImagePanel(theImage);
		initFrame(ip);
	}

    //-----------------------------------------------------------------
	// Constructor
    //-----------------------------------------------------------------
	/**
	 * Constructor for displaying a GraphicsRecording.
	 *
	 * @author Kary FR&Auml;MLING
	 */
    //-----------------------------------------------------------------
	public ImageFrame(GraphicsRecording gr)
	{
		IFImagePanel ip = new IFImagePanel(gr);
		initFrame(ip);
	}

    //-----------------------------------------------------------------
	// initFrame
    //-----------------------------------------------------------------
	/**
	 * Set up the panels and their contents.
	 *
	 * @author Kary FR&Auml;MLING
	 */
    //-----------------------------------------------------------------
	private void initFrame(IFImagePanel ip)
	{
		setLayout(new BorderLayout());
		add("Center", ip);
		Panel button_panel = new Panel();
		add("South", button_panel);
		button_panel.setLayout(new FlowLayout());
		exitButton = new Button("Exit");
		exitButton.addActionListener(this);
		button_panel.add(exitButton);
	}

	public void actionPerformed(ActionEvent e) 
	{
		System.exit(0);
	}
}

/**
 * Panel for displaying the Image or GraphicsRecording.
 *
 * @author Kary FR&Auml;MLING 28/4/1998
 */
class IFImagePanel extends Panel
{
	Image	img;
	GraphicsRecording	recording;

    //-----------------------------------------------------------------
	// Constructor
    //-----------------------------------------------------------------
	/**
	 * Constructor for displaying an image.
	 *
	 * @author Kary FR&Auml;MLING
	 */
    //-----------------------------------------------------------------
	public IFImagePanel(Image theImage)
	{
		img = theImage;
	}

    //-----------------------------------------------------------------
	// Constructor
    //-----------------------------------------------------------------
	/**
	 * Constructor for displaying a GraphicsRecording.
	 *
	 * @author Kary FR&Auml;MLING
	 */
    //-----------------------------------------------------------------
	public IFImagePanel(GraphicsRecording gr)
	{
		recording = gr;
	}

    //-----------------------------------------------------------------
	// paint
    //-----------------------------------------------------------------
	/**
	 * Draw the Image or the GraphicsRecording.
	 *
	 * @author Kary FR&Auml;MLING
	 */
    //-----------------------------------------------------------------
	public void paint(Graphics g) 
	{
		if ( img != null ) {
			g.drawImage(img, 0, 0, this);
		}
		if ( recording != null ) {
			recording.playIt(g, this);
		}
	}

}
