/*
 * Decompiled with CFR 0.152.
 */
package fi.faidon.jvg;

import fi.faidon.jvg.VectorImageProducer;
import fi.faidon.util.ByteArrayConversion;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.MemoryImageSource;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;

public class PNGReader
extends VectorImageProducer {
    private final byte[] PNG_IDENTIFICATION_BYTES = new byte[]{-119, 80, 78, 71, 13, 10, 26, 10};
    private final int CHUNK_LENGTH_SIZE = 4;
    private final int CHUNK_TYPE_SIZE = 4;
    private final int CHUNK_CRC_SIZE = 4;
    private final int IHDR_DATA_SIZE = 13;
    private final int INFLATE_BUF_SIZE = 512;
    private final byte COLOR_TYPE_USE_ALPHA_CHANNEL = (byte)4;
    private final byte NO_FILTERING = 0;
    private final byte SUB_FILTER = 1;
    private final byte UP_FILTER = (byte)2;
    private final byte AVERAGE_FILTER = (byte)3;
    private final byte PAETH_FILTER = (byte)4;
    private final byte[] IHDR_CHUNK_TYPE = new byte[]{73, 72, 68, 82};
    private final byte[] IDAT_CHUNK_TYPE = new byte[]{73, 68, 65, 84};
    private final byte[] IEND_CHUNK_TYPE = new byte[]{73, 69, 78, 68};
    private File pictureFile;
    private FileInputStream pictureFIS;
    private BufferedInputStream pictureBIS;
    private Image pngImage;
    private boolean verbose = false;
    private int width;
    private int height;
    private int bitDepth;
    private int colorType;
    private int compressionMethod;
    private int filterMethod;
    private int interlaceMethod;
    private int version;
    private Graphics drawGraphics;
    private Component drawComponent;
    private boolean hdrIsRead = false;
    private byte[] rawPixmap;
    private int pixmapX;
    private int pixmapY;
    private int bytesPerPixel;
    private boolean useAlpha = false;

    public int getWidth() {
        if (!this.hdrIsRead) {
            this.getFrame();
        }
        return this.width;
    }

    public int getHeight() {
        if (!this.hdrIsRead) {
            this.getFrame();
        }
        return this.height;
    }

    public Image getImage() {
        if (this.pngImage == null) {
            this.readPNGFile();
        }
        return this.pngImage;
    }

    public void playIt(Graphics graphics, Component component) {
        this.drawGraphics = graphics;
        this.drawComponent = component;
        if (this.readPNGFile() && this.pngImage != null) {
            this.drawGraphics.drawImage(this.pngImage, 0, 0, this.drawComponent);
        }
    }

    public int checkImage() {
        return 32;
    }

    public void setImageFile(String string) {
        this.pictureFile = new File(string);
        this.hdrIsRead = false;
    }

    public void setVerbose(boolean bl) {
        this.verbose = bl;
    }

    public boolean isVerbose(boolean bl) {
        return this.verbose;
    }

    public boolean readPNGFile() {
        if (!this.getInputStreams()) {
            return false;
        }
        if (!this.readHeader(this.pictureBIS)) {
            if (this.verbose) {
                System.out.println("Error parsing file!");
            }
            this.closeInputStreams();
            return false;
        }
        if (!this.readChunks(this.pictureBIS)) {
            this.closeInputStreams();
            if (this.verbose) {
                System.out.println("Error parsing file!");
            }
            return false;
        }
        this.closeInputStreams();
        if (this.verbose) {
            System.out.println("Finished reading file!");
        }
        return true;
    }

    private boolean getFrame() {
        if (!this.getInputStreams()) {
            return false;
        }
        if (!this.readHeader(this.pictureBIS)) {
            if (this.verbose) {
                System.out.println("Error parsing file!");
            }
            this.closeInputStreams();
            return false;
        }
        this.closeInputStreams();
        return true;
    }

    private boolean getInputStreams() {
        if (this.pictureFile == null || !this.pictureFile.exists()) {
            return false;
        }
        try {
            this.pictureFIS = new FileInputStream(this.pictureFile);
            this.pictureBIS = new BufferedInputStream(this.pictureFIS);
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }

    private void closeInputStreams() {
        try {
            if (this.pictureBIS != null) {
                ((FilterInputStream)this.pictureBIS).close();
            }
            if (this.pictureFIS != null) {
                this.pictureFIS.close();
                return;
            }
        }
        catch (IOException iOException) {}
    }

    private boolean readHeader(BufferedInputStream bufferedInputStream) {
        byte[] byArray = new byte[25];
        if (bufferedInputStream == null) {
            return false;
        }
        try {
            byte[] byArray2 = new byte[this.PNG_IDENTIFICATION_BYTES.length];
            this.fillByteBuf(bufferedInputStream, byArray2, 0, byArray2.length);
            int n = 0;
            while (n < byArray2.length && n < this.PNG_IDENTIFICATION_BYTES.length) {
                if (byArray2[n] != this.PNG_IDENTIFICATION_BYTES[n]) {
                    if (this.verbose) {
                        System.out.println("Not valid PNG file identifier!");
                    }
                    return false;
                }
                ++n;
            }
            this.fillByteBuf(bufferedInputStream, byArray, 0, byArray.length);
            int n2 = ByteArrayConversion.bytesLEasUINT(byArray, 0, 4);
            if (n2 != 13) {
                if (this.verbose) {
                    System.out.println("Wrong IHDR data size!");
                }
                return false;
            }
            n = 0;
            while (n < 4) {
                if (byArray[n + 4] != this.IHDR_CHUNK_TYPE[n]) {
                    if (this.verbose) {
                        System.out.println("File does not begin with an IHDR chunk!");
                    }
                    return false;
                }
                ++n;
            }
            this.width = ByteArrayConversion.bytesLEasUINT(byArray, 8, 12);
            this.height = ByteArrayConversion.bytesLEasUINT(byArray, 12, 16);
            this.bitDepth = ByteArrayConversion.bytesLEasUINT(byArray, 16, 17);
            this.colorType = ByteArrayConversion.bytesLEasUINT(byArray, 17, 18);
            this.compressionMethod = ByteArrayConversion.bytesLEasUINT(byArray, 18, 19);
            this.filterMethod = ByteArrayConversion.bytesLEasUINT(byArray, 19, 20);
            this.interlaceMethod = ByteArrayConversion.bytesLEasUINT(byArray, 20, 21);
            if (this.verbose) {
                System.out.println("IHDR, width: " + this.width + ", height: " + this.height + ", bitDepth: " + this.bitDepth + ", colorType: " + this.colorType + ", compressionMethod: " + this.compressionMethod + ", filterMethod: " + this.filterMethod + ", interlaceMethod: " + this.interlaceMethod);
            }
            this.bytesPerPixel = 3;
            if ((this.colorType & 4) > 0) {
                this.bytesPerPixel = 4;
                this.useAlpha = true;
            }
        }
        catch (IOException iOException) {
            this.closeInputStreams();
            return false;
        }
        this.hdrIsRead = true;
        return true;
    }

    private boolean readChunks(BufferedInputStream bufferedInputStream) {
        int n;
        byte[] byArray = new byte[8];
        byte[] byArray2 = new byte[4];
        byte[] byArray3 = new byte[512];
        byte[] byArray4 = new byte[512];
        boolean bl = false;
        boolean bl2 = true;
        Inflater inflater = new Inflater();
        if (bufferedInputStream == null) {
            return false;
        }
        this.rawPixmap = new byte[this.width * this.height * this.bytesPerPixel];
        this.pixmapY = 0;
        this.pixmapX = 0;
        int n2 = 0;
        int n3 = 0;
        byte by = 0;
        try {
            while (!bl) {
                this.fillByteBuf(bufferedInputStream, byArray, 0, byArray.length);
                int n4 = ByteArrayConversion.bytesLEasUINT(byArray, 0, 4);
                if (this.verbose) {
                    System.out.println("Chunk data length: " + n4);
                }
                switch (byArray[4]) {
                    case 73: {
                        if (byArray[5] == this.IDAT_CHUNK_TYPE[1] && byArray[6] == this.IDAT_CHUNK_TYPE[2] && byArray[7] == this.IDAT_CHUNK_TYPE[3]) {
                            if (this.verbose) {
                                System.out.println("IDAT chunk.");
                            }
                            int n5 = 0;
                            while (n5 < n4) {
                                this.fillByteBuf(bufferedInputStream, byArray3, 0, Math.min(byArray3.length, n4 - n5));
                                inflater.setInput(byArray3, 0, Math.min(byArray3.length, n4 - n5));
                                while (!inflater.needsInput()) {
                                    try {
                                        int n6 = inflater.inflate(byArray4);
                                        n = 0;
                                        while (n < n6) {
                                            if (bl2) {
                                                by = byArray4[n];
                                                bl2 = false;
                                            } else if (n2 == this.width * this.bytesPerPixel) {
                                                this.pixmapX = 0;
                                                ++this.pixmapY;
                                                by = byArray4[n];
                                                n2 = 0;
                                            } else {
                                                switch (n2 % this.bytesPerPixel) {
                                                    case 0: {
                                                        int n7 = this.getFltrValue(by, byArray4[n] & 0xFF, this.rawPixmap, n3);
                                                        this.rawPixmap[n3++] = (byte)(n7 & 0xFF);
                                                        break;
                                                    }
                                                    case 1: {
                                                        int n8 = this.getFltrValue(by, byArray4[n] & 0xFF, this.rawPixmap, n3);
                                                        this.rawPixmap[n3++] = (byte)(n8 & 0xFF);
                                                        break;
                                                    }
                                                    case 2: {
                                                        int n9 = this.getFltrValue(by, byArray4[n] & 0xFF, this.rawPixmap, n3);
                                                        this.rawPixmap[n3++] = (byte)(n9 & 0xFF);
                                                        break;
                                                    }
                                                    case 3: {
                                                        int n10 = this.getFltrValue(by, byArray4[n] & 0xFF, this.rawPixmap, n3);
                                                        this.rawPixmap[n3++] = (byte)(n10 & 0xFF);
                                                        break;
                                                    }
                                                }
                                                if (n2 % this.bytesPerPixel == this.bytesPerPixel - 1) {
                                                    ++this.pixmapX;
                                                }
                                                ++n2;
                                            }
                                            ++n;
                                        }
                                    }
                                    catch (DataFormatException dataFormatException) {
                                        if (this.verbose) {
                                            System.out.println("DataFormatException: " + dataFormatException);
                                        }
                                        return false;
                                    }
                                }
                                n5 += 512;
                            }
                            break;
                        }
                        if (byArray[5] != this.IEND_CHUNK_TYPE[1] || byArray[6] != this.IEND_CHUNK_TYPE[2] || byArray[7] != this.IEND_CHUNK_TYPE[3]) break;
                        if (this.verbose) {
                            System.out.println("IEND chunk.");
                        }
                        bl = true;
                        break;
                    }
                    default: {
                        this.fillByteBuf(bufferedInputStream, new byte[n4], 0, n4);
                        if (!this.verbose) break;
                        System.out.println("Unknown chunk: " + new String(byArray, 4, 4));
                    }
                }
                this.fillByteBuf(bufferedInputStream, byArray2, 0, byArray2.length);
            }
        }
        catch (IOException iOException) {
            if (this.verbose) {
                System.out.println("IOException: " + iOException);
            }
            this.closeInputStreams();
            return false;
        }
        int[] nArray = new int[this.width * this.height];
        n = 0;
        int n11 = 0;
        while (n < this.width * this.height) {
            nArray[n] = this.useAlpha ? (this.rawPixmap[n11] & 0xFF) << 16 | (this.rawPixmap[n11 + 1] & 0xFF) << 8 | this.rawPixmap[n11 + 2] & 0xFF | (this.rawPixmap[n11 + 3] & 0xFF) << 24 : 0xFF000000 | (this.rawPixmap[n11] & 0xFF) << 16 | (this.rawPixmap[n11 + 1] & 0xFF) << 8 | this.rawPixmap[n11 + 2] & 0xFF;
            ++n;
            n11 += this.bytesPerPixel;
        }
        this.pngImage = Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(this.width, this.height, nArray, 0, this.width));
        return true;
    }

    private int getFltrValue(int n, int n2, byte[] byArray, int n3) {
        int n4 = n3 - this.bytesPerPixel;
        int n5 = this.pixmapX <= 0 ? 0 : byArray[n4] & 0xFF;
        n4 = n3 - this.bytesPerPixel * this.width;
        int n6 = this.pixmapY <= 0 ? 0 : byArray[n4] & 0xFF;
        int n7 = this.pixmapX <= 0 || this.pixmapY <= 0 ? 0 : byArray[n4 -= this.bytesPerPixel] & 0xFF;
        switch (n) {
            case 0: {
                return n2;
            }
            case 1: {
                return (n2 & 0xFF) + n5 & 0xFF;
            }
            case 2: {
                return (n2 & 0xFF) + n6 & 0xFF;
            }
            case 3: {
                return (n2 & 0xFF) + (n5 + n6) / 2 & 0xFF & 0xFF;
            }
            case 4: {
                return (n2 & 0xFF) + this.paethPredictor(n5, n6, n7) & 0xFF & 0xFF;
            }
        }
        return n2;
    }

    private int paethPredictor(int n, int n2, int n3) {
        int n4 = n + n2 - n3;
        int n5 = Math.abs(n4 - n);
        int n6 = Math.abs(n4 - n2);
        int n7 = Math.abs(n4 - n3);
        if (n5 <= n6 && n5 <= n7) {
            return n;
        }
        if (n6 <= n7) {
            return n2;
        }
        return n3;
    }

    private void fillByteBuf(InputStream inputStream, byte[] byArray, int n, int n2) throws IOException {
        while (n2 > 0) {
            int n3 = inputStream.read(byArray, n, n2);
            if (n3 == -1) {
                throw new IOException("Unexpected EOF");
            }
            n += n3;
            n2 -= n3;
        }
    }
}

