/*
 * Decompiled with CFR 0.152.
 */
package fi.faidon.jvg;

import fi.faidon.jvg.VectorImageProducer;
import fi.faidon.util.DataCompression;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.image.MemoryImageSource;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;

public class PICTReader
extends VectorImageProducer {
    public static final int SRC_COPY = 0;
    public static final int SRC_OR = 1;
    public static final int SRC_XOR = 2;
    public static final int SRC_BIC = 3;
    public static final int NOT_SRC_COPY = 4;
    public static final int NOT_SRC_OR = 5;
    public static final int NOT_SRC_XOR = 6;
    public static final int NOT_SRC_BIC = 7;
    public static final int BLEND = 32;
    public static final int ADD_PIN = 33;
    public static final int ADD_OVER = 34;
    public static final int SUB_PIN = 35;
    public static final int TRANSPARENT = 36;
    public static final int AD_MAX = 37;
    public static final int SUB_OVER = 38;
    public static final int AD_MIN = 39;
    public static final int GRAYISH_TEXT_OR = 49;
    public static final int MASK = 64;
    public static final int TX_BOLD_MASK = 1;
    public static final int TX_ITALIC_MASK = 2;
    public static final int TX_UNDERLINE_MASK = 4;
    public static final int TX_OUTLINE_MASK = 8;
    public static final int TX_SHADOWED_MASK = 16;
    public static final int TX_CONDENSED_MASK = 32;
    public static final int TX_EXTENDED_MASK = 64;
    public static final byte[] OP_HEADER_OP;
    public static final int NOP = 0;
    public static final int OP_CLIP_RGN = 1;
    public static final int OP_BK_PAT = 2;
    public static final int OP_TX_FONT = 3;
    public static final int OP_TX_FACE = 4;
    public static final int OP_TX_MODE = 5;
    public static final int OP_SP_EXTRA = 6;
    public static final int OP_PN_SIZE = 7;
    public static final int OP_PN_MODE = 8;
    public static final int OP_PN_PAT = 9;
    public static final int OP_FILL_PAT = 10;
    public static final int OP_OV_SIZE = 11;
    public static final int OP_ORIGIN = 12;
    public static final int OP_TX_SIZE = 13;
    public static final int OP_FG_COLOR = 14;
    public static final int OP_BK_COLOR = 15;
    public static final int OP_TX_RATIO = 16;
    public static final int OP_VERSION = 17;
    public static final int OP_BK_PIX_PAT = 18;
    public static final int OP_PN_PIX_PAT = 19;
    public static final int OP_FILL_PIX_PAT = 20;
    public static final int OP_PN_LOC_H_FRAC = 21;
    public static final int OP_CH_EXTRA = 22;
    public static final int OP_RGB_FG_COL = 26;
    public static final int OP_RGB_BK_COL = 27;
    public static final int OP_HILITE_MODE = 28;
    public static final int OP_HILITE_COLOR = 29;
    public static final int OP_DEF_HILITE = 30;
    public static final int OP_OP_COLOR = 31;
    public static final int OP_LINE = 32;
    public static final int OP_LINE_FROM = 33;
    public static final int OP_SHORT_LINE = 34;
    public static final int OP_SHORT_LINE_FROM = 35;
    public static final int OP_LONG_TEXT = 40;
    public static final int OP_DH_TEXT = 41;
    public static final int OP_DV_TEXT = 42;
    public static final int OP_DHDV_TEXT = 43;
    public static final int OP_FONT_NAME = 44;
    public static final int OP_LINE_JUSTIFY = 45;
    public static final int OP_GLYPH_STATE = 46;
    public static final int OP_FRAME_RECT = 48;
    public static final int OP_PAINT_RECT = 49;
    public static final int OP_ERASE_RECT = 50;
    public static final int OP_INVERT_RECT = 51;
    public static final int OP_FILL_RECT = 52;
    public static final int OP_FRAME_SAME_RECT = 56;
    public static final int OP_PAINT_SAME_RECT = 57;
    public static final int OP_ERASE_SAME_RECT = 58;
    public static final int OP_INVERT_SAME_RECT = 59;
    public static final int OP_FILL_SAME_RECT = 60;
    public static final int OP_FRAME_R_RECT = 64;
    public static final int OP_PAINT_R_RECT = 65;
    public static final int OP_ERASE_R_RECT = 66;
    public static final int OP_INVERT_R_RECT = 67;
    public static final int OP_FILL_R_RECT = 68;
    public static final int OP_FRAME_SAME_R_RECT = 72;
    public static final int OP_PAINT_SAME_R_RECT = 73;
    public static final int OP_ERASE_SAME_R_RECT = 74;
    public static final int OP_INVERT_SAME_R_RECT = 75;
    public static final int OP_FILL_SAME_R_RECT = 76;
    public static final int OP_FRAME_OVAL = 80;
    public static final int OP_PAINT_OVAL = 81;
    public static final int OP_ERASE_OVAL = 82;
    public static final int OP_INVERT_OVAL = 83;
    public static final int OP_FILL_OVAL = 84;
    public static final int OP_FRAME_SAME_OVAL = 88;
    public static final int OP_PAINT_SAME_OVAL = 89;
    public static final int OP_ERASE_SAME_OVAL = 90;
    public static final int OP_INVERT_SAME_OVAL = 91;
    public static final int OP_FILL_SAME_OVAL = 92;
    public static final int OP_FRAME_ARC = 96;
    public static final int OP_PAINT_ARC = 97;
    public static final int OP_ERASE_ARC = 98;
    public static final int OP_INVERT_ARC = 99;
    public static final int OP_FILL_ARC = 100;
    public static final int OP_FRAME_SAME_ARC = 104;
    public static final int OP_PAINT_SAME_ARC = 105;
    public static final int OP_ERASE_SAME_ARC = 106;
    public static final int OP_INVERT_SAME_ARC = 107;
    public static final int OP_FILL_SAME_ARC = 108;
    public static final int OP_FRAME_POLY = 112;
    public static final int OP_PAINT_POLY = 113;
    public static final int OP_ERASE_POLY = 114;
    public static final int OP_INVERT_POLY = 115;
    public static final int OP_FILL_POLY = 116;
    public static final int OP_FRAME_SAME_POLY = 120;
    public static final int OP_PAINT_SAME_POLY = 121;
    public static final int OP_ERASE_SAME_POLY = 122;
    public static final int OP_INVERT_SAME_POLY = 123;
    public static final int OP_FILL_SAME_POLY = 124;
    public static final int OP_FRAME_RGN = 128;
    public static final int OP_PAINT_RGN = 129;
    public static final int OP_ERASE_RGN = 130;
    public static final int OP_INVERT_RGN = 131;
    public static final int OP_FILL_RGN = 132;
    public static final int OP_FRAME_SAME_RGN = 136;
    public static final int OP_PAINT_SAME_RGN = 137;
    public static final int OP_ERASE_SAME_RGN = 138;
    public static final int OP_INVERT_SAME_RGN = 139;
    public static final int OP_FILL_SAME_RGN = 140;
    public static final int OP_BITS_RECT = 144;
    public static final int OP_BITS_RGN = 145;
    public static final int OP_PACK_BITS_RECT = 152;
    public static final int OP_PACK_BITS_RGN = 153;
    public static final int OP_DIRECT_BITS_RECT = 154;
    public static final int OP_DIRECT_BITS_RGN = 155;
    public static final int OP_SHORT_COMMENT = 160;
    public static final int OP_LONG_COMMENT = 161;
    public static final int OP_END_OF_PICTURE = 255;
    public static final int OP_VERSION_2 = 767;
    public static final int OP_COMPRESSED_QUICKTIME = 33280;
    public static final int OP_UNCOMPRESSED_QUICKTIME = 33281;
    private static final int PICT_NULL_HEADER_SIZE = 512;
    private static final int NBR_BYTES_IN_WORD = 2;
    private static final int NBR_BYTES_IN_LONG = 4;
    private static final int MIN_REGION_SIZE = 10;
    private static final int MIN_POLY_SIZE = 10;
    private static final int NBR_BYTES_PICT_COLOR_COMP = 2;
    private String APPLE_USE_RESERVED_FIELD_STR = "Reserved for Apple use.";
    private File pictureFile;
    private FileInputStream pictureFIS;
    private BufferedInputStream pictureBIS;
    private Graphics drawGraphics;
    private Component drawComponent;
    private boolean verbose = false;
    private int picSize;
    private Rectangle pictFrame;
    private int version;
    private boolean isExtendedVersion2;
    private Point penPosition = new Point(0, 0);
    private Rectangle lastRectangle = new Rectangle(0, 0);
    private double screenImageXRatio;
    private double screenImageYRatio;
    private Color fgColor = Color.black;
    private Color bgColor = Color.white;
    private Color hiliteColor = Color.red;
    private Vector imgVector;

    public int getWidth() {
        if (this.pictFrame == null) {
            this.getPICTFrame();
        }
        return this.pictFrame.width;
    }

    public int getHeight() {
        if (this.pictFrame == null) {
            this.getPICTFrame();
        }
        return this.pictFrame.height;
    }

    public void playIt(Graphics graphics, Component component) {
        this.drawGraphics = graphics;
        this.drawComponent = component;
        this.readPICTFile();
    }

    public int checkImage() {
        return 32;
    }

    public void setImageFile(String string) {
        this.pictureFile = new File(string);
        this.pictFrame = null;
    }

    public void setVerbose(boolean bl) {
        this.verbose = bl;
    }

    public boolean isVerbose(boolean bl) {
        return this.verbose;
    }

    public boolean readPICTFile() {
        if (!this.getInputStreams()) {
            return false;
        }
        if (!this.readPICTHeader(this.pictureBIS)) {
            if (this.verbose) {
                System.out.println("Error parsing file!");
            }
            this.closeInputStreams();
            return false;
        }
        if (!this.readPICTopcodes(this.pictureBIS)) {
            this.closeInputStreams();
            if (this.verbose) {
                System.out.println("Error parsing file!");
            }
            return false;
        }
        this.closeInputStreams();
        if (this.verbose) {
            System.out.println("Finished reading file!");
        }
        return true;
    }

    private boolean getPICTFrame() {
        if (!this.getInputStreams()) {
            return false;
        }
        if (!this.readPICTHeader(this.pictureBIS)) {
            if (this.verbose) {
                System.out.println("Error parsing file!");
            }
            this.closeInputStreams();
            return false;
        }
        this.closeInputStreams();
        return true;
    }

    private boolean getInputStreams() {
        if (this.pictureFile == null || !this.pictureFile.exists()) {
            return false;
        }
        try {
            this.pictureFIS = new FileInputStream(this.pictureFile);
            this.pictureBIS = new BufferedInputStream(this.pictureFIS);
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }

    private void closeInputStreams() {
        try {
            if (this.pictureBIS != null) {
                ((FilterInputStream)this.pictureBIS).close();
            }
            if (this.pictureFIS != null) {
                this.pictureFIS.close();
                return;
            }
        }
        catch (IOException iOException) {}
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean readPICTHeader(BufferedInputStream bufferedInputStream) {
        byte[] byArray = new byte[2];
        byte[] byArray2 = new byte[8];
        if (bufferedInputStream == null) {
            return false;
        }
        try {
            this.fillByteBuf(bufferedInputStream, new byte[512], 0, 512);
            this.fillByteBuf(bufferedInputStream, byArray, 0, byArray.length);
            this.picSize = this.getBytesAsInt(byArray, 0, byArray.length);
            if (this.verbose) {
                System.out.println("picSize: " + this.picSize);
            }
            this.fillByteBuf(bufferedInputStream, byArray2, 0, byArray2.length);
            this.pictFrame = new Rectangle(this.getBytesAsInt(byArray2, 2, 4), this.getBytesAsInt(byArray2, 0, 2), this.getBytesAsInt(byArray2, 6, 8), this.getBytesAsInt(byArray2, 4, 6));
            if (this.verbose) {
                System.out.println("pictFrame: " + this.pictFrame);
            }
            int n = 72;
            this.screenImageXRatio = 1.0;
            this.screenImageYRatio = 1.0;
            this.fillByteBuf(bufferedInputStream, byArray, 0, byArray.length);
            if (byArray[0] == 17 && byArray[1] == 1) {
                this.version = 1;
            } else {
                if (byArray[0] != 0 || byArray[1] != 17) return false;
                this.fillByteBuf(bufferedInputStream, byArray, 0, byArray.length);
                if (byArray[0] != 2 || byArray[1] != -1) return false;
                this.version = 2;
                this.fillByteBuf(bufferedInputStream, byArray, 0, byArray.length);
                if (byArray[0] != OP_HEADER_OP[0] || byArray[1] != OP_HEADER_OP[1]) {
                    return false;
                }
                byte[] byArray3 = new byte[24];
                this.fillByteBuf(bufferedInputStream, byArray3, 0, byArray3.length);
                if (byArray3[1] == -2) {
                    this.isExtendedVersion2 = true;
                    int n2 = this.getBytesAsInt(byArray3, 4, 6);
                    int n3 = this.getBytesAsInt(byArray3, 8, 10);
                    this.screenImageXRatio = (double)n / (double)n2;
                    this.screenImageYRatio = (double)n / (double)n3;
                    if (this.verbose) {
                        System.out.println("xResolution: " + n2);
                    }
                    if (this.verbose) {
                        System.out.println("yResolution: " + n3);
                    }
                    if (this.verbose) {
                        System.out.println("screenImageXRatio: " + this.screenImageXRatio);
                    }
                    if (this.verbose) {
                        System.out.println("screenImageYRatio: " + this.screenImageYRatio);
                    }
                }
            }
            if (this.verbose) {
                System.out.println("Version: " + this.version);
            }
            if (!this.verbose) return true;
            System.out.println("isExtendedVersion2: " + this.isExtendedVersion2);
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    private boolean readPICTopcodes(BufferedInputStream bufferedInputStream) {
        byte[] byArray = new byte[1];
        byte[] byArray2 = new byte[2];
        byte[] byArray3 = new byte[1];
        byte[] byArray4 = new byte[2];
        byte[] byArray5 = new byte[4];
        byte[] byArray6 = new byte[8];
        byte[] byArray7 = new byte[4];
        byte[] byArray8 = new byte[6];
        Point point = new Point();
        Point point2 = new Point();
        Point point3 = new Point();
        long l = 0L;
        Rectangle rectangle = new Rectangle();
        Polygon polygon = new Polygon();
        Polygon polygon2 = new Polygon();
        Font font = null;
        int n = 0;
        if (this.drawGraphics != null) {
            font = this.drawGraphics.getFont();
        }
        try {
            int n2;
            block115: do {
                if (this.version == 1) {
                    this.fillByteBuf(bufferedInputStream, byArray, 0, byArray.length);
                    ++l;
                    n2 = this.getBytesAsInt(byArray, 0, byArray.length);
                } else {
                    if ((l & 1L) > 0L) {
                        this.fillByteBuf(bufferedInputStream, byArray3, 0, 1);
                        ++l;
                    }
                    this.fillByteBuf(bufferedInputStream, byArray2, 0, byArray2.length);
                    l += 2L;
                    n2 = this.getBytesAsInt(byArray2, 0, byArray2.length);
                }
                switch (n2) {
                    case 0: {
                        if (!this.verbose) break;
                        System.out.print("NOP");
                        break;
                    }
                    case 1: {
                        polygon2 = this.readRegion(bufferedInputStream, rectangle);
                        if (polygon2 == null) {
                            return false;
                        }
                        if (this.drawGraphics != null && polygon2.npoints == 0) {
                            this.drawGraphics.setClip(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                        }
                        if (!this.verbose) break;
                        this.verboseRegionCmd("clipRgn", rectangle, polygon2);
                        break;
                    }
                    case 2: {
                        this.fillByteBuf(bufferedInputStream, new byte[8], 0, 8);
                        l += 8L;
                        if (!this.verbose) break;
                        System.out.println("bkPat");
                        break;
                    }
                    case 3: {
                        this.fillByteBuf(bufferedInputStream, new byte[2], 0, 2);
                        l += 2L;
                        if (!this.verbose) break;
                        System.out.println("txFont");
                        break;
                    }
                    case 4: {
                        this.fillByteBuf(bufferedInputStream, byArray3, 0, byArray3.length);
                        l += (long)byArray3.length;
                        if (this.drawGraphics != null) {
                            font = this.drawGraphics.getFont();
                            int n3 = 0;
                            if ((byArray3[0] & 1) > 0) {
                                n3 |= 1;
                            }
                            if ((byArray3[0] & 2) > 0) {
                                n3 |= 2;
                            }
                            this.drawGraphics.setFont(new Font(font.getName(), n3, font.getSize()));
                        }
                        if (!this.verbose) break;
                        System.out.println("txFace: " + byArray3[0]);
                        break;
                    }
                    case 5: {
                        byte[] byArray9 = new byte[2];
                        this.fillByteBuf(bufferedInputStream, byArray9, 0, byArray9.length);
                        l += (long)byArray9.length;
                        if (!this.verbose) break;
                        System.out.println("txMode: " + byArray9[0] + ", " + byArray9[1]);
                        break;
                    }
                    case 6: {
                        this.fillByteBuf(bufferedInputStream, new byte[4], 0, 4);
                        l += 4L;
                        if (!this.verbose) break;
                        System.out.println("spExtra");
                        break;
                    }
                    case 7: {
                        this.fillByteBuf(bufferedInputStream, byArray5, 0, byArray5.length);
                        l += (long)byArray5.length;
                        Point point4 = new Point(this.getBytesAsInt(byArray5, 0, 2), this.getBytesAsInt(byArray5, 2, 4));
                        if (!this.verbose) break;
                        System.out.println("pnsize: " + point4);
                        break;
                    }
                    case 8: {
                        this.fillByteBuf(bufferedInputStream, new byte[2], 0, 2);
                        l += 2L;
                        if (!this.verbose) break;
                        System.out.println("pnMode");
                        break;
                    }
                    case 9: {
                        this.fillByteBuf(bufferedInputStream, new byte[8], 0, 8);
                        l += 8L;
                        if (!this.verbose) break;
                        System.out.println("pnPat");
                        break;
                    }
                    case 10: {
                        this.fillByteBuf(bufferedInputStream, new byte[8], 0, 8);
                        l += 8L;
                        if (!this.verbose) break;
                        System.out.println("fillPat");
                        break;
                    }
                    case 11: {
                        this.fillByteBuf(bufferedInputStream, byArray5, 0, byArray5.length);
                        l += (long)byArray5.length;
                        this.setPointFromBuf(byArray5, point);
                        point.x *= 2;
                        point.y *= 2;
                        if (!this.verbose) break;
                        System.out.println("ovSize: " + point);
                        break;
                    }
                    case 12: {
                        this.fillByteBuf(bufferedInputStream, byArray5, 0, byArray5.length);
                        l += (long)byArray5.length;
                        Point point5 = new Point(this.getXPtCoord(this.getBytesAsInt(byArray5, 2, 4)), this.getYPtCoord(this.getBytesAsInt(byArray5, 0, 2)));
                        if (this.drawGraphics != null) {
                            this.drawGraphics.translate(point5.x, point5.y);
                        }
                        if (!this.verbose) break;
                        System.out.println("Origin: " + point5);
                        break;
                    }
                    case 13: {
                        this.fillByteBuf(bufferedInputStream, byArray4, 0, byArray4.length);
                        l += (long)byArray4.length;
                        int n4 = this.getYPtCoord(this.getBytesAsInt(byArray4, 0, byArray4.length));
                        if (this.drawGraphics != null) {
                            font = this.drawGraphics.getFont();
                            this.drawGraphics.setFont(new Font(font.getName(), font.getStyle(), n4));
                        }
                        if (!this.verbose) break;
                        System.out.println("txSize: " + n4);
                        break;
                    }
                    case 14: {
                        this.fillByteBuf(bufferedInputStream, byArray7, 0, byArray7.length);
                        l += (long)byArray7.length;
                        if (!this.verbose) break;
                        System.out.println("fgColor");
                        break;
                    }
                    case 15: {
                        this.fillByteBuf(bufferedInputStream, byArray7, 0, byArray7.length);
                        if (!this.verbose) break;
                        System.out.println("bgColor");
                        break;
                    }
                    case 16: {
                        this.fillByteBuf(bufferedInputStream, new byte[8], 0, 8);
                        l += 8L;
                        if (!this.verbose) break;
                        System.out.println("txRatio");
                        break;
                    }
                    case 17: {
                        this.fillByteBuf(bufferedInputStream, new byte[1], 0, 1);
                        ++l;
                        if (!this.verbose) break;
                        System.out.println("opVersion");
                        break;
                    }
                    case 21: {
                        this.fillByteBuf(bufferedInputStream, new byte[2], 0, 2);
                        l += 2L;
                        if (!this.verbose) break;
                        System.out.println("opPnLocHFrac");
                        break;
                    }
                    case 22: {
                        this.fillByteBuf(bufferedInputStream, new byte[2], 0, 2);
                        l += 2L;
                        if (!this.verbose) break;
                        System.out.println("opChExtra");
                        break;
                    }
                    case 26: {
                        this.fillByteBuf(bufferedInputStream, byArray8, 0, byArray8.length);
                        l += (long)byArray8.length;
                        this.fgColor = new Color(byArray8[0] & 0xFF, byArray8[2] & 0xFF, byArray8[4] & 0xFF);
                        if (this.drawGraphics != null) {
                            this.drawGraphics.setColor(this.fgColor);
                        }
                        if (!this.verbose) break;
                        System.out.println("rgbFgColor: " + this.fgColor);
                        break;
                    }
                    case 27: {
                        this.fillByteBuf(bufferedInputStream, byArray8, 0, byArray8.length);
                        l += (long)byArray8.length;
                        this.bgColor = new Color(byArray8[0] & 0xFF, byArray8[2] & 0xFF, byArray8[4] & 0xFF);
                        if (!this.verbose) break;
                        System.out.println("rgbBgColor: " + this.bgColor);
                        break;
                    }
                    case 28: {
                        if (!this.verbose) break;
                        System.out.println("opHiliteMode");
                        break;
                    }
                    case 29: {
                        this.fillByteBuf(bufferedInputStream, byArray8, 0, byArray8.length);
                        l += (long)byArray8.length;
                        this.hiliteColor = new Color(byArray8[0] & 0xFF, byArray8[2] & 0xFF, byArray8[4] & 0xFF);
                        if (this.verbose) {
                            System.out.println("opHiliteColor: " + this.hiliteColor);
                        }
                        l += (long)byArray8.length;
                        break;
                    }
                    case 30: {
                        if (!this.verbose) break;
                        System.out.println("opDefHilite");
                        break;
                    }
                    case 31: {
                        this.fillByteBuf(bufferedInputStream, byArray8, 0, byArray8.length);
                        l += (long)byArray8.length;
                        if (!this.verbose) break;
                        System.out.println("opOpColor");
                        break;
                    }
                    case 32: {
                        this.fillByteBuf(bufferedInputStream, byArray5, 0, byArray5.length);
                        Point point5 = new Point();
                        this.setPointFromBuf(byArray5, point5);
                        this.fillByteBuf(bufferedInputStream, byArray5, 0, byArray5.length);
                        this.setPointFromBuf(byArray5, this.penPosition);
                        if (this.drawGraphics != null) {
                            this.drawGraphics.drawLine(point5.x, point5.y, this.penPosition.x, this.penPosition.y);
                        }
                        if (this.verbose) {
                            System.out.println("line from: " + point5 + " to: " + this.penPosition);
                        }
                        l += (long)(2 * byArray5.length);
                        break;
                    }
                    case 33: {
                        Point point5 = new Point(this.penPosition);
                        this.fillByteBuf(bufferedInputStream, byArray5, 0, byArray5.length);
                        this.setPointFromBuf(byArray5, this.penPosition);
                        if (this.drawGraphics != null) {
                            this.drawGraphics.drawLine(point5.x, point5.y, this.penPosition.x, this.penPosition.y);
                        }
                        if (this.verbose) {
                            System.out.println("lineFrom to: " + this.penPosition);
                        }
                        l += (long)byArray5.length;
                        break;
                    }
                    case 34: {
                        this.fillByteBuf(bufferedInputStream, byArray5, 0, byArray5.length);
                        Point point5 = new Point();
                        this.setPointFromBuf(byArray5, point5);
                        this.fillByteBuf(bufferedInputStream, byArray4, 0, byArray4.length);
                        Point point6 = new Point(this.getXPtCoord(this.bytesAsSignedInt(byArray4, 0, 1)), this.getYPtCoord(this.bytesAsSignedInt(byArray4, 1, 2)));
                        this.penPosition.setLocation(point5.x + point6.x, point5.y + point6.y);
                        if (this.drawGraphics != null) {
                            this.drawGraphics.drawLine(point5.x, point5.y, this.penPosition.x, this.penPosition.y);
                        }
                        if (this.verbose) {
                            System.out.println("Short line origin: " + point5 + ", dh,dv: " + point6);
                        }
                        l += (long)(byArray5.length + byArray4.length);
                        break;
                    }
                    case 35: {
                        this.fillByteBuf(bufferedInputStream, byArray4, 0, byArray4.length);
                        Point point6 = new Point(this.getXPtCoord(this.bytesAsSignedInt(byArray4, 0, 1)), this.getYPtCoord(this.bytesAsSignedInt(byArray4, 1, 2)));
                        point2.setLocation(this.penPosition.x + point6.x, this.penPosition.y + point6.y);
                        if (this.drawGraphics != null) {
                            this.drawGraphics.drawLine(this.penPosition.x, this.penPosition.y, point2.x, point2.y);
                        }
                        this.penPosition.setLocation(point2);
                        if (this.verbose) {
                            System.out.println("Short line from dh,dv: " + point6);
                        }
                        l += (long)byArray4.length;
                        break;
                    }
                    case 36: 
                    case 37: 
                    case 38: 
                    case 39: {
                        this.fillByteBuf(bufferedInputStream, byArray4, 0, byArray4.length);
                        l += (long)byArray4.length;
                        int n5 = this.getBytesAsInt(byArray4, 0, byArray4.length);
                        this.fillByteBuf(bufferedInputStream, new byte[n5], 0, n5);
                        l += (long)n5;
                        if (!this.verbose) break;
                        System.out.println(this.APPLE_USE_RESERVED_FIELD_STR);
                        break;
                    }
                    case 40: {
                        this.fillByteBuf(bufferedInputStream, byArray5, 0, byArray5.length);
                        Point point5 = new Point();
                        this.setPointFromBuf(byArray5, point5);
                        this.penPosition = point5;
                        String string = this.readText(bufferedInputStream);
                        if (this.drawGraphics != null) {
                            this.drawGraphics.drawString(string, this.penPosition.x, this.penPosition.y);
                        }
                        if (this.verbose) {
                            System.out.println("longText origin: " + this.penPosition + ", text:" + string);
                        }
                        l += (long)(5 + string.length());
                        break;
                    }
                    case 41: {
                        this.fillByteBuf(bufferedInputStream, byArray3, 0, byArray3.length);
                        int n6 = this.getXPtCoord(byArray3[0]);
                        this.penPosition.translate(n6, 0);
                        String string = this.readText(bufferedInputStream);
                        if (this.drawGraphics != null) {
                            this.drawGraphics.drawString(string, this.penPosition.x, this.penPosition.y);
                        }
                        if (this.verbose) {
                            System.out.println("DHText dh: " + n6 + ", text:" + string);
                        }
                        l += (long)(byArray3.length + 1 + string.length());
                        break;
                    }
                    case 42: {
                        this.fillByteBuf(bufferedInputStream, byArray3, 0, byArray3.length);
                        int n7 = this.getYPtCoord(byArray3[0]);
                        this.penPosition.translate(0, n7);
                        String string = this.readText(bufferedInputStream);
                        if (this.drawGraphics != null) {
                            this.drawGraphics.drawString(string, this.penPosition.x, this.penPosition.y);
                        }
                        if (this.verbose) {
                            System.out.println("DVText dv: " + n7 + ", text:" + string);
                        }
                        l += (long)(byArray3.length + 1 + string.length());
                        break;
                    }
                    case 43: {
                        this.fillByteBuf(bufferedInputStream, byArray4, 0, byArray4.length);
                        this.penPosition.translate(this.getXPtCoord(this.bytesAsSignedInt(byArray4, 0, 1)), this.getYPtCoord(this.bytesAsSignedInt(byArray4, 1, 2)));
                        String string = this.readText(bufferedInputStream);
                        if (this.drawGraphics != null) {
                            this.drawGraphics.drawString(string, this.penPosition.x, this.penPosition.y);
                        }
                        if (this.verbose) {
                            System.out.println("DHDVText penPosition: " + this.penPosition + ", text:" + string);
                        }
                        l += (long)(byArray4.length + 1 + string.length());
                        break;
                    }
                    case 44: {
                        this.fillByteBuf(bufferedInputStream, byArray4, 0, byArray4.length);
                        int n5 = this.getBytesAsInt(byArray4, 0, 2);
                        this.fillByteBuf(bufferedInputStream, byArray4, 0, byArray4.length);
                        String string = this.readText(bufferedInputStream);
                        if (this.drawGraphics != null) {
                            this.drawGraphics.setFont(new Font(Font.decode(string).getName(), font.getStyle(), font.getSize()));
                        }
                        if (this.verbose) {
                            System.out.println("fontName: " + string);
                        }
                        l += (long)(5 + string.length());
                        break;
                    }
                    case 45: {
                        this.fillByteBuf(bufferedInputStream, new byte[10], 0, 10);
                        if (this.verbose) {
                            System.out.println("opLineJustify");
                        }
                        l += 10L;
                        break;
                    }
                    case 46: {
                        this.fillByteBuf(bufferedInputStream, new byte[6], 0, 6);
                        if (this.verbose) {
                            System.out.println("glyphState");
                        }
                        l += 6L;
                        break;
                    }
                    case 47: {
                        this.fillByteBuf(bufferedInputStream, byArray4, 0, byArray4.length);
                        l += (long)byArray4.length;
                        int n5 = this.getBytesAsInt(byArray4, 0, byArray4.length);
                        this.fillByteBuf(bufferedInputStream, new byte[n5], 0, n5);
                        l += (long)n5;
                        if (!this.verbose) break;
                        System.out.println(this.APPLE_USE_RESERVED_FIELD_STR);
                        break;
                    }
                    case 48: 
                    case 49: 
                    case 50: 
                    case 51: 
                    case 52: {
                        this.fillByteBuf(bufferedInputStream, byArray6, 0, byArray6.length);
                        l += (long)byArray6.length;
                        this.setRectFromBuf(byArray6, this.lastRectangle);
                    }
                    case 56: 
                    case 57: 
                    case 58: 
                    case 59: 
                    case 60: {
                        if (this.drawGraphics != null) {
                            switch (n2) {
                                case 48: 
                                case 56: {
                                    this.drawGraphics.drawRect(this.lastRectangle.x, this.lastRectangle.y, this.lastRectangle.width, this.lastRectangle.height);
                                    break;
                                }
                                case 49: 
                                case 57: {
                                    this.drawGraphics.fillRect(this.lastRectangle.x, this.lastRectangle.y, this.lastRectangle.width, this.lastRectangle.height);
                                    break;
                                }
                                case 50: 
                                case 58: {
                                    this.drawGraphics.setColor(this.bgColor);
                                    this.drawGraphics.fillRect(this.lastRectangle.x, this.lastRectangle.y, this.lastRectangle.width, this.lastRectangle.height);
                                    this.drawGraphics.setColor(this.fgColor);
                                    break;
                                }
                                case 51: 
                                case 59: {
                                    this.drawGraphics.setXORMode(this.bgColor);
                                    this.drawGraphics.fillRect(this.lastRectangle.x, this.lastRectangle.y, this.lastRectangle.width, this.lastRectangle.height);
                                    this.drawGraphics.setPaintMode();
                                    break;
                                }
                                case 52: 
                                case 60: {
                                    this.drawGraphics.fillRect(this.lastRectangle.x, this.lastRectangle.y, this.lastRectangle.width, this.lastRectangle.height);
                                    break;
                                }
                            }
                        }
                        if (this.verbose && n2 == 48) {
                            System.out.println("frameRect: " + this.lastRectangle);
                        }
                        if (this.verbose && n2 == 49) {
                            System.out.println("paintRect: " + this.lastRectangle);
                        }
                        if (this.verbose && n2 == 50) {
                            System.out.println("eraseRect: " + this.lastRectangle);
                        }
                        if (this.verbose && n2 == 51) {
                            System.out.println("invertRect: " + this.lastRectangle);
                        }
                        if (this.verbose && n2 == 52) {
                            System.out.println("fillRect: " + this.lastRectangle);
                        }
                        if (this.verbose && n2 == 56) {
                            System.out.println("frameSameRect: " + this.lastRectangle);
                        }
                        if (this.verbose && n2 == 57) {
                            System.out.println("paintSameRect: " + this.lastRectangle);
                        }
                        if (this.verbose && n2 == 58) {
                            System.out.println("eraseSameRect: " + this.lastRectangle);
                        }
                        if (this.verbose && n2 == 59) {
                            System.out.println("invertSameRect: " + this.lastRectangle);
                        }
                        if (!this.verbose || n2 != 60) continue block115;
                        System.out.println("fillSameRect: " + this.lastRectangle);
                        break;
                    }
                    case 64: 
                    case 65: 
                    case 66: 
                    case 67: 
                    case 68: {
                        this.fillByteBuf(bufferedInputStream, byArray6, 0, byArray6.length);
                        l += (long)byArray6.length;
                        this.setRectFromBuf(byArray6, this.lastRectangle);
                    }
                    case 72: 
                    case 73: 
                    case 74: 
                    case 75: 
                    case 76: {
                        if (this.drawGraphics != null) {
                            switch (n2) {
                                case 64: 
                                case 72: {
                                    this.drawGraphics.drawRoundRect(this.lastRectangle.x, this.lastRectangle.y, this.lastRectangle.width, this.lastRectangle.height, point.x, point.y);
                                    break;
                                }
                                case 65: 
                                case 73: {
                                    this.drawGraphics.fillRoundRect(this.lastRectangle.x, this.lastRectangle.y, this.lastRectangle.width, this.lastRectangle.height, point.x, point.y);
                                    break;
                                }
                                case 66: 
                                case 74: {
                                    this.drawGraphics.setColor(this.bgColor);
                                    this.drawGraphics.fillRoundRect(this.lastRectangle.x, this.lastRectangle.y, this.lastRectangle.width, this.lastRectangle.height, point.x, point.y);
                                    this.drawGraphics.setColor(this.fgColor);
                                    break;
                                }
                                case 67: 
                                case 75: {
                                    this.drawGraphics.setXORMode(this.bgColor);
                                    this.drawGraphics.fillRoundRect(this.lastRectangle.x, this.lastRectangle.y, this.lastRectangle.width, this.lastRectangle.height, point.x, point.y);
                                    this.drawGraphics.setPaintMode();
                                    break;
                                }
                                case 68: 
                                case 76: {
                                    this.drawGraphics.fillRoundRect(this.lastRectangle.x, this.lastRectangle.y, this.lastRectangle.width, this.lastRectangle.height, point.x, point.y);
                                    break;
                                }
                            }
                        }
                        if (this.verbose && n2 == 64) {
                            System.out.println("frameRRect: " + this.lastRectangle);
                        }
                        if (this.verbose && n2 == 65) {
                            System.out.println("paintRRect: " + this.lastRectangle);
                        }
                        if (this.verbose && n2 == 66) {
                            System.out.println("eraseRRect: " + this.lastRectangle);
                        }
                        if (this.verbose && n2 == 67) {
                            System.out.println("invertRRect: " + this.lastRectangle);
                        }
                        if (this.verbose && n2 == 68) {
                            System.out.println("fillRRect: " + this.lastRectangle);
                        }
                        if (this.verbose && n2 == 72) {
                            System.out.println("frameSameRRect: " + this.lastRectangle);
                        }
                        if (this.verbose && n2 == 73) {
                            System.out.println("paintSameRRect: " + this.lastRectangle);
                        }
                        if (this.verbose && n2 == 74) {
                            System.out.println("eraseSameRRect: " + this.lastRectangle);
                        }
                        if (this.verbose && n2 == 75) {
                            System.out.println("invertSameRRect: " + this.lastRectangle);
                        }
                        if (!this.verbose || n2 != 76) continue block115;
                        System.out.println("fillSameRRect: " + this.lastRectangle);
                        break;
                    }
                    case 80: 
                    case 81: 
                    case 82: 
                    case 83: 
                    case 84: {
                        this.fillByteBuf(bufferedInputStream, byArray6, 0, byArray6.length);
                        l += (long)byArray6.length;
                        this.setRectFromBuf(byArray6, this.lastRectangle);
                    }
                    case 88: 
                    case 89: 
                    case 90: 
                    case 91: 
                    case 92: {
                        if (this.drawGraphics != null) {
                            switch (n2) {
                                case 80: 
                                case 88: {
                                    this.drawGraphics.drawOval(this.lastRectangle.x, this.lastRectangle.y, this.lastRectangle.width, this.lastRectangle.height);
                                    break;
                                }
                                case 81: 
                                case 89: {
                                    this.drawGraphics.fillOval(this.lastRectangle.x, this.lastRectangle.y, this.lastRectangle.width, this.lastRectangle.height);
                                    break;
                                }
                                case 82: 
                                case 90: {
                                    this.drawGraphics.setColor(this.bgColor);
                                    this.drawGraphics.fillOval(this.lastRectangle.x, this.lastRectangle.y, this.lastRectangle.width, this.lastRectangle.height);
                                    this.drawGraphics.setColor(this.fgColor);
                                    break;
                                }
                                case 83: 
                                case 91: {
                                    this.drawGraphics.setXORMode(this.bgColor);
                                    this.drawGraphics.fillOval(this.lastRectangle.x, this.lastRectangle.y, this.lastRectangle.width, this.lastRectangle.height);
                                    this.drawGraphics.setPaintMode();
                                    break;
                                }
                                case 84: 
                                case 92: {
                                    this.drawGraphics.fillOval(this.lastRectangle.x, this.lastRectangle.y, this.lastRectangle.width, this.lastRectangle.height);
                                    break;
                                }
                            }
                        }
                        if (this.verbose && n2 == 80) {
                            System.out.println("frameOval: " + this.lastRectangle);
                        }
                        if (this.verbose && n2 == 81) {
                            System.out.println("paintOval: " + this.lastRectangle);
                        }
                        if (this.verbose && n2 == 82) {
                            System.out.println("eraseOval: " + this.lastRectangle);
                        }
                        if (this.verbose && n2 == 83) {
                            System.out.println("invertOval: " + this.lastRectangle);
                        }
                        if (this.verbose && n2 == 84) {
                            System.out.println("fillOval: " + this.lastRectangle);
                        }
                        if (this.verbose && n2 == 88) {
                            System.out.println("frameSameOval: " + this.lastRectangle);
                        }
                        if (this.verbose && n2 == 89) {
                            System.out.println("paintSameOval: " + this.lastRectangle);
                        }
                        if (this.verbose && n2 == 90) {
                            System.out.println("eraseSameOval: " + this.lastRectangle);
                        }
                        if (this.verbose && n2 == 91) {
                            System.out.println("invertSameOval: " + this.lastRectangle);
                        }
                        if (!this.verbose || n2 != 92) continue block115;
                        System.out.println("fillSameOval: " + this.lastRectangle);
                        break;
                    }
                    case 53: 
                    case 54: 
                    case 55: 
                    case 69: 
                    case 70: 
                    case 71: 
                    case 85: 
                    case 86: 
                    case 87: {
                        this.fillByteBuf(bufferedInputStream, new byte[8], 0, 8);
                        l += 8L;
                        if (!this.verbose) break;
                        System.out.println(this.APPLE_USE_RESERVED_FIELD_STR);
                        break;
                    }
                    case 96: 
                    case 97: 
                    case 98: 
                    case 99: 
                    case 100: {
                        this.fillByteBuf(bufferedInputStream, byArray6, 0, byArray6.length);
                        l += (long)byArray6.length;
                        this.setRectFromBuf(byArray6, this.lastRectangle);
                        this.fillByteBuf(bufferedInputStream, byArray5, 0, byArray5.length);
                        l += (long)byArray5.length;
                        this.setPointFromBuf(byArray5, point3);
                    }
                    case 104: 
                    case 105: 
                    case 106: 
                    case 107: 
                    case 108: {
                        if (this.drawGraphics != null) {
                            switch (n2) {
                                case 96: 
                                case 104: {
                                    this.drawGraphics.drawArc(this.lastRectangle.x, this.lastRectangle.y, this.lastRectangle.width, this.lastRectangle.height, point3.x, point3.y);
                                    break;
                                }
                                case 97: 
                                case 105: {
                                    this.drawGraphics.fillArc(this.lastRectangle.x, this.lastRectangle.y, this.lastRectangle.width, this.lastRectangle.height, point3.x, point3.y);
                                    break;
                                }
                                case 98: 
                                case 106: {
                                    this.drawGraphics.setColor(this.bgColor);
                                    this.drawGraphics.fillArc(this.lastRectangle.x, this.lastRectangle.y, this.lastRectangle.width, this.lastRectangle.height, point3.x, point3.y);
                                    this.drawGraphics.setColor(this.fgColor);
                                    break;
                                }
                                case 99: 
                                case 107: {
                                    this.drawGraphics.setXORMode(this.bgColor);
                                    this.drawGraphics.fillArc(this.lastRectangle.x, this.lastRectangle.y, this.lastRectangle.width, this.lastRectangle.height, point3.x, point3.y);
                                    this.drawGraphics.setPaintMode();
                                    break;
                                }
                                case 100: 
                                case 108: {
                                    this.drawGraphics.fillArc(this.lastRectangle.x, this.lastRectangle.y, this.lastRectangle.width, this.lastRectangle.height, point3.x, point3.y);
                                    break;
                                }
                            }
                        }
                        if (this.verbose && n2 == 96) {
                            System.out.println("frameArc: " + this.lastRectangle + ", angles:" + point3);
                        }
                        if (this.verbose && n2 == 97) {
                            System.out.println("paintArc: " + this.lastRectangle + ", angles:" + point3);
                        }
                        if (this.verbose && n2 == 98) {
                            System.out.println("eraseArc: " + this.lastRectangle + ", angles:" + point3);
                        }
                        if (this.verbose && n2 == 99) {
                            System.out.println("invertArc: " + this.lastRectangle + ", angles:" + point3);
                        }
                        if (this.verbose && n2 == 100) {
                            System.out.println("fillArc: " + this.lastRectangle + ", angles:" + point3);
                        }
                        if (this.verbose && n2 == 104) {
                            System.out.println("frameSameArc: " + this.lastRectangle + ", angles:" + point3);
                        }
                        if (this.verbose && n2 == 105) {
                            System.out.println("paintSameArc: " + this.lastRectangle + ", angles:" + point3);
                        }
                        if (this.verbose && n2 == 106) {
                            System.out.println("eraseSameArc: " + this.lastRectangle + ", angles:" + point3);
                        }
                        if (this.verbose && n2 == 107) {
                            System.out.println("invertSameArc: " + this.lastRectangle + ", angles:" + point3);
                        }
                        if (!this.verbose || n2 != 108) continue block115;
                        System.out.println("fillSameArc: " + this.lastRectangle + ", angles:" + point3);
                        break;
                    }
                    case 101: 
                    case 102: 
                    case 103: {
                        this.fillByteBuf(bufferedInputStream, new byte[12], 0, 12);
                        l += 12L;
                        if (!this.verbose) break;
                        System.out.println(this.APPLE_USE_RESERVED_FIELD_STR);
                        break;
                    }
                    case 112: 
                    case 113: 
                    case 114: 
                    case 115: 
                    case 116: {
                        polygon = this.readPoly(bufferedInputStream, rectangle);
                    }
                    case 120: 
                    case 121: 
                    case 122: 
                    case 123: 
                    case 124: {
                        if (this.drawGraphics != null && polygon != null && polygon.npoints > 1) {
                            switch (n2) {
                                case 112: 
                                case 120: {
                                    if (polygon.xpoints[0] == polygon.xpoints[polygon.npoints - 1] && polygon.ypoints[0] == polygon.ypoints[polygon.npoints - 1]) {
                                        this.drawGraphics.drawPolygon(polygon);
                                        break;
                                    }
                                    this.drawGraphics.drawPolyline(polygon.xpoints, polygon.ypoints, polygon.npoints);
                                    break;
                                }
                                case 113: 
                                case 121: {
                                    this.drawGraphics.fillPolygon(polygon);
                                    break;
                                }
                                case 114: 
                                case 122: {
                                    this.drawGraphics.setColor(this.bgColor);
                                    this.drawGraphics.fillPolygon(polygon);
                                    this.drawGraphics.setColor(this.fgColor);
                                    break;
                                }
                                case 115: 
                                case 123: {
                                    this.drawGraphics.setXORMode(this.bgColor);
                                    this.drawGraphics.fillPolygon(polygon);
                                    this.drawGraphics.setPaintMode();
                                    break;
                                }
                                case 116: 
                                case 124: {
                                    this.drawGraphics.fillPolygon(polygon);
                                    break;
                                }
                            }
                        }
                        if (this.verbose && n2 == 112) {
                            this.verbosePolyCmd("framePoly", rectangle, polygon);
                        }
                        if (this.verbose && n2 == 113) {
                            this.verbosePolyCmd("paintPoly", rectangle, polygon);
                        }
                        if (this.verbose && n2 == 114) {
                            this.verbosePolyCmd("erasePoly", rectangle, polygon);
                        }
                        if (this.verbose && n2 == 115) {
                            this.verbosePolyCmd("invertPoly", rectangle, polygon);
                        }
                        if (this.verbose && n2 == 116) {
                            this.verbosePolyCmd("fillPoly", rectangle, polygon);
                        }
                        if (this.verbose && n2 == 120) {
                            this.verbosePolyCmd("frameSamePoly", rectangle, polygon);
                        }
                        if (this.verbose && n2 == 121) {
                            this.verbosePolyCmd("paintSamePoly", rectangle, polygon);
                        }
                        if (this.verbose && n2 == 122) {
                            this.verbosePolyCmd("eraseSamePoly", rectangle, polygon);
                        }
                        if (this.verbose && n2 == 123) {
                            this.verbosePolyCmd("invertSamePoly", rectangle, polygon);
                        }
                        if (!this.verbose || n2 != 124) continue block115;
                        this.verbosePolyCmd("fillSamePoly", rectangle, polygon);
                        break;
                    }
                    case 117: 
                    case 118: 
                    case 119: {
                        polygon = this.readPoly(bufferedInputStream, rectangle);
                        if (!this.verbose) break;
                        System.out.println(this.APPLE_USE_RESERVED_FIELD_STR);
                        break;
                    }
                    case 128: 
                    case 129: 
                    case 130: 
                    case 131: 
                    case 132: {
                        polygon2 = this.readRegion(bufferedInputStream, rectangle);
                    }
                    case 136: 
                    case 137: 
                    case 138: 
                    case 139: 
                    case 140: {
                        if (this.drawGraphics != null && polygon2 != null && polygon2.npoints > 1) {
                            switch (n2) {
                                case 128: 
                                case 136: {
                                    this.drawGraphics.drawPolygon(polygon2);
                                    break;
                                }
                                case 129: 
                                case 137: {
                                    this.drawGraphics.fillPolygon(polygon2);
                                    break;
                                }
                                case 130: 
                                case 138: {
                                    this.drawGraphics.setColor(this.bgColor);
                                    this.drawGraphics.fillPolygon(polygon2);
                                    this.drawGraphics.setColor(this.fgColor);
                                    break;
                                }
                                case 131: 
                                case 139: {
                                    this.drawGraphics.setXORMode(this.bgColor);
                                    this.drawGraphics.fillPolygon(polygon2);
                                    this.drawGraphics.setPaintMode();
                                    break;
                                }
                                case 132: 
                                case 140: {
                                    this.drawGraphics.fillPolygon(polygon2);
                                    break;
                                }
                            }
                        }
                        if (this.verbose && n2 == 128) {
                            this.verboseRegionCmd("frameRgn", rectangle, polygon2);
                        }
                        if (this.verbose && n2 == 129) {
                            this.verboseRegionCmd("paintRgn", rectangle, polygon2);
                        }
                        if (this.verbose && n2 == 130) {
                            this.verboseRegionCmd("eraseRgn", rectangle, polygon2);
                        }
                        if (this.verbose && n2 == 131) {
                            this.verboseRegionCmd("invertRgn", rectangle, polygon2);
                        }
                        if (this.verbose && n2 == 132) {
                            this.verboseRegionCmd("fillRgn", rectangle, polygon2);
                        }
                        if (this.verbose && n2 == 136) {
                            this.verboseRegionCmd("frameSameRgn", rectangle, polygon2);
                        }
                        if (this.verbose && n2 == 137) {
                            this.verboseRegionCmd("paintSameRgn", rectangle, polygon2);
                        }
                        if (this.verbose && n2 == 138) {
                            this.verboseRegionCmd("eraseSameRgn", rectangle, polygon2);
                        }
                        if (this.verbose && n2 == 139) {
                            this.verboseRegionCmd("invertSameRgn", rectangle, polygon2);
                        }
                        if (!this.verbose || n2 != 140) continue block115;
                        this.verboseRegionCmd("fillSameRgn", rectangle, polygon2);
                        break;
                    }
                    case 133: 
                    case 134: 
                    case 135: {
                        polygon2 = this.readRegion(bufferedInputStream, rectangle);
                        if (!this.verbose) break;
                        System.out.println(this.APPLE_USE_RESERVED_FIELD_STR);
                        break;
                    }
                    case 144: {
                        if (!this.verbose) break;
                        System.out.println("opBitsRect");
                        break;
                    }
                    case 145: {
                        if (!this.verbose) break;
                        System.out.println("opBitsRgn");
                        break;
                    }
                    case 146: 
                    case 147: 
                    case 148: 
                    case 149: 
                    case 150: 
                    case 151: {
                        this.fillByteBuf(bufferedInputStream, byArray4, 0, byArray4.length);
                        l += (long)byArray4.length;
                        int n5 = this.getBytesAsInt(byArray4, 0, byArray4.length);
                        this.fillByteBuf(bufferedInputStream, new byte[n5], 0, n5);
                        l += (long)n5;
                        if (!this.verbose) break;
                        System.out.println(this.APPLE_USE_RESERVED_FIELD_STR);
                        break;
                    }
                    case 152: {
                        if (!this.verbose) break;
                        System.out.println("opPackBitsRect");
                        break;
                    }
                    case 153: {
                        if (!this.verbose) break;
                        System.out.println("opPackBitsRgn");
                        break;
                    }
                    case 154: {
                        Image image;
                        if (this.verbose) {
                            System.out.println("opDirectBitsRect");
                        }
                        this.fillByteBuf(bufferedInputStream, new byte[4], 0, 4);
                        l += 4L;
                        this.fillByteBuf(bufferedInputStream, byArray4, 0, byArray4.length);
                        l += (long)byArray4.length;
                        int n8 = this.getBytesAsInt(byArray4, 0, byArray4.length) & 0x3FFF;
                        if (this.verbose) {
                            System.out.print("opDirectBitsRect, rowBytes: " + n8);
                            if ((byArray4[0] & 0x80) > 0) {
                                System.out.print(", it is a PixMap");
                            } else {
                                System.out.print(", it is a BitMap");
                            }
                        }
                        this.fillByteBuf(bufferedInputStream, byArray6, 0, byArray6.length);
                        l += (long)byArray6.length;
                        rectangle.setLocation(this.getBytesAsInt(byArray6, 2, 4), this.getBytesAsInt(byArray6, 0, 2));
                        rectangle.setSize(this.getBytesAsInt(byArray6, 6, 8) - rectangle.x, this.getBytesAsInt(byArray6, 4, 6) - rectangle.y);
                        if (this.verbose) {
                            System.out.print(", bounds: " + rectangle);
                        }
                        this.fillByteBuf(bufferedInputStream, byArray4, 0, byArray4.length);
                        l += (long)byArray4.length;
                        int n9 = this.getBytesAsInt(byArray4, 0, byArray4.length) & 0xFFFF;
                        if (this.verbose) {
                            System.out.print(", pmVersion: " + n9);
                        }
                        this.fillByteBuf(bufferedInputStream, byArray4, 0, byArray4.length);
                        l += (long)byArray4.length;
                        int n10 = this.getBytesAsInt(byArray4, 0, byArray4.length) & 0xFFFF;
                        if (this.verbose) {
                            System.out.print(", packType: " + n10);
                        }
                        this.fillByteBuf(bufferedInputStream, byArray7, 0, byArray7.length);
                        l += (long)byArray7.length;
                        int n11 = this.getBytesAsInt(byArray7, 0, byArray7.length);
                        if (this.verbose) {
                            System.out.println(", packSize: " + n11);
                        }
                        this.fillByteBuf(bufferedInputStream, byArray7, 0, byArray7.length);
                        l += (long)byArray7.length;
                        int n12 = this.getBytesAsInt(byArray7, 0, 2);
                        this.fillByteBuf(bufferedInputStream, byArray7, 0, byArray7.length);
                        l += (long)byArray7.length;
                        int n13 = this.getBytesAsInt(byArray7, 0, 2);
                        if (this.verbose) {
                            System.out.print("hRes: " + n12 + ", vRes: " + n13);
                        }
                        this.fillByteBuf(bufferedInputStream, byArray4, 0, byArray4.length);
                        l += (long)byArray4.length;
                        int n14 = this.getBytesAsInt(byArray4, 0, byArray4.length);
                        if (this.verbose) {
                            if (n14 == 0) {
                                System.out.print(", indexed pixels");
                            } else {
                                System.out.print(", RGBDirect");
                            }
                        }
                        this.fillByteBuf(bufferedInputStream, byArray4, 0, byArray4.length);
                        l += (long)byArray4.length;
                        int n15 = this.getBytesAsInt(byArray4, 0, byArray4.length);
                        if (this.verbose) {
                            System.out.print(", pixelSize:" + n15);
                        }
                        this.fillByteBuf(bufferedInputStream, byArray4, 0, byArray4.length);
                        l += (long)byArray4.length;
                        int n16 = this.getBytesAsInt(byArray4, 0, byArray4.length);
                        if (this.verbose) {
                            System.out.print(", cmpCount:" + n16);
                        }
                        this.fillByteBuf(bufferedInputStream, byArray4, 0, byArray4.length);
                        l += (long)byArray4.length;
                        int n17 = this.getBytesAsInt(byArray4, 0, byArray4.length);
                        if (this.verbose) {
                            System.out.println(", cmpSize:" + n17);
                        }
                        this.fillByteBuf(bufferedInputStream, byArray7, 0, byArray7.length);
                        l += (long)byArray7.length;
                        this.fillByteBuf(bufferedInputStream, byArray7, 0, byArray7.length);
                        l += (long)byArray7.length;
                        this.fillByteBuf(bufferedInputStream, byArray7, 0, byArray7.length);
                        l += (long)byArray7.length;
                        Rectangle rectangle2 = new Rectangle();
                        this.fillByteBuf(bufferedInputStream, byArray6, 0, byArray6.length);
                        l += (long)byArray6.length;
                        rectangle2.setLocation(this.getBytesAsInt(byArray6, 2, 4), this.getBytesAsInt(byArray6, 0, 2));
                        rectangle2.setSize(this.getBytesAsInt(byArray6, 6, 8) - rectangle2.x, this.getBytesAsInt(byArray6, 4, 6) - rectangle2.y);
                        if (this.verbose) {
                            System.out.print("opDirectBitsRect, srcRect:" + rectangle2);
                        }
                        Rectangle rectangle3 = new Rectangle();
                        this.fillByteBuf(bufferedInputStream, byArray6, 0, byArray6.length);
                        l += (long)byArray6.length;
                        this.setRectFromBuf(byArray6, rectangle3);
                        if (this.verbose) {
                            System.out.print(", dstRect:" + rectangle3);
                        }
                        this.fillByteBuf(bufferedInputStream, byArray4, 0, byArray4.length);
                        l += (long)byArray4.length;
                        int n18 = this.getBytesAsInt(byArray4, 0, byArray4.length);
                        if (this.verbose) {
                            System.out.print(", mode: " + n18);
                        }
                        int n19 = rectangle.height * rectangle.width;
                        int[] nArray = new int[n19];
                        int n20 = 0;
                        byte[] byArray10 = new byte[3 * rectangle.width];
                        int n21 = 0;
                        while (n21 < rectangle.height) {
                            int n22;
                            if (n8 > 250) {
                                this.fillByteBuf(bufferedInputStream, byArray4, 0, byArray4.length);
                                l += (long)byArray4.length;
                                n22 = this.getBytesAsInt(byArray4, 0, byArray4.length);
                            } else {
                                this.fillByteBuf(bufferedInputStream, byArray3, 0, byArray3.length);
                                l += (long)byArray3.length;
                                n22 = this.getBytesAsInt(byArray3, 0, byArray3.length);
                            }
                            if (this.verbose) {
                                System.out.println();
                                System.out.print("Line " + n21 + ", byteCount: " + n22);
                            }
                            byte[] byArray11 = new byte[n22];
                            this.fillByteBuf(bufferedInputStream, byArray11, 0, byArray11.length);
                            l += (long)byArray11.length;
                            DataCompression.unPackBits(byArray11, byArray10, 0, byArray11.length);
                            int n23 = 0;
                            while (n23 < rectangle.width) {
                                nArray[n20 + n23] = -16777216;
                                ++n23;
                            }
                            n23 = 0;
                            while (n23 < rectangle.width) {
                                int n24 = n20 + n23;
                                nArray[n24] = nArray[n24] | (byArray10[n23] & 0xFF) << 16;
                                ++n23;
                            }
                            n23 = 0;
                            while (n23 < rectangle.width) {
                                int n25 = n20 + n23;
                                nArray[n25] = nArray[n25] | (byArray10[rectangle.width + n23] & 0xFF) << 8;
                                ++n23;
                            }
                            n23 = 0;
                            while (n23 < rectangle.width) {
                                int n26 = n20 + n23;
                                nArray[n26] = nArray[n26] | byArray10[2 * rectangle.width + n23] & 0xFF;
                                ++n23;
                            }
                            n20 += rectangle.width;
                            ++n21;
                        }
                        if (this.imgVector == null) {
                            this.imgVector = new Vector();
                        }
                        if (this.imgVector.size() <= n) {
                            image = Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(rectangle.width, rectangle.height, nArray, 0, rectangle.width));
                            this.imgVector.addElement(image);
                        }
                        if ((image = (Image)this.imgVector.elementAt(n)) != null && this.drawGraphics != null && this.drawComponent != null) {
                            this.drawGraphics.drawImage(image, rectangle3.x, rectangle3.y, rectangle3.x + rectangle3.width, rectangle3.y + rectangle3.height, rectangle2.x, rectangle2.y, rectangle2.x + rectangle2.width, rectangle2.y + rectangle2.height, this.drawComponent);
                        }
                        if (!this.verbose) break;
                        System.out.println();
                        break;
                    }
                    case 155: {
                        if (!this.verbose) break;
                        System.out.println("opDirectBitsRgn");
                        break;
                    }
                    case 156: 
                    case 157: 
                    case 158: 
                    case 159: {
                        this.fillByteBuf(bufferedInputStream, byArray4, 0, byArray4.length);
                        l += (long)byArray4.length;
                        int n5 = this.getBytesAsInt(byArray4, 0, byArray4.length);
                        this.fillByteBuf(bufferedInputStream, new byte[n5], 0, n5);
                        l += (long)n5;
                        if (!this.verbose) break;
                        System.out.println(this.APPLE_USE_RESERVED_FIELD_STR);
                        break;
                    }
                    case 160: {
                        this.fillByteBuf(bufferedInputStream, new byte[2], 0, 2);
                        if (this.verbose) {
                            System.out.println("Short comment");
                        }
                        l += 2L;
                        break;
                    }
                    case 161: {
                        if (!this.readLongComment(bufferedInputStream)) {
                            return false;
                        }
                        if (!this.verbose) break;
                        System.out.println("Long comment");
                        break;
                    }
                    case 33280: {
                        this.fillByteBuf(bufferedInputStream, byArray7, 0, byArray7.length);
                        l += (long)byArray7.length;
                        int n5 = this.getBytesAsInt(byArray7, 0, byArray7.length);
                        this.fillByteBuf(bufferedInputStream, new byte[n5], 0, n5);
                        l += (long)n5;
                        if (!this.verbose) break;
                        System.out.println("opCompressedQuickTime");
                        break;
                    }
                    case 33281: {
                        this.fillByteBuf(bufferedInputStream, byArray7, 0, byArray7.length);
                        l += (long)byArray7.length;
                        int n5 = this.getBytesAsInt(byArray7, 0, byArray7.length);
                        this.fillByteBuf(bufferedInputStream, new byte[n5], 0, n5);
                        l += (long)n5;
                        if (!this.verbose) break;
                        System.out.println("opUnCompressedQuickTime");
                        break;
                    }
                    case 65535: {
                        this.fillByteBuf(bufferedInputStream, byArray7, 0, byArray7.length);
                        l += (long)byArray7.length;
                        int n5 = this.getBytesAsInt(byArray7, 0, byArray7.length);
                        this.fillByteBuf(bufferedInputStream, new byte[n5], 0, n5);
                        l += (long)n5;
                        if (!this.verbose) break;
                        System.out.println("opUnCompressedQuickTime");
                        break;
                    }
                    default: {
                        System.out.println("Found unknown opcode: " + n2);
                        return false;
                    }
                    case 255: 
                }
            } while (n2 != 255);
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }

    private void setPointFromBuf(byte[] byArray, Point point) {
        point.setLocation(this.getXPtCoord(this.getBytesAsInt(byArray, 2, 4)), this.getYPtCoord(this.getBytesAsInt(byArray, 0, 2)));
    }

    private void setRectFromBuf(byte[] byArray, Rectangle rectangle) {
        int n = this.getBytesAsInt(byArray, 2, 4);
        int n2 = this.getBytesAsInt(byArray, 0, 2);
        rectangle.setLocation(this.getXPtCoord(n), this.getYPtCoord(n2));
        rectangle.setSize(this.getXPtCoord(this.getBytesAsInt(byArray, 6, 8) - n), this.getYPtCoord(this.getBytesAsInt(byArray, 4, 6) - n2));
    }

    private Polygon readRegion(BufferedInputStream bufferedInputStream, Rectangle rectangle) {
        Polygon polygon;
        byte[] byArray = new byte[10];
        try {
            this.fillByteBuf(bufferedInputStream, byArray, 0, byArray.length);
            int n = this.getBytesAsInt(byArray, 0, 2);
            int n2 = 2;
            rectangle.setLocation(this.getXPtCoord(this.bytesAsSignedInt(byArray, n2 + 2, n2 + 4)), this.getYPtCoord(this.bytesAsSignedInt(byArray, n2, n2 + 2)));
            rectangle.setSize(this.getXPtCoord(this.bytesAsSignedInt(byArray, (n2 += 4) + 2, n2 + 4)) - rectangle.getLocation().x, this.getYPtCoord(this.bytesAsSignedInt(byArray, n2, n2 + 2)) - rectangle.getLocation().y);
            int n3 = (n - (n2 += 4)) / 4;
            polygon = new Polygon();
            byte[] byArray2 = new byte[n3 * 2 * 2];
            this.fillByteBuf(bufferedInputStream, byArray2, 0, byArray2.length);
            n2 = 0;
            int n4 = 0;
            while (n4 < n3) {
                polygon.addPoint(this.getXPtCoord(this.bytesAsSignedInt(byArray2, n2 + 2, n2 + 4)), this.getYPtCoord(this.bytesAsSignedInt(byArray2, n2, n2 + 2)));
                n2 += 4;
                ++n4;
            }
        }
        catch (IOException iOException) {
            return null;
        }
        return polygon;
    }

    private Polygon readPoly(BufferedInputStream bufferedInputStream, Rectangle rectangle) {
        Polygon polygon;
        byte[] byArray = new byte[10];
        try {
            this.fillByteBuf(bufferedInputStream, byArray, 0, byArray.length);
            int n = this.getBytesAsInt(byArray, 0, 2);
            int n2 = 2;
            rectangle.setLocation(this.getXPtCoord(this.bytesAsSignedInt(byArray, n2 + 2, n2 + 4)), this.getYPtCoord(this.bytesAsSignedInt(byArray, n2, n2 + 2)));
            rectangle.setSize(this.getXPtCoord(this.bytesAsSignedInt(byArray, (n2 += 4) + 2, n2 + 4)) - rectangle.getLocation().x, this.getYPtCoord(this.bytesAsSignedInt(byArray, n2, n2 + 2)) - rectangle.getLocation().y);
            int n3 = (n - (n2 += 4)) / 4;
            polygon = new Polygon();
            byte[] byArray2 = new byte[n3 * 2 * 2];
            this.fillByteBuf(bufferedInputStream, byArray2, 0, byArray2.length);
            n2 = 0;
            int n4 = 0;
            while (n4 < n3) {
                polygon.addPoint(this.getXPtCoord(this.bytesAsSignedInt(byArray2, n2 + 2, n2 + 4)), this.getYPtCoord(this.bytesAsSignedInt(byArray2, n2, n2 + 2)));
                n2 += 4;
                ++n4;
            }
        }
        catch (IOException iOException) {
            return null;
        }
        return polygon;
    }

    private String readText(BufferedInputStream bufferedInputStream) {
        byte[] byArray;
        byte[] byArray2 = new byte[1];
        try {
            this.fillByteBuf(bufferedInputStream, byArray2, 0, byArray2.length);
            byte by = byArray2[0];
            byArray = new byte[by];
            this.fillByteBuf(bufferedInputStream, byArray, 0, by);
        }
        catch (IOException iOException) {
            return null;
        }
        return new String(byArray);
    }

    private void readPixPat(BufferedInputStream bufferedInputStream) {
    }

    private boolean readLongComment(BufferedInputStream bufferedInputStream) {
        byte[] byArray = new byte[2];
        byte[] byArray2 = new byte[2];
        try {
            this.fillByteBuf(bufferedInputStream, byArray, 0, byArray.length);
            this.fillByteBuf(bufferedInputStream, byArray2, 0, byArray2.length);
            int n = this.getBytesAsInt(byArray2, 0, byArray2.length);
            this.fillByteBuf(bufferedInputStream, new byte[n], 0, n);
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }

    private int getXPtCoord(int n) {
        return (int)((double)n * this.screenImageXRatio);
    }

    private int getYPtCoord(int n) {
        return (int)((double)n * this.screenImageYRatio);
    }

    private int getBytesAsInt(byte[] byArray, int n, int n2) {
        int n3 = byArray[n] & 0xFF;
        int n4 = n + 1;
        while (n4 < byArray.length && n4 < n2) {
            n3 = n3 << 8 | byArray[n4] & 0xFF;
            ++n4;
        }
        return n3;
    }

    private int bytesAsSignedInt(byte[] byArray, int n, int n2) {
        boolean bl = false;
        if ((byArray[n] & 0x80) != 0) {
            bl = true;
        }
        int n3 = n;
        byArray[n3] = (byte)(byArray[n3] & 0x7F);
        int n4 = this.getBytesAsInt(byArray, n, n2);
        if (bl) {
            int n5 = (int)Math.pow(2.0, (n2 - n) * 8 - 1);
            n4 -= n5;
        }
        return n4;
    }

    private void fillByteBuf(InputStream inputStream, byte[] byArray, int n, int n2) throws IOException {
        while (n2 > 0) {
            int n3 = inputStream.read(byArray, n, n2);
            if (n3 == -1) {
                throw new IOException("Unexpected EOF");
            }
            n += n3;
            n2 -= n3;
        }
    }

    private void verbosePolyCmd(String string, Rectangle rectangle, Polygon polygon) {
        System.out.println(String.valueOf(string) + ": " + new Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height));
        System.out.print("Polygon points: ");
        int n = 0;
        while (polygon != null && n < polygon.npoints - 1) {
            System.out.print("(" + polygon.xpoints[n] + "," + polygon.ypoints[n] + "), ");
            ++n;
        }
        if (polygon != null && polygon.npoints > 0) {
            System.out.print("(" + polygon.xpoints[n] + "," + polygon.ypoints[n] + ")");
        }
        System.out.println();
    }

    private void verboseRegionCmd(String string, Rectangle rectangle, Polygon polygon) {
        System.out.println(String.valueOf(string) + ": " + new Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height));
        System.out.print("Region points: ");
        int n = 0;
        while (polygon != null && n < polygon.npoints - 1) {
            System.out.print("(" + polygon.xpoints[n] + "," + polygon.ypoints[n] + "), ");
            ++n;
        }
        if (polygon != null && polygon.npoints > 0) {
            System.out.print("(" + polygon.xpoints[n] + "," + polygon.ypoints[n] + ")");
        }
        System.out.println();
    }

    static {
        byte[] byArray = new byte[2];
        byArray[0] = 12;
        OP_HEADER_OP = byArray;
    }
}

