/*
 * Decompiled with CFR 0.152.
 */
package fi.faidon.jvg;

import fi.faidon.jis.ImageSerializer;
import fi.faidon.jis.ImageSerializerVector;
import fi.faidon.jvg.FaidonJVGIdentifier;
import fi.faidon.jvg.GraphicsOperation;
import fi.faidon.jvg.JVGHeader;
import fi.faidon.jvg.VectorImageProducer;
import fi.faidon.jvg.Version1JVGHeader;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Vector;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class GraphicsRecording
extends VectorImageProducer {
    public static final byte[] IMG_FILE_SIGNATURE = new byte[]{74, 86, 71, 70};
    public static final int NO_COMPRESSION = 0;
    public static final int GZIP_COMPRESSION = 1;
    private final int DEF_REC_VECT_SIZE = 128;
    private final int DEF_IMAGE_VECT_SIZE = 24;
    private Vector recordingVector = new Vector(128);
    private ImageSerializerVector imageVector;
    private JVGHeader header;
    private boolean verbose;

    public GraphicsRecording() {
        this.recordingVector.addElement(new Version1JVGHeader());
        this.recordingVector.addElement(new FaidonJVGIdentifier());
        this.imageVector = new ImageSerializerVector(24);
        this.verbose = false;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean bl) {
        this.verbose = bl;
    }

    public void addOperation(Object[] objectArray) {
        int n = 0;
        while (n < objectArray.length) {
            if (objectArray[n] instanceof Image) {
                int n2 = this.getStoredImage((Image)objectArray[n]);
                this.recordingVector.addElement(new Integer(n2));
            } else {
                this.recordingVector.addElement(objectArray[n]);
            }
            ++n;
        }
    }

    public void addOperation(Vector vector) {
        int n = 0;
        while (n < vector.size()) {
            if (vector.elementAt(n) instanceof Image) {
                int n2 = this.getStoredImage((Image)vector.elementAt(n));
                this.recordingVector.addElement(new Integer(n2));
            } else {
                this.recordingVector.addElement(vector.elementAt(n));
            }
            ++n;
        }
    }

    public Image[] getImages() {
        Image[] imageArray = new Image[this.imageVector.size()];
        int n = 0;
        while (n < this.imageVector.size()) {
            imageArray[n] = ((ImageSerializer)this.imageVector.elementAt(n)).getImage();
            ++n;
        }
        return imageArray;
    }

    public int getWidth() {
        return -1;
    }

    public int getHeight() {
        return -1;
    }

    public void playIt(Graphics graphics, Component component) {
        Point point = new Point(0, 0);
        Rectangle rectangle = new Rectangle();
        String string = "";
        Font font = Font.decode("Times");
        Polygon polygon = new Polygon();
        Integer n = new Integer(0);
        Boolean bl = new Boolean(false);
        Color color = Color.black;
        Color color2 = Color.white;
        Vector vector = new Vector();
        Dimension dimension = new Dimension();
        GraphicsOperation graphicsOperation = new GraphicsOperation(0);
        if (this.recordingVector == null) {
            return;
        }
        int n2 = 0;
        while (n2 < this.recordingVector.size() && !(this.recordingVector.elementAt(n2) instanceof GraphicsOperation)) {
            if (this.recordingVector.elementAt(n2) instanceof JVGHeader) {
                this.header = (JVGHeader)this.recordingVector.elementAt(n2);
            }
            ++n2;
        }
        try {
            while (n2 < this.recordingVector.size()) {
                n2 = this.getOpVector(this.recordingVector, n2, vector);
                if (vector.size() == 0) {
                    return;
                }
                graphicsOperation = (GraphicsOperation)vector.elementAt(0);
                switch (graphicsOperation.getOperation()) {
                    case 32: {
                        Vector vector2 = this.getObjectsOfType(vector, 1, rectangle.getClass());
                        if (vector2.size() < 1) break;
                        rectangle = (Rectangle)vector2.elementAt(0);
                        if (graphics != null) {
                            graphics.clearRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                        }
                        if (!this.verbose) break;
                        System.out.println("clearRect: " + rectangle);
                        break;
                    }
                    case 33: {
                        Vector vector2 = this.getObjectsOfType(vector, 1, rectangle.getClass());
                        if (vector2.size() < 1) break;
                        rectangle = (Rectangle)vector2.elementAt(0);
                        if (graphics != null) {
                            graphics.clipRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                        }
                        if (!this.verbose) break;
                        System.out.println("clipRect: " + rectangle);
                        break;
                    }
                    case 34: {
                        Vector vector2 = this.getObjectsOfType(vector, 1, rectangle.getClass());
                        if (vector2.size() < 1) break;
                        rectangle = (Rectangle)vector2.elementAt(0);
                        vector2 = this.getObjectsOfType(vector, 1, point.getClass());
                        if (vector2.size() < 1) break;
                        Point point2 = (Point)vector2.elementAt(0);
                        if (graphics != null) {
                            graphics.copyArea(rectangle.x, rectangle.y, rectangle.width, rectangle.height, point2.x, point2.y);
                        }
                        if (!this.verbose) break;
                        System.out.println("copyArea: " + rectangle + ", dx, dy: " + point2);
                        break;
                    }
                    case 35: {
                        Vector vector2 = this.getObjectsOfType(vector, 1, rectangle.getClass());
                        if (vector2.size() < 1) break;
                        rectangle = (Rectangle)vector2.elementAt(0);
                        vector2 = this.getObjectsOfType(vector, 1, bl.getClass());
                        if (vector2.size() > 0) {
                            bl = (Boolean)vector2.elementAt(0);
                        }
                        if (graphics != null) {
                            graphics.draw3DRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height, bl);
                        }
                        if (!this.verbose) break;
                        System.out.println("draw3DRect: " + rectangle + ", raised: " + bl);
                        break;
                    }
                    case 36: {
                        Vector vector2 = this.getObjectsOfType(vector, 1, rectangle.getClass());
                        if (vector2.size() < 1) break;
                        rectangle = (Rectangle)vector2.elementAt(0);
                        vector2 = this.getObjectsOfType(vector, 1, point.getClass());
                        if (vector2.size() < 1) break;
                        Point point2 = (Point)vector2.elementAt(0);
                        if (graphics != null) {
                            graphics.drawArc(rectangle.x, rectangle.y, rectangle.width, rectangle.height, point2.x, point2.y);
                        }
                        if (!this.verbose) break;
                        System.out.println("drawArc: " + rectangle + ", angles: " + point2);
                        break;
                    }
                    case 37: {
                        Vector vector2 = this.getObjectsOfType(vector, 1, n.getClass());
                        if (vector2.size() < 1) break;
                        n = (Integer)vector2.elementAt(0);
                        int n3 = n;
                        Image image = ((ImageSerializer)this.imageVector.elementAt(n3)).getImage();
                        vector2 = this.getObjectsOfType(vector, 1, point.getClass());
                        if (vector2.size() < 1) break;
                        Point point2 = (Point)vector2.elementAt(0);
                        if (graphics != null && component != null) {
                            graphics.drawImage(image, point2.x, point2.y, component);
                        }
                        if (!this.verbose) break;
                        System.out.println("drawImageAtOrigin of image: " + n3 + " at: " + point2);
                        break;
                    }
                    case 38: {
                        Vector vector2 = this.getObjectsOfType(vector, 1, n.getClass());
                        if (vector2.size() < 1) break;
                        n = (Integer)vector2.elementAt(0);
                        int n3 = n;
                        Image image = ((ImageSerializer)this.imageVector.elementAt(n3)).getImage();
                        vector2 = this.getObjectsOfType(vector, 1, rectangle.getClass());
                        if (vector2.size() < 1) break;
                        Rectangle rectangle2 = (Rectangle)vector2.elementAt(0);
                        if (graphics != null && component != null) {
                            graphics.drawImage(image, rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height, component);
                        }
                        if (!this.verbose) break;
                        System.out.println("drawImageInRect of image: " + n3 + " in: " + rectangle2);
                        break;
                    }
                    case 39: {
                        Vector vector2 = this.getObjectsOfType(vector, 1, n.getClass());
                        if (vector2.size() < 1) break;
                        n = (Integer)vector2.elementAt(0);
                        int n3 = n;
                        Image image = ((ImageSerializer)this.imageVector.elementAt(n3)).getImage();
                        vector2 = this.getObjectsOfType(vector, 1, point.getClass());
                        if (vector2.size() < 1) break;
                        Point point2 = (Point)vector2.elementAt(0);
                        vector2 = this.getObjectsOfType(vector, 1, color.getClass());
                        if (vector2.size() < 1) break;
                        Color color3 = (Color)vector2.elementAt(0);
                        if (graphics != null && component != null) {
                            graphics.drawImage(image, point2.x, point2.y, color3, component);
                        }
                        if (!this.verbose) break;
                        System.out.println("drawImageAtPointWithBGColor of image: " + n3 + " at: " + point2 + ", bgColor:" + color3);
                        break;
                    }
                    case 40: {
                        Vector vector2 = this.getObjectsOfType(vector, 1, n.getClass());
                        if (vector2.size() < 1) break;
                        n = (Integer)vector2.elementAt(0);
                        int n3 = n;
                        Image image = ((ImageSerializer)this.imageVector.elementAt(n3)).getImage();
                        vector2 = this.getObjectsOfType(vector, 1, rectangle.getClass());
                        if (vector2.size() < 1) break;
                        Rectangle rectangle2 = (Rectangle)vector2.elementAt(0);
                        vector2 = this.getObjectsOfType(vector, 1, color.getClass());
                        if (vector2.size() < 1) break;
                        Color color3 = (Color)vector2.elementAt(0);
                        if (graphics != null && component != null) {
                            graphics.drawImage(image, rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height, color3, component);
                        }
                        if (!this.verbose) break;
                        System.out.println("drawImageInRectWithBGColor of image: " + n3 + " in: " + rectangle2 + ", bgColor:" + color3);
                        break;
                    }
                    case 41: {
                        Vector vector2 = this.getObjectsOfType(vector, 1, n.getClass());
                        if (vector2.size() < 1) break;
                        n = (Integer)vector2.elementAt(0);
                        int n3 = n;
                        Image image = ((ImageSerializer)this.imageVector.elementAt(n3)).getImage();
                        vector2 = this.getObjectsOfType(vector, 1, rectangle.getClass());
                        if (vector2.size() < 2) break;
                        Rectangle rectangle3 = (Rectangle)vector2.elementAt(0);
                        Rectangle rectangle4 = (Rectangle)vector2.elementAt(1);
                        if (graphics != null && component != null) {
                            graphics.drawImage(image, rectangle4.x, rectangle4.y, rectangle4.x + rectangle4.width, rectangle4.y + rectangle4.height, rectangle3.x, rectangle3.y, rectangle3.x + rectangle3.width, rectangle3.y + rectangle3.height, component);
                        }
                        if (!this.verbose) break;
                        System.out.println("drawSubimageInRect of image: " + n3 + " src: " + rectangle3 + ", dst:" + rectangle4);
                        break;
                    }
                    case 42: {
                        Vector vector2 = this.getObjectsOfType(vector, 1, n.getClass());
                        if (vector2.size() < 1) break;
                        n = (Integer)vector2.elementAt(0);
                        int n3 = n;
                        Image image = ((ImageSerializer)this.imageVector.elementAt(n3)).getImage();
                        vector2 = this.getObjectsOfType(vector, 1, rectangle.getClass());
                        if (vector2.size() < 2) break;
                        Rectangle rectangle3 = (Rectangle)vector2.elementAt(0);
                        Rectangle rectangle4 = (Rectangle)vector2.elementAt(1);
                        vector2 = this.getObjectsOfType(vector, 1, color.getClass());
                        if (vector2.size() < 1) break;
                        Color color3 = (Color)vector2.elementAt(0);
                        if (graphics != null && component != null) {
                            graphics.drawImage(image, rectangle4.x, rectangle4.y, rectangle4.x + rectangle4.width, rectangle4.y + rectangle4.height, rectangle3.x, rectangle3.y, rectangle3.x + rectangle3.width, rectangle3.y + rectangle3.height, color3, component);
                        }
                        if (!this.verbose) break;
                        System.out.println("drawSubimageInRectWithBGColor of image: " + n3 + " src: " + rectangle3 + ", dst:" + rectangle4 + ", bgColor:" + color3);
                        break;
                    }
                    case 43: {
                        Vector vector2 = this.getObjectsOfType(vector, 1, point.getClass());
                        if (vector2.size() < 2) break;
                        Point point2 = (Point)vector2.elementAt(0);
                        point = (Point)vector2.elementAt(1);
                        if (graphics != null) {
                            graphics.drawLine(point2.x, point2.y, point.x, point.y);
                        }
                        if (!this.verbose) break;
                        System.out.println("Line from " + point2 + " to " + point);
                        break;
                    }
                    case 44: {
                        Vector vector2 = this.getObjectsOfType(vector, 1, rectangle.getClass());
                        if (vector2.size() < 1) break;
                        rectangle = (Rectangle)vector2.elementAt(0);
                        if (graphics != null) {
                            graphics.drawOval(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                        }
                        if (!this.verbose) break;
                        System.out.println("Oval: " + rectangle);
                        break;
                    }
                    case 45: {
                        Vector vector2 = this.getObjectsOfType(vector, 1, polygon.getClass());
                        if (vector2.size() < 1) break;
                        polygon = (Polygon)vector2.elementAt(0);
                        if (graphics != null) {
                            graphics.drawPolygon(polygon);
                        }
                        if (!this.verbose) break;
                        System.out.println("drawPolygon: " + polygon);
                        break;
                    }
                    case 46: {
                        Vector vector2 = this.getObjectsOfType(vector, 1, polygon.getClass());
                        if (vector2.size() < 1) break;
                        polygon = (Polygon)vector2.elementAt(0);
                        if (graphics != null) {
                            graphics.drawPolyline(polygon.xpoints, polygon.ypoints, polygon.npoints);
                        }
                        if (!this.verbose) break;
                        System.out.println("drawPolyline: " + polygon);
                        break;
                    }
                    case 47: {
                        Vector vector2 = this.getObjectsOfType(vector, 1, rectangle.getClass());
                        if (vector2.size() < 1) break;
                        rectangle = (Rectangle)vector2.elementAt(0);
                        if (graphics != null) {
                            graphics.drawRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                        }
                        if (!this.verbose) break;
                        System.out.println("drawRect: " + rectangle);
                        break;
                    }
                    case 48: {
                        Vector vector2 = this.getObjectsOfType(vector, 1, rectangle.getClass());
                        if (vector2.size() < 1) break;
                        rectangle = (Rectangle)vector2.elementAt(0);
                        vector2 = this.getObjectsOfType(vector, 1, dimension.getClass());
                        if (vector2.size() < 1) break;
                        dimension = (Dimension)vector2.elementAt(0);
                        if (graphics != null) {
                            graphics.drawRoundRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height, dimension.width, dimension.height);
                        }
                        if (!this.verbose) break;
                        System.out.println("drawRoundRect: " + rectangle + ", corner arc: " + dimension);
                        break;
                    }
                    case 49: {
                        Vector vector2 = this.getObjectsOfType(vector, 1, string.getClass());
                        if (vector2.size() < 1) break;
                        string = (String)vector2.elementAt(0);
                        vector2 = this.getObjectsOfType(vector, 1, point.getClass());
                        if (vector2.size() < 1) break;
                        point = (Point)vector2.elementAt(0);
                        if (graphics != null) {
                            graphics.drawString(string, point.x, point.y);
                        }
                        if (!this.verbose) break;
                        System.out.println("drawString: " + string + ", " + point);
                        break;
                    }
                    case 50: {
                        Vector vector2 = this.getObjectsOfType(vector, 1, rectangle.getClass());
                        if (vector2.size() < 1) break;
                        rectangle = (Rectangle)vector2.elementAt(0);
                        vector2 = this.getObjectsOfType(vector, 1, bl.getClass());
                        if (vector2.size() > 0) {
                            bl = (Boolean)vector2.elementAt(0);
                        }
                        if (graphics != null) {
                            graphics.fill3DRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height, bl);
                        }
                        if (!this.verbose) break;
                        System.out.println("fill3DRect: " + rectangle + ", raised: " + bl);
                        break;
                    }
                    case 51: {
                        Vector vector2 = this.getObjectsOfType(vector, 1, rectangle.getClass());
                        if (vector2.size() < 1) break;
                        rectangle = (Rectangle)vector2.elementAt(0);
                        vector2 = this.getObjectsOfType(vector, 1, point.getClass());
                        if (vector2.size() < 1) break;
                        Point point2 = (Point)vector2.elementAt(0);
                        if (graphics != null) {
                            graphics.fillArc(rectangle.x, rectangle.y, rectangle.width, rectangle.height, point2.x, point2.y);
                        }
                        if (!this.verbose) break;
                        System.out.println("fillArc: " + rectangle + ", angles: " + point2);
                        break;
                    }
                    case 52: {
                        Vector vector2 = this.getObjectsOfType(vector, 1, rectangle.getClass());
                        if (vector2.size() < 1) break;
                        rectangle = (Rectangle)vector2.elementAt(0);
                        if (graphics != null) {
                            graphics.fillOval(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                        }
                        if (!this.verbose) break;
                        System.out.println("fillOval: " + rectangle);
                        break;
                    }
                    case 53: {
                        Vector vector2 = this.getObjectsOfType(vector, 1, polygon.getClass());
                        if (vector2.size() < 1) break;
                        polygon = (Polygon)vector2.elementAt(0);
                        if (graphics != null) {
                            graphics.fillPolygon(polygon);
                        }
                        if (!this.verbose) break;
                        System.out.println("fillPolygon: " + polygon);
                        break;
                    }
                    case 54: {
                        Vector vector2 = this.getObjectsOfType(vector, 1, rectangle.getClass());
                        if (vector2.size() < 1) break;
                        rectangle = (Rectangle)vector2.elementAt(0);
                        if (graphics != null) {
                            graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                        }
                        if (!this.verbose) break;
                        System.out.println("fillRect: " + rectangle);
                        break;
                    }
                    case 55: {
                        Vector vector2 = this.getObjectsOfType(vector, 1, rectangle.getClass());
                        if (vector2.size() < 1) break;
                        rectangle = (Rectangle)vector2.elementAt(0);
                        vector2 = this.getObjectsOfType(vector, 1, dimension.getClass());
                        if (vector2.size() < 1) break;
                        dimension = (Dimension)vector2.elementAt(0);
                        if (graphics != null) {
                            graphics.fillRoundRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height, dimension.width, dimension.height);
                        }
                        if (!this.verbose) break;
                        System.out.println("fillRoundRect: " + rectangle + ", corner arc: " + dimension);
                        break;
                    }
                    case 56: {
                        Vector vector2 = this.getObjectsOfType(vector, 1, rectangle.getClass());
                        if (vector2.size() < 1) break;
                        rectangle = (Rectangle)vector2.elementAt(0);
                        if (graphics != null) {
                            graphics.setClip(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                        }
                        if (!this.verbose) break;
                        System.out.println("SetClip: " + rectangle);
                        break;
                    }
                    case 57: {
                        Vector vector2 = this.getObjectsOfType(vector, 1, color.getClass());
                        if (vector2.size() < 1) break;
                        color = (Color)vector2.elementAt(0);
                        if (graphics != null) {
                            graphics.setColor(color);
                        }
                        if (!this.verbose) break;
                        System.out.println("setColor: " + color);
                        break;
                    }
                    case 58: {
                        Vector vector2 = this.getObjectsOfType(vector, 1, font.getClass());
                        if (vector2.size() < 1) break;
                        font = (Font)vector2.elementAt(0);
                        if (graphics != null) {
                            graphics.setFont(font);
                        }
                        if (!this.verbose) break;
                        System.out.println("setFont: " + font);
                        break;
                    }
                    case 59: {
                        if (graphics != null) {
                            graphics.setPaintMode();
                        }
                        if (!this.verbose) break;
                        System.out.println("setPaintMode");
                        break;
                    }
                    case 60: {
                        Vector vector2 = this.getObjectsOfType(vector, 1, color2.getClass());
                        if (vector2.size() < 1) break;
                        color2 = (Color)vector2.elementAt(0);
                        if (graphics != null) {
                            graphics.setXORMode(color2);
                        }
                        if (!this.verbose) break;
                        System.out.println("setXORMode: " + color2);
                        break;
                    }
                    case 61: {
                        Vector vector2 = this.getObjectsOfType(vector, 1, point.getClass());
                        if (vector2.size() < 1) break;
                        point = (Point)vector2.elementAt(0);
                        if (graphics != null) {
                            graphics.translate(point.x, point.y);
                        }
                        if (!this.verbose) break;
                        System.out.println("translate: " + point);
                        break;
                    }
                }
            }
            return;
        }
        catch (InvalidObjectException invalidObjectException) {
            return;
        }
    }

    public int checkImage() {
        return 32;
    }

    public synchronized boolean readFromFile(File file) {
        GZIPInputStream gZIPInputStream = null;
        try {
            ObjectInputStream objectInputStream;
            FileInputStream fileInputStream = new FileInputStream(file);
            byte[] byArray = new byte[IMG_FILE_SIGNATURE.length];
            fileInputStream.read(byArray);
            int n = 0;
            while (n < IMG_FILE_SIGNATURE.length) {
                if (byArray[n] != IMG_FILE_SIGNATURE[n]) {
                    throw new IOException("Wrong file signature");
                }
                ++n;
            }
            byte[] byArray2 = new byte[1];
            fileInputStream.read(byArray2);
            switch (byArray2[0]) {
                case 1: {
                    gZIPInputStream = new GZIPInputStream(fileInputStream);
                    objectInputStream = new ObjectInputStream(gZIPInputStream);
                    break;
                }
                default: {
                    objectInputStream = new ObjectInputStream(fileInputStream);
                }
            }
            this.readObject(objectInputStream);
            objectInputStream.close();
            if (gZIPInputStream != null) {
                gZIPInputStream.close();
            }
            fileInputStream.close();
        }
        catch (IOException iOException) {
            System.err.println("IOException: " + iOException);
            return false;
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.err.println("ClassNotFoundException: " + classNotFoundException);
            return false;
        }
        return true;
    }

    public synchronized boolean saveToFile(File file) {
        byte[] byArray = new byte[1];
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            fileOutputStream.write(IMG_FILE_SIGNATURE);
            byArray[0] = 1;
            fileOutputStream.write(byArray);
            GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(fileOutputStream);
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(gZIPOutputStream);
            this.writeObject(objectOutputStream);
            objectOutputStream.flush();
            objectOutputStream.close();
            gZIPOutputStream.close();
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeObject(this.imageVector);
        objectOutputStream.writeObject(this.recordingVector);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.imageVector = (ImageSerializerVector)objectInputStream.readObject();
        this.recordingVector = (Vector)objectInputStream.readObject();
    }

    private int getOpVector(Vector vector, int n, Vector vector2) throws InvalidObjectException {
        new GraphicsOperation(0);
        vector2.removeAllElements();
        if (!(vector.elementAt(n) instanceof GraphicsOperation)) {
            throw new InvalidObjectException("Not valid GraphicsOperation object");
        }
        vector2.addElement(vector.elementAt(n));
        ++n;
        while (n < vector.size() && !(vector.elementAt(n) instanceof GraphicsOperation)) {
            vector2.addElement(vector.elementAt(n));
            ++n;
        }
        return n;
    }

    private Vector getObjectsOfType(Vector vector, int n, Class clazz) throws InvalidObjectException {
        Vector vector2 = new Vector();
        int n2 = n;
        while (n2 < vector.size()) {
            if (vector.elementAt(n2).getClass() == clazz) {
                vector2.addElement(vector.elementAt(n2));
            }
            ++n2;
        }
        return vector2;
    }

    private int getStoredImage(Image image) {
        int n = 0;
        while (n < this.imageVector.size()) {
            if (image == ((ImageSerializer)this.imageVector.elementAt(n)).getImage()) {
                return n;
            }
            ++n;
        }
        this.imageVector.addElement(new ImageSerializer(image));
        return this.imageVector.size() - 1;
    }
}

