/*
 * Decompiled with CFR 0.152.
 */
package fi.faidon.jis;

import fi.faidon.jis.DirectColorModelSerializer;
import fi.faidon.jis.ImageSaverInterface;
import fi.faidon.jis.IndexColorModelSerializer;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.MemoryImageSource;
import java.awt.image.PixelGrabber;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class ImageSerializer
extends ImageSaverInterface
implements Serializable {
    public static final int NO_COMPRESSION = 0;
    public static final String FORMAT_CODE = "JSI";
    public static final String FORMAT_COMPLETE_NAME = "Java Serialized Image";
    public static final String FORMAT_EXTENSION = "jsi";
    private ColorModel imgColorModel;
    private Rectangle imgBounds;
    private byte[] imgPixels;
    private int compression = 0;
    private int saveStatus;

    public ImageSerializer() {
    }

    public ImageSerializer(Image image) {
        this();
        this.saveImage = image;
    }

    public String getFormatCode() {
        return FORMAT_CODE;
    }

    public String getFormatString() {
        return FORMAT_COMPLETE_NAME;
    }

    public String getFormatExtension() {
        return FORMAT_EXTENSION;
    }

    public boolean saveIt() {
        return true;
    }

    public int checkSave() {
        return this.saveStatus;
    }

    public Image getImage() {
        return this.saveImage;
    }

    public void setImage(Image image) {
        this.saveImage = image;
    }

    public int getCompression() {
        return this.compression;
    }

    public void setCompression(int n) {
        this.compression = n;
    }

    public ColorModel getColorModel() {
        return this.imgColorModel;
    }

    public int getImageWidth() {
        if (this.imgBounds == null) {
            return -1;
        }
        return this.imgBounds.width;
    }

    public int getImageHeight() {
        if (this.imgBounds == null) {
            return -1;
        }
        return this.imgBounds.height;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (this.saveImage == null) {
            return;
        }
        PixelGrabber pixelGrabber = new PixelGrabber(this.saveImage, 0, 0, -1, -1, false);
        try {
            pixelGrabber.grabPixels();
        }
        catch (InterruptedException interruptedException) {
            System.err.println("Interrupted waiting for pixels!");
            return;
        }
        if ((pixelGrabber.getStatus() & 0x80) != 0) {
            System.err.println("Image fetch aborted or errored.");
            return;
        }
        objectOutputStream.writeInt(this.compression);
        this.imgBounds = new Rectangle(0, 0, pixelGrabber.getWidth(), pixelGrabber.getHeight());
        objectOutputStream.writeObject(this.imgBounds);
        this.imgColorModel = pixelGrabber.getColorModel();
        if (this.imgColorModel instanceof IndexColorModel) {
            objectOutputStream.writeObject(new IndexColorModelSerializer((IndexColorModel)this.imgColorModel));
        } else if (this.imgColorModel instanceof DirectColorModel) {
            objectOutputStream.writeObject(new DirectColorModelSerializer((DirectColorModel)this.imgColorModel));
        }
        Object object = pixelGrabber.getPixels();
        objectOutputStream.writeObject(object);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.compression = objectInputStream.readInt();
        this.imgBounds = (Rectangle)objectInputStream.readObject();
        Object object = objectInputStream.readObject();
        if (object instanceof IndexColorModelSerializer) {
            this.imgColorModel = ((IndexColorModelSerializer)object).getModel();
        } else if (object instanceof DirectColorModelSerializer) {
            this.imgColorModel = ((DirectColorModelSerializer)object).getModel();
        } else {
            throw new IOException("No ColorModel!");
        }
        Object object2 = objectInputStream.readObject();
        if (object2 instanceof byte[]) {
            byte[] byArray = (byte[])object2;
            this.saveImage = Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(this.imgBounds.width, this.imgBounds.height, this.imgColorModel, byArray, 0, this.imgBounds.width));
            return;
        }
        if (object2 instanceof int[]) {
            int[] nArray = (int[])object2;
            this.saveImage = Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(this.imgBounds.width, this.imgBounds.height, this.imgColorModel, nArray, 0, this.imgBounds.width));
            return;
        }
        throw new IOException("Invalid pixel format!");
    }
}

