/*
 * Decompiled with CFR 0.152.
 */
package fi.faidon.jis;

import fi.faidon.jis.BMPImageSaver;
import fi.faidon.jis.ImageSaverInterface;
import fi.faidon.jis.PICTImageSaver;
import fi.faidon.jis.PNGImageSaver;
import fi.faidon.jis.TIFFImageSaver;
import fi.faidon.jis.TargaImageSaver;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Image;
import java.io.Serializable;

public class ImageSaverObject
implements Serializable {
    private final String STR_SAVE_IMAGE_DIAL_TITLE = "Save image...";
    private transient Image saveImage;
    private transient String savePath;
    private String saveFormat;
    private transient ImageSaverInterface imageSaver;

    public boolean saveIt() {
        if (this.saveImage == null || this.savePath == null || this.savePath.equals("") || this.saveFormat == null) {
            return false;
        }
        if (this.saveFormat.equals("TIFF")) {
            this.imageSaver = new TIFFImageSaver();
        } else if (this.saveFormat.equals(TargaImageSaver.FORMAT_CODE)) {
            this.imageSaver = new TargaImageSaver();
        } else if (this.saveFormat.equals("PICT")) {
            this.imageSaver = new PICTImageSaver();
        } else if (this.saveFormat.equals("BMP")) {
            this.imageSaver = new BMPImageSaver();
        } else if (this.saveFormat.equals("PNG")) {
            this.imageSaver = new PNGImageSaver();
        } else {
            return false;
        }
        if (this.imageSaver != null) {
            this.imageSaver.setSaveImage(this.saveImage);
            this.imageSaver.setSavePath(this.savePath);
            return this.imageSaver.saveIt();
        }
        return false;
    }

    public int checkSave() {
        if (this.imageSaver == null) {
            return 64;
        }
        return this.imageSaver.checkSave();
    }

    public boolean saveToFile(Image image, String string, String string2) {
        this.saveImage = image;
        this.savePath = string;
        this.saveFormat = string2;
        return this.saveIt();
    }

    public void setSaveImage(Image image) {
        this.saveImage = image;
    }

    public void setSavePath(String string) {
        this.savePath = string;
    }

    public void setSaveFormat(String string) {
        this.saveFormat = string;
    }

    public boolean saveTIFF() {
        this.imageSaver = new TIFFImageSaver();
        return this.saveWithImageSaver();
    }

    public boolean saveTarga() {
        this.imageSaver = new TargaImageSaver();
        return this.saveWithImageSaver();
    }

    public boolean savePICT() {
        this.imageSaver = new PICTImageSaver();
        return this.saveWithImageSaver();
    }

    public boolean saveBMP() {
        this.imageSaver = new BMPImageSaver();
        return this.saveWithImageSaver();
    }

    public boolean savePNG() {
        this.imageSaver = new PNGImageSaver();
        return this.saveWithImageSaver();
    }

    public void saveAsTIFF() {
        this.savePath = this.getSaveAsPath();
        if (this.savePath == null) {
            return;
        }
        this.saveTIFF();
    }

    public void saveAsTarga() {
        this.savePath = this.getSaveAsPath();
        if (this.savePath == null) {
            return;
        }
        this.saveTarga();
    }

    public void saveAsPICT() {
        this.savePath = this.getSaveAsPath();
        if (this.savePath == null) {
            return;
        }
        this.savePICT();
    }

    public void saveAsBMP() {
        this.savePath = this.getSaveAsPath();
        if (this.savePath == null) {
            return;
        }
        this.saveBMP();
    }

    public void saveAsPNG() {
        this.savePath = this.getSaveAsPath();
        if (this.savePath == null) {
            return;
        }
        this.savePNG();
    }

    private String getSaveAsPath() {
        if (this.saveImage == null) {
            return null;
        }
        FileDialog fileDialog = new FileDialog(new Frame(), "Save image...", 1);
        fileDialog.show();
        if (fileDialog.getFile() == null) {
            return null;
        }
        return String.valueOf(fileDialog.getDirectory()) + fileDialog.getFile();
    }

    public boolean saveWithImageSaver() {
        if (this.imageSaver == null || this.saveImage == null || this.savePath == null || this.savePath.equals("")) {
            return false;
        }
        this.imageSaver.setSaveImage(this.saveImage);
        this.imageSaver.setSavePath(this.savePath);
        return this.imageSaver.saveIt();
    }
}

