
/*****************************************************************************
 *														                     *
 *                                 TestTarga.java                            *
 *                                                                           *
 * Small command-line application for demonstrating the image saving beans.  *
 *                                                                           *
 * Created by Kary FRAMLING 30/4/1998                                        *
 *                                                                           *
 *****************************************************************************/

import java.io.*;
import java.awt.*;
import fi.faidon.jis.*;
import java.awt.image.ImageObserver;

public class TestTarga
{

	//=============================================================================
	// main 
	//=============================================================================
	/**
	 * Program entry point.
	 *
	 * @author Kary FR&Auml;MLING
	 */
	//=============================================================================
	public static void main(String argv[])
	{
		File		current_dir;
		Image		img;
		String		current_path, img_path;
		TargaImageSaver	is;

		// See that we have an image name.
		if ( argv.length < 2 ) {
			System.out.println("Usage: TestTarga <source image file> <dest image file>");
			System.exit(1);
		}

		// Verify that the source file exists.
		if ( !(new File(argv[0])).exists() ) {
			System.out.println("Source file not found!");
			System.exit(1);
		}

		// We use an image relative to our launch directory.
		img = Toolkit.getDefaultToolkit().getImage(argv[0]);
		is = new TargaImageSaver();
		is.setSaveImage(img);
		is.setSavePath(argv[1]);
		is.saveIt();

		// Wait until saving is ready.
		while ( (is.checkSave() & ( ImageObserver.ALLBITS | ImageObserver.ABORT | ImageObserver.ERROR )) == 0 ) {
			System.out.println("Waiting for save to finish!");
			try { Thread.sleep(100); } 
			catch ( InterruptedException e ) { System.exit(1); }
		}
		System.exit(0);
	}

}
