
/*****************************************************************************
 *														                     *
 *                               ReplayTest.java                             *
 *                                                                           *
 * Created by Kary FRAMLING 27/4/1998                                        *
 *                                                                           *
 *****************************************************************************/

import java.io.*;
import java.awt.*;
import java.awt.image.*;
import java.util.Vector;
import fi.faidon.jis.*;
import fi.faidon.jvg.*;

/**
 * Small application which reads a JVG file and displays it in a frame.
 *
 * @author Kary FR&Auml;MLING 27/4/1998
 */
public class ReplayTest
{

    //-----------------------------------------------------------------
	// main
    //-----------------------------------------------------------------
	/**
	 * Get a GraphicsRecording from the specified file and display it 
	 * in an ImageFrame.
	 */
    //-----------------------------------------------------------------
	public static void main(String[] argv)
	{
		Vector	ops;
		Image	img;

		// Check that we have a file name.
		if ( argv.length < 1 ) {
			System.out.println("No image file specified!");
			System.exit(1);
		}

		// Read the GraphicsRecording object from the file.
		// Use verbose mode for demonstration purposes.
		GraphicsRecording gr = new GraphicsRecording();
		gr.setVerbose(true);
		if ( gr.readFromFile(new File(argv[0])) ) {
			ImageFrame f = new ImageFrame(gr);
			f.setSize(550, 500);
			f.show();
		}
	}

}