
/*****************************************************************************
 *														                     *
 *                                 PICTtoJVGtest.java                        *
 *                                                                           *
 * Created by Kary FRAMLING 5/5/1998                                         *
 *                                                                           *
 *****************************************************************************/

import java.io.*;
import fi.faidon.jvg.*;

/**
 * Small program for converting a PICT file into a JVG (Java Vectorized 
 * Graphics) file. 
 *
 * @author Kary FR&Auml;MLING 5/5/1998
 */
public class PICTtoJVGtest
{

	//=============================================================================
	// main
	//=============================================================================
	/**
	 * Small program for converting a PICT file into a JVG (Java Vectorized 
	 * Graphics) file.
	 *
	 * @author Kary FR&Auml;MLING 15/4/1998
	 */
	//=============================================================================
	public static void main(String[] argv)
	{
		RecorderGraphics	rg;

		// Verify that we have a picture file name.
		if ( argv.length < 2 ) {
			System.out.println("Usage: PICTread <name of PICT file> <name of JVG file>");
			System.exit(1);
		}
 
		// Create a PICTReader, draw the PICT into a RecorderGraphics and save 
		// the recording to file.
		PICTReader pr = new PICTReader();
		pr.setImageFile(argv[0]);
		rg = new RecorderGraphics();
		pr.playIt(rg);
		GraphicsRecording gr = rg.getRecording();
		File out_file = new File(argv[1]);
		gr.saveToFile(out_file);

		System.exit(0);
	}
}

