
/*****************************************************************************
 *														                     *
 *                         ImgRecordingTest.java                             *
 *                                                                           *
 * Created by Kary FRAMLING 16/5/1998                                        *
 *                                                                           *
 *****************************************************************************/

import java.io.*;
import java.awt.*;
import java.awt.event.*;
import java.awt.image.*;
import java.util.Vector;
import fi.faidon.jvg.*;

/**
 * Small application for creating a GraphicsRecording and saving it onto 
 * disk in the JVG format. This example shows various image saving 
 * options. 
 *
 * @author Kary FR&Auml;MLING
 */
public class ImgRecordingTest extends Frame implements ActionListener
{

	Button	exitButton;

    //-----------------------------------------------------------------
	// main
    //-----------------------------------------------------------------
	/**
	 * Test main function.
	 *
	 * @author Kary FR&Auml;MLING
	 */
    //-----------------------------------------------------------------
	public static void main(String[] argv)
	{
		Vector	ops;
		Image	img;

		// Check that we have a file name.
		if ( argv.length < 1 ) {
			System.out.println("No image file specified!");
			System.exit(1);
		}

		// Create the frame and display everything.
		new ImgRecordingTest(argv[0]);
	}

    //-----------------------------------------------------------------
	// Constructor
    //-----------------------------------------------------------------
	/**
	 * Create a new instance using the image at path "path".
	 *
	 * @author Kary FR&Auml;MLING
	 */
    //-----------------------------------------------------------------
	public ImgRecordingTest(String path)
	{
		ImgRecordingImagePanel ip = new ImgRecordingImagePanel(path);
		initFrame(ip);
	}

    //-----------------------------------------------------------------
	// initFrame
    //-----------------------------------------------------------------
	/**
	 * Set up the frame.
	 *
	 * @author Kary FR&Auml;MLING
	 */
    //-----------------------------------------------------------------
	private void initFrame(ImgRecordingImagePanel ip)
	{
		setLayout(new BorderLayout());
		add("Center", ip);
		Panel button_panel = new Panel();
		add("South", button_panel);
		button_panel.setLayout(new FlowLayout());
		exitButton = new Button("Exit");
		exitButton.addActionListener(this);
		button_panel.add(exitButton);
		setSize(550, 500);
		show();
	}

    //-----------------------------------------------------------------
	// actionPerformed
    //-----------------------------------------------------------------
	/**
	 * Exit no matter what button is pressed.
	 *
	 * @author Kary FR&Auml;MLING
	 */
    //-----------------------------------------------------------------
	public void actionPerformed(ActionEvent e) 
	{
		System.exit(0);
	}

}

/**
 * Panel extending class for showing the graphics operations.
 *
 * @author Kary FR&Auml;MLING 27/4/1998
 */
class ImgRecordingImagePanel extends Panel
{
	String	imagePath;
	GraphicsRecording	recording;

    //-----------------------------------------------------------------
	// Constructor
    //-----------------------------------------------------------------
	/**
	 * Create a new instance using the image at path "path".
	 *
	 * @author Kary FR&Auml;MLING
	 */
    //-----------------------------------------------------------------
	public ImgRecordingImagePanel(String path)
	{
		imagePath = path;
	}

    //-----------------------------------------------------------------
	// paint {OVERRIDE}
    //-----------------------------------------------------------------
	/**
	 * Create a new recording if we don't have one yet and then display 
	 * it. The display becomes very flickery if we have a lot of pixmap 
	 * images to display, so it is useful to either override "imageUpdate" 
	 * or check that every image is ready. 
	 *
	 * @author Kary FR&Auml;MLING
	 */
    //-----------------------------------------------------------------
	public void paint(Graphics g) 
	{
		Image	img1, img2;
		Image[]	recording_imgs;

		// If we have no recording yet, then create it, do the drawing and save it to file.
		if ( recording == null ) {

			// Create a RecorderGraphics that records the operations. We could also 
			// do this with a Graphics object of a Component, but this is not 
			// necessary here.
			RecorderGraphics rg = new RecorderGraphics(g);

			// Get the images.
			img2 = Toolkit.getDefaultToolkit().getImage("Image2.gif");
			img1 = Toolkit.getDefaultToolkit().getImage("Image1.jpg");

			// Do a number of image drawing operations.
			rg.drawImage(img1, 0, 0, this);
			rg.drawImage(img2, 300, 50, 200, 150, Color.yellow, this);
			rg.drawImage(img2, 100, 100, this);
			rg.drawImage(img1, 200, 250, 300, 250, this);
			rg.drawImage(img2, 300, 300, 400, 366, 50, 40, 250, 140, this);
			rg.drawImage(img2, 0, 300, 140, 400, 105, 40, 315, 140, Color.green, this);
			rg.drawString("This is a RecordingTest!", 100, 250);

			// Get the recording.
			recording = rg.getRecording();

			// Save the recording into the given file.
			recording.saveToFile(new File(imagePath));
		}

		// Play the recording. 
		recording.playIt(g, this);
	}

    //-----------------------------------------------------------------
	// imageUpdate {OVERRIDE}
    //-----------------------------------------------------------------
	/**
	 * Update only when images are complete to reduce flickering. 
	 *
	 * @author Kary FR&Auml;MLING
	 */
    //-----------------------------------------------------------------
	public boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height)
	{
		if ( (infoflags & ALLBITS) > 0 ) {
			return super.imageUpdate(img, infoflags, x, y, width, height);
		}
		else {
			return true;
		}
	}

}

