/*
 * Decompiled with CFR 0.152.
 */
package fi.faidon.jvg;

import fi.faidon.jvg.VectorImageProducer;
import fi.faidon.protection.SerialNumberManager;
import fi.faidon.util.ByteArrayConversion;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.MemoryImageSource;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;

public class PNGReader
extends VectorImageProducer {
    private final boolean OBLIGATORY_REGISTRATION = true;
    private final byte[] PNG_IDENTIFICATION_BYTES = new byte[]{-119, 80, 78, 71, 13, 10, 26, 10};
    private final int CHUNK_LENGTH_SIZE = 4;
    private final int CHUNK_TYPE_SIZE = 4;
    private final int CHUNK_CRC_SIZE = 4;
    private final int IHDR_DATA_SIZE = 13;
    private final int INFLATE_BUF_SIZE = 512;
    private final byte COLOR_TYPE_PALETTE_USED = 1;
    private final byte COLOR_TYPE_COLOR_USED = (byte)2;
    private final byte COLOR_TYPE_USE_ALPHA_CHANNEL = (byte)4;
    private final byte NO_FILTERING = 0;
    private final byte SUB_FILTER = 1;
    private final byte UP_FILTER = (byte)2;
    private final byte AVERAGE_FILTER = (byte)3;
    private final byte PAETH_FILTER = (byte)4;
    private final byte[] IHDR_CHUNK_TYPE = new byte[]{73, 72, 68, 82};
    private final byte[] PLTE_CHUNK_TYPE = new byte[]{80, 76, 84, 69};
    private final byte[] IDAT_CHUNK_TYPE = new byte[]{73, 68, 65, 84};
    private final byte[] IEND_CHUNK_TYPE = new byte[]{73, 69, 78, 68};
    private final byte[] tRNS_CHUNK_TYPE = new byte[]{116, 82, 78, 83};
    private File pictureFile;
    private FileInputStream pictureFIS;
    private BufferedInputStream pictureBIS;
    private Image pngImage;
    private boolean verbose;
    private int width;
    private int height;
    private int bitDepth;
    private int colorType;
    private int compressionMethod;
    private int filterMethod;
    private int interlaceMethod;
    private int version;
    private Graphics drawGraphics;
    private Component drawComponent;
    private boolean hdrIsRead;
    private int pixmapSize;
    private byte[] rawPixmap;
    private int pixmapX;
    private int pixmapY;
    private int bytesPerPixel;
    private int destImageBPP;
    private boolean useAlpha;
    private boolean isGrayScale;
    private boolean needsPalette;
    private boolean useIndexColorModel;
    private IndexColorModel indexCModel;
    private int maxColorValue;

    public PNGReader() {
        SerialNumberManager serialNumberManager = new SerialNumberManager();
        if (!serialNumberManager.verifyCurrentPackage()) {
            System.err.println("Unregistered version or evaluation period expired!");
            System.err.println("Exiting...");
            System.exit(1);
        }
        this.hdrIsRead = false;
        this.verbose = false;
        this.useAlpha = false;
        this.isGrayScale = false;
        this.useIndexColorModel = false;
    }

    public int getWidth() {
        if (!this.hdrIsRead) {
            this.getFrame();
        }
        return this.width;
    }

    public int getHeight() {
        if (!this.hdrIsRead) {
            this.getFrame();
        }
        return this.height;
    }

    public Image getImage() {
        if (this.pngImage == null) {
            this.readPNGFile();
        }
        return this.pngImage;
    }

    public void playIt(Graphics graphics, Component component) {
        this.drawGraphics = graphics;
        this.drawComponent = component;
        if (this.readPNGFile() && this.pngImage != null) {
            this.drawGraphics.drawImage(this.pngImage, 0, 0, this.drawComponent);
        }
    }

    public int checkImage() {
        return 32;
    }

    public void setImageFile(String string) {
        this.pictureFile = new File(string);
        this.hdrIsRead = false;
    }

    public void setVerbose(boolean bl) {
        this.verbose = bl;
    }

    public boolean isVerbose(boolean bl) {
        return this.verbose;
    }

    public boolean readPNGFile() {
        if (!this.getInputStreams()) {
            return false;
        }
        if (!this.readHeader(this.pictureBIS)) {
            if (this.verbose) {
                System.out.println("Error parsing file!");
            }
            this.closeInputStreams();
            return false;
        }
        if (!this.readChunks(this.pictureBIS)) {
            this.closeInputStreams();
            if (this.verbose) {
                System.out.println("Error parsing file!");
            }
            return false;
        }
        this.closeInputStreams();
        if (this.verbose) {
            System.out.println("Finished reading file!");
        }
        return true;
    }

    private boolean getFrame() {
        if (!this.getInputStreams()) {
            return false;
        }
        if (!this.readHeader(this.pictureBIS)) {
            if (this.verbose) {
                System.out.println("Error parsing file!");
            }
            this.closeInputStreams();
            return false;
        }
        this.closeInputStreams();
        return true;
    }

    private boolean getInputStreams() {
        if (this.pictureFile == null || !this.pictureFile.exists()) {
            return false;
        }
        try {
            this.pictureFIS = new FileInputStream(this.pictureFile);
            this.pictureBIS = new BufferedInputStream(this.pictureFIS);
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }

    private void closeInputStreams() {
        try {
            if (this.pictureBIS != null) {
                ((FilterInputStream)this.pictureBIS).close();
            }
            if (this.pictureFIS != null) {
                this.pictureFIS.close();
                return;
            }
        }
        catch (IOException iOException) {}
    }

    private boolean readHeader(BufferedInputStream bufferedInputStream) {
        byte[] byArray = new byte[25];
        if (bufferedInputStream == null) {
            return false;
        }
        try {
            byte[] byArray2 = new byte[this.PNG_IDENTIFICATION_BYTES.length];
            this.fillByteBuf(bufferedInputStream, byArray2, 0, byArray2.length);
            int n = 0;
            while (n < byArray2.length && n < this.PNG_IDENTIFICATION_BYTES.length) {
                if (byArray2[n] != this.PNG_IDENTIFICATION_BYTES[n]) {
                    if (this.verbose) {
                        System.out.println("Not valid PNG file identifier!");
                    }
                    return false;
                }
                ++n;
            }
            this.fillByteBuf(bufferedInputStream, byArray, 0, byArray.length);
            int n2 = ByteArrayConversion.bytesLEasUINT(byArray, 0, 4);
            if (n2 != 13) {
                if (this.verbose) {
                    System.out.println("Wrong IHDR data size!");
                }
                return false;
            }
            n = 0;
            while (n < 4) {
                if (byArray[n + 4] != this.IHDR_CHUNK_TYPE[n]) {
                    if (this.verbose) {
                        System.out.println("File does not begin with an IHDR chunk!");
                    }
                    return false;
                }
                ++n;
            }
            this.width = ByteArrayConversion.bytesLEasUINT(byArray, 8, 12);
            this.height = ByteArrayConversion.bytesLEasUINT(byArray, 12, 16);
            this.bitDepth = ByteArrayConversion.bytesLEasUINT(byArray, 16, 17);
            this.colorType = ByteArrayConversion.bytesLEasUINT(byArray, 17, 18);
            this.compressionMethod = ByteArrayConversion.bytesLEasUINT(byArray, 18, 19);
            this.filterMethod = ByteArrayConversion.bytesLEasUINT(byArray, 19, 20);
            this.interlaceMethod = ByteArrayConversion.bytesLEasUINT(byArray, 20, 21);
            if (this.verbose) {
                System.out.println("IHDR, width: " + this.width + ", height: " + this.height + ", bitDepth: " + this.bitDepth + ", colorType: " + this.colorType + ", compressionMethod: " + this.compressionMethod + ", filterMethod: " + this.filterMethod + ", interlaceMethod: " + this.interlaceMethod);
            }
            this.destImageBPP = 3;
            if ((this.colorType & 2) > 0) {
                this.bytesPerPixel = 3 * (this.bitDepth / 8);
            } else {
                this.isGrayScale = true;
                this.bytesPerPixel = Math.max(1, this.bitDepth / 8);
            }
            if ((this.colorType & 1) > 0) {
                this.bytesPerPixel = 1;
                this.destImageBPP = 1;
                this.needsPalette = true;
                this.isGrayScale = false;
            }
            if ((this.colorType & 4) > 0) {
                this.bytesPerPixel += this.bitDepth / 8;
                this.useAlpha = true;
            }
            this.maxColorValue = (int)Math.pow(2.0, this.bitDepth) - 1;
            if (this.useAlpha) {
                ++this.destImageBPP;
            }
            this.pixmapSize = this.width * this.height * this.destImageBPP;
        }
        catch (IOException iOException) {
            this.closeInputStreams();
            return false;
        }
        this.hdrIsRead = true;
        return true;
    }

    private boolean readChunks(BufferedInputStream bufferedInputStream) {
        int n;
        byte[] byArray = new byte[8];
        byte[] byArray2 = new byte[4];
        byte[] byArray3 = new byte[512];
        byte[] byArray4 = new byte[512];
        boolean bl = false;
        boolean bl2 = true;
        Inflater inflater = new Inflater();
        if (bufferedInputStream == null) {
            return false;
        }
        this.rawPixmap = new byte[this.pixmapSize];
        this.pixmapY = 0;
        this.pixmapX = 0;
        int n2 = 0;
        int n3 = 0;
        byte by = 0;
        try {
            while (!bl) {
                this.fillByteBuf(bufferedInputStream, byArray, 0, byArray.length);
                int n4 = ByteArrayConversion.bytesLEasUINT(byArray, 0, 4);
                if (this.verbose) {
                    System.out.println("Chunk data length: " + n4);
                }
                switch (byArray[4]) {
                    case 73: {
                        if (byArray[5] == this.IDAT_CHUNK_TYPE[1] && byArray[6] == this.IDAT_CHUNK_TYPE[2] && byArray[7] == this.IDAT_CHUNK_TYPE[3]) {
                            if (this.verbose) {
                                System.out.println("IDAT chunk.");
                            }
                            int n5 = 0;
                            while (n5 < n4) {
                                this.fillByteBuf(bufferedInputStream, byArray3, 0, Math.min(byArray3.length, n4 - n5));
                                inflater.setInput(byArray3, 0, Math.min(byArray3.length, n4 - n5));
                                while (!inflater.needsInput()) {
                                    try {
                                        int n6 = inflater.inflate(byArray4);
                                        n = 0;
                                        while (n < n6) {
                                            if (bl2) {
                                                by = byArray4[n];
                                                bl2 = false;
                                            } else if (n2 == this.width * this.bytesPerPixel) {
                                                this.pixmapX = 0;
                                                ++this.pixmapY;
                                                by = byArray4[n];
                                                n2 = 0;
                                            } else {
                                                switch (n2 % this.bytesPerPixel) {
                                                    case 0: {
                                                        int n7 = this.getFltrValue(by, byArray4[n] & 0xFF, this.rawPixmap, n3);
                                                        if (!this.useIndexColorModel) {
                                                            this.rawPixmap[n3++] = (byte)(n7 & 0xFF);
                                                            if (!this.isGrayScale) break;
                                                            this.rawPixmap[n3++] = (byte)(n7 & 0xFF);
                                                            this.rawPixmap[n3++] = (byte)(n7 & 0xFF);
                                                            break;
                                                        }
                                                        int n8 = 0;
                                                        while (n8 < 8 / this.bitDepth) {
                                                            switch (this.bitDepth) {
                                                                case 1: {
                                                                    this.rawPixmap[n3++] = (byte)(n7 & 1);
                                                                    n7 >>= 1;
                                                                    break;
                                                                }
                                                                case 2: {
                                                                    this.rawPixmap[n3++] = (byte)(n7 & 3);
                                                                    n7 >>= 2;
                                                                    break;
                                                                }
                                                                case 4: {
                                                                    this.rawPixmap[n3++] = (byte)(n7 & 0xF);
                                                                    n7 >>= 4;
                                                                    break;
                                                                }
                                                                default: {
                                                                    this.rawPixmap[n3++] = (byte)(n7 & 0xFF);
                                                                }
                                                            }
                                                            ++n8;
                                                        }
                                                        break;
                                                    }
                                                    case 1: {
                                                        int n9 = this.getFltrValue(by, byArray4[n] & 0xFF, this.rawPixmap, n3);
                                                        this.rawPixmap[n3++] = (byte)(n9 & 0xFF);
                                                        break;
                                                    }
                                                    case 2: {
                                                        int n10 = this.getFltrValue(by, byArray4[n] & 0xFF, this.rawPixmap, n3);
                                                        this.rawPixmap[n3++] = (byte)(n10 & 0xFF);
                                                        break;
                                                    }
                                                    case 3: {
                                                        int n11 = this.getFltrValue(by, byArray4[n] & 0xFF, this.rawPixmap, n3);
                                                        this.rawPixmap[n3++] = (byte)(n11 & 0xFF);
                                                        break;
                                                    }
                                                }
                                                if (n2 % this.bytesPerPixel == this.bytesPerPixel - 1) {
                                                    ++this.pixmapX;
                                                }
                                                ++n2;
                                            }
                                            ++n;
                                        }
                                    }
                                    catch (DataFormatException dataFormatException) {
                                        if (this.verbose) {
                                            System.out.println("DataFormatException: " + dataFormatException);
                                        }
                                        return false;
                                    }
                                }
                                n5 += 512;
                            }
                            break;
                        }
                        if (byArray[5] != this.IEND_CHUNK_TYPE[1] || byArray[6] != this.IEND_CHUNK_TYPE[2] || byArray[7] != this.IEND_CHUNK_TYPE[3]) break;
                        if (this.verbose) {
                            System.out.println("IEND chunk.");
                        }
                        bl = true;
                        break;
                    }
                    case 80: {
                        if (byArray[5] != this.PLTE_CHUNK_TYPE[1] || byArray[6] != this.PLTE_CHUNK_TYPE[2] || byArray[7] != this.PLTE_CHUNK_TYPE[3]) break;
                        this.useIndexColorModel = true;
                        if (this.verbose) {
                            System.out.println("PLTE chunk.");
                        }
                        int n12 = n4 / 3;
                        byte[] byArray5 = new byte[n4];
                        this.fillByteBuf(bufferedInputStream, byArray5, 0, byArray5.length);
                        this.indexCModel = new IndexColorModel(this.bitDepth, n12, byArray5, 0, false);
                        break;
                    }
                    case 116: {
                        if (byArray[5] != this.tRNS_CHUNK_TYPE[1] || byArray[6] != this.tRNS_CHUNK_TYPE[2] || byArray[7] != this.tRNS_CHUNK_TYPE[3]) break;
                        if (this.verbose) {
                            System.out.println("tRNS chunk.");
                        }
                        if (!this.useIndexColorModel || this.indexCModel == null) break;
                        int n12 = this.indexCModel.getMapSize();
                        byte[] byArray5 = new byte[n12];
                        n = 0;
                        while (n < byArray5.length) {
                            byArray5[n] = -1;
                            ++n;
                        }
                        this.fillByteBuf(bufferedInputStream, byArray5, 0, Math.min(n4, byArray5.length));
                        byte[] byArray6 = new byte[n12];
                        byte[] byArray7 = new byte[n12];
                        byte[] byArray8 = new byte[n12];
                        this.indexCModel.getReds(byArray6);
                        this.indexCModel.getGreens(byArray7);
                        this.indexCModel.getBlues(byArray8);
                        this.indexCModel = new IndexColorModel(8, n12, byArray6, byArray7, byArray8, byArray5);
                        break;
                    }
                    default: {
                        this.fillByteBuf(bufferedInputStream, new byte[n4], 0, n4);
                        if (!this.verbose) break;
                        System.out.println("Unknown chunk: " + new String(byArray, 4, 4));
                    }
                }
                this.fillByteBuf(bufferedInputStream, byArray2, 0, byArray2.length);
            }
        }
        catch (IOException iOException) {
            if (this.verbose) {
                System.out.println("IOException: " + iOException);
            }
            this.closeInputStreams();
            return false;
        }
        if (!this.useIndexColorModel) {
            int[] nArray = new int[this.width * this.height];
            n = 0;
            int n13 = 0;
            while (n < this.width * this.height) {
                nArray[n] = this.useAlpha ? (this.rawPixmap[n13] & 0xFF) << 16 | (this.rawPixmap[n13 + 1] & 0xFF) << 8 | this.rawPixmap[n13 + 2] & 0xFF | (this.rawPixmap[n13 + 3] & 0xFF) << 24 : 0xFF000000 | (this.rawPixmap[n13] & 0xFF) << 16 | (this.rawPixmap[n13 + 1] & 0xFF) << 8 | this.rawPixmap[n13 + 2] & 0xFF;
                ++n;
                n13 += this.destImageBPP;
            }
            this.pngImage = Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(this.width, this.height, nArray, 0, this.width));
        } else {
            this.pngImage = Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(this.width, this.height, (ColorModel)this.indexCModel, this.rawPixmap, 0, this.width));
        }
        return true;
    }

    private int getFltrValue(int n, int n2, byte[] byArray, int n3) {
        int n4 = n3 - this.destImageBPP;
        int n5 = this.pixmapX <= 0 ? 0 : byArray[n4] & 0xFF;
        n4 = n3 - this.destImageBPP * this.width;
        int n6 = this.pixmapY <= 0 ? 0 : byArray[n4] & 0xFF;
        int n7 = this.pixmapX <= 0 || this.pixmapY <= 0 ? 0 : byArray[n4 -= this.destImageBPP] & 0xFF;
        switch (n) {
            case 0: {
                return n2;
            }
            case 1: {
                return (n2 & 0xFF) + n5 & 0xFF;
            }
            case 2: {
                return (n2 & 0xFF) + n6 & 0xFF;
            }
            case 3: {
                return (n2 & 0xFF) + (n5 + n6) / 2 & 0xFF & 0xFF;
            }
            case 4: {
                return (n2 & 0xFF) + this.paethPredictor(n5, n6, n7) & 0xFF & 0xFF;
            }
        }
        return n2;
    }

    private int paethPredictor(int n, int n2, int n3) {
        int n4 = n + n2 - n3;
        int n5 = Math.abs(n4 - n);
        int n6 = Math.abs(n4 - n2);
        int n7 = Math.abs(n4 - n3);
        if (n5 <= n6 && n5 <= n7) {
            return n;
        }
        if (n6 <= n7) {
            return n2;
        }
        return n3;
    }

    private void fillByteBuf(InputStream inputStream, byte[] byArray, int n, int n2) throws IOException {
        while (n2 > 0) {
            int n3 = inputStream.read(byArray, n, n2);
            if (n3 == -1) {
                throw new IOException("Unexpected EOF");
            }
            n += n3;
            n2 -= n3;
        }
    }
}

