/*
 * Decompiled with CFR 0.152.
 */
package fi.faidon.jis;

import fi.faidon.jis.ImageSaverInterface;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.ColorModel;
import java.awt.image.ImageConsumer;
import java.awt.image.ImageProducer;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.Hashtable;

public class TargaImageSaver
extends ImageSaverInterface
implements Serializable,
ImageConsumer {
    public static String FORMAT_CODE = "Targa";
    public static String FORMAT_COMPLETE_NAME = "TrueVision Targa";
    public static String FORMAT_EXTENSION = "tga";
    private static int HEADER_SIZE = 18;
    private static int IMAGE_ID_OFFSET = 18;
    private static int PIXEL_DATA_SIZE = 24;
    private static int NBR_BITS_IN_BYTE = 8;
    private FileOutputStream writeFileHandle;
    private int saveStatus;

    public static void main(String[] stringArray) {
        if (stringArray.length < 2) {
            System.out.println("Usage: TargaImageSaver <source image file> <dest image file>");
            System.exit(1);
        }
        File file = new File(".");
        file = new File(file.getAbsolutePath());
        String string = file.getParent();
        String string2 = String.valueOf(string) + File.separator + stringArray[0];
        Image image = Toolkit.getDefaultToolkit().getImage(string2);
        TargaImageSaver targaImageSaver = new TargaImageSaver();
        targaImageSaver.setSaveImage(image);
        targaImageSaver.setSavePath(stringArray[1]);
        targaImageSaver.saveIt();
        while ((targaImageSaver.checkSave() & 0xE0) == 0) {
            System.out.println("Waiting for save to finish!");
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                System.exit(1);
            }
        }
        System.exit(0);
    }

    public String getFormatCode() {
        return FORMAT_CODE;
    }

    public String getFormatString() {
        return FORMAT_COMPLETE_NAME;
    }

    public String getFormatExtension() {
        return FORMAT_EXTENSION;
    }

    public boolean saveIt() {
        if (this.saveImage == null) {
            return false;
        }
        try {
            this.writeFileHandle = new FileOutputStream(this.savePath);
        }
        catch (IOException iOException) {
            this.saveStatus = 64;
        }
        if (this.writeFileHandle == null) {
            return false;
        }
        ImageProducer imageProducer = this.saveImage.getSource();
        if (imageProducer == null) {
            return false;
        }
        imageProducer.startProduction(this);
        return true;
    }

    public int checkSave() {
        return this.saveStatus;
    }

    public void setProperties(Hashtable hashtable) {
        this.saveStatus |= 4;
    }

    public void setHints(int n) {
    }

    public void setColorModel(ColorModel colorModel) {
    }

    public void setDimensions(int n, int n2) {
        byte[] byArray = new byte[HEADER_SIZE];
        byArray[0] = 0;
        byArray[1] = 0;
        byArray[2] = 2;
        byArray[3] = 0;
        byArray[4] = 0;
        byArray[5] = 0;
        byArray[6] = 0;
        byArray[7] = 0;
        byArray[8] = 0;
        byArray[9] = 0;
        byArray[10] = 0;
        byArray[11] = 0;
        byArray[12] = (byte)(n & 0xFF);
        byArray[13] = (byte)(n >> 8 & 0xFF);
        byArray[14] = (byte)(n2 & 0xFF);
        byArray[15] = (byte)(n2 >> 8 & 0xFF);
        byArray[16] = (byte)PIXEL_DATA_SIZE;
        byArray[17] = 32;
        if (this.writeFileHandle != null) {
            try {
                this.writeFileHandle.write(byArray);
            }
            catch (IOException iOException) {
                this.saveStatus = 64;
            }
        }
        this.saveStatus |= 3;
    }

    public void setPixels(int n, int n2, int n3, int n4, ColorModel colorModel, byte[] byArray, int n5, int n6) {
        int n7 = PIXEL_DATA_SIZE / NBR_BITS_IN_BYTE;
        byte[] byArray2 = new byte[n3 * n4 * n7];
        int n8 = 0;
        while (n8 < n4) {
            int n9 = 0;
            while (n9 < n3) {
                int n10 = colorModel.getRGB(byArray[n5 + n8 * n6 + n9] & 0xFF);
                int n11 = 0;
                while (n11 < n7) {
                    byArray2[(n8 * n3 + n9) * n7 + n11] = (byte)(n10 >> n11 * NBR_BITS_IN_BYTE & 0xFF);
                    ++n11;
                }
                ++n9;
            }
            ++n8;
        }
        if (this.writeFileHandle != null) {
            try {
                this.writeFileHandle.write(byArray2);
            }
            catch (IOException iOException) {
                this.saveStatus = 64;
            }
        }
        this.saveStatus |= 8;
    }

    public void setPixels(int n, int n2, int n3, int n4, ColorModel colorModel, int[] nArray, int n5, int n6) {
        int n7 = PIXEL_DATA_SIZE / NBR_BITS_IN_BYTE;
        byte[] byArray = new byte[n3 * n4 * n7];
        int n8 = 0;
        while (n8 < n4) {
            int n9 = 0;
            while (n9 < n3) {
                int n10 = colorModel.getRGB(nArray[n5 + n8 * n6 + n9]);
                int n11 = 0;
                while (n11 < n7) {
                    byArray[(n8 * n3 + n9) * n7 + n11] = (byte)(n10 >> n11 * NBR_BITS_IN_BYTE & 0xFF);
                    ++n11;
                }
                ++n9;
            }
            ++n8;
        }
        if (this.writeFileHandle != null) {
            try {
                this.writeFileHandle.write(byArray);
            }
            catch (IOException iOException) {
                this.saveStatus = 64;
            }
        }
        this.saveStatus |= 8;
    }

    public void imageComplete(int n) {
        if (this.writeFileHandle != null) {
            try {
                this.writeFileHandle.close();
            }
            catch (IOException iOException) {
                this.saveStatus = 64;
            }
        }
        this.saveStatus |= 0x20;
    }
}

