/*
 * Decompiled with CFR 0.152.
 */
package fi.faidon.jis;

import fi.faidon.jis.ImageSaverInterface;
import fi.faidon.protection.SerialNumberManager;
import fi.faidon.util.ByteArrayConversion;
import java.awt.image.ColorModel;
import java.awt.image.ImageConsumer;
import java.awt.image.ImageProducer;
import java.awt.image.IndexColorModel;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.zip.CRC32;
import java.util.zip.Deflater;

public class PNGImageSaver
extends ImageSaverInterface
implements Serializable,
ImageConsumer {
    public static final String FORMAT_CODE = "PNG";
    public static final String FORMAT_COMPLETE_NAME = "Portable Network Graphics (PNG)";
    public static final String FORMAT_EXTENSION = "png";
    private final boolean OBLIGATORY_REGISTRATION = true;
    private final int DEFLATE_INPUT_SIZE = 512;
    private final byte[] PNG_IDENTIFICATION_BYTES = new byte[]{-119, 80, 78, 71, 13, 10, 26, 10};
    private final int IHDR_DATA_SIZE = 13;
    private final int CHUNK_TYPE_SIZE = 4;
    private final byte[] IHDR_CHUNK_TYPE = new byte[]{73, 72, 68, 82};
    private final byte[] IDAT_CHUNK_TYPE = new byte[]{73, 68, 65, 84};
    private final byte[] IEND_CHUNK_TYPE = new byte[]{73, 69, 78, 68};
    private final byte COLOR_TYPE_COLOR = (byte)2;
    private final byte COLOR_TYPE_USE_ALPHA_CHANNEL = (byte)4;
    private final byte DEFLATE_INFLATE_COMPRESSION = 0;
    private final byte NO_INTERLACE = 0;
    private final byte NO_FILTER = 0;
    private final byte SUB_FILTER = 1;
    private FileOutputStream writeFileHandle;
    private int width;
    private int height;
    private int saveStatus;
    private int byteCount;
    private int bytesPerPixel;
    private CRC32 crcCounter;
    private Deflater pixmapDeflater;
    private long idatChunkSizeOffset;
    private long idatDataSize;
    private boolean headerIsWritten;
    private boolean imageCompleteDone;
    private boolean includeAlphaChannel;

    public PNGImageSaver() {
        SerialNumberManager serialNumberManager = new SerialNumberManager();
        if (!serialNumberManager.verifyCurrentPackage()) {
            System.err.println("Unregistered version or evaluation period expired!");
            System.err.println("Exiting...");
            System.exit(1);
        }
        this.crcCounter = new CRC32();
        this.headerIsWritten = false;
        this.imageCompleteDone = false;
        this.bytesPerPixel = 3;
        this.includeAlphaChannel = false;
    }

    public String getFormatCode() {
        return FORMAT_CODE;
    }

    public String getFormatString() {
        return FORMAT_COMPLETE_NAME;
    }

    public String getFormatExtension() {
        return FORMAT_EXTENSION;
    }

    public boolean saveIt() {
        if (this.saveImage == null) {
            return false;
        }
        this.saveStatus = 0;
        try {
            this.writeFileHandle = new FileOutputStream(this.savePath);
        }
        catch (IOException iOException) {
            System.out.println("IOException occurred opening FileOutputStream : " + iOException);
        }
        if (this.writeFileHandle == null) {
            return false;
        }
        ImageProducer imageProducer = this.saveImage.getSource();
        if (imageProducer == null) {
            return false;
        }
        imageProducer.startProduction(this);
        return true;
    }

    public int checkSave() {
        return this.saveStatus;
    }

    public boolean getUseAlphaChannel() {
        return this.includeAlphaChannel;
    }

    public void setUseAlphaChannel(boolean bl) {
        this.includeAlphaChannel = bl;
        if (this.includeAlphaChannel) {
            this.bytesPerPixel = 4;
            return;
        }
        this.bytesPerPixel = 3;
    }

    public void setProperties(Hashtable hashtable) {
        this.saveStatus |= 4;
    }

    public void setHints(int n) {
    }

    public void setColorModel(ColorModel colorModel) {
        if (!this.headerIsWritten && colorModel instanceof IndexColorModel && ((IndexColorModel)colorModel).getTransparentPixel() != -1) {
            this.includeAlphaChannel = true;
            this.bytesPerPixel = 4;
        }
    }

    public void setDimensions(int n, int n2) {
        this.width = n;
        this.height = n2;
        this.saveStatus |= 3;
    }

    public void setPixels(int n, int n2, int n3, int n4, ColorModel colorModel, byte[] byArray, int n5, int n6) {
        int n7 = -1;
        if (!this.headerIsWritten && colorModel instanceof IndexColorModel && ((IndexColorModel)colorModel).getTransparentPixel() != -1) {
            this.includeAlphaChannel = true;
            this.bytesPerPixel = 4;
        }
        if (this.includeAlphaChannel && colorModel instanceof IndexColorModel) {
            n7 = ((IndexColorModel)colorModel).getTransparentPixel();
        }
        int[] nArray = new int[byArray.length];
        int n8 = n5;
        while (n8 < byArray.length) {
            nArray[n8] = colorModel.getRGB(byArray[n8] & 0xFF);
            if (this.includeAlphaChannel && (byArray[n8] & 0xFF) == n7) {
                int n9 = n8;
                nArray[n9] = nArray[n9] & 0xFFFFFF;
            }
            ++n8;
        }
        this.setPixels(n, n2, n3, n4, ColorModel.getRGBdefault(), nArray, n5, n6);
    }

    public void setPixels(int n, int n2, int n3, int n4, ColorModel colorModel, int[] nArray, int n5, int n6) {
        byte[] byArray = new byte[512];
        if (!this.headerIsWritten) {
            this.writeHeader();
        }
        byte[] byArray2 = new byte[n3 * n4 * this.bytesPerPixel + n4];
        int n7 = 0;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        int n8 = 0;
        while (n8 < n4) {
            if (n == 0) {
                byArray2[n7++] = 0;
            }
            int n9 = 0;
            while (n9 < n3) {
                int n10 = colorModel.getRGB(nArray[n5 + n8 * n6 + n9]);
                int n11 = n10 >> 16 & 0xFF;
                int n12 = n10 >> 8 & 0xFF;
                int n13 = n10 & 0xFF;
                byArray2[n7++] = (byte)(n11 & 0xFF);
                byArray2[n7++] = (byte)(n12 & 0xFF);
                byArray2[n7++] = (byte)(n13 & 0xFF);
                if (this.includeAlphaChannel) {
                    int n14 = colorModel.getAlpha(nArray[n5 + n8 * n6 + n9]);
                    byArray2[n7++] = (byte)(n14 & 0xFF);
                }
                ++n9;
            }
            ++n8;
        }
        int n15 = 0;
        while (n15 < byArray2.length) {
            this.pixmapDeflater.setInput(byArray2, n15, Math.min(512, byArray2.length - n15));
            while (!this.pixmapDeflater.needsInput()) {
                int n16 = this.pixmapDeflater.deflate(byArray);
                try {
                    this.writeFileHandle.write(byArray, 0, n16);
                }
                catch (IOException iOException) {
                    this.saveStatus = 64;
                }
                this.byteCount += n16;
                this.idatDataSize += (long)n16;
                this.crcCounter.update(byArray, 0, n16);
            }
            n15 += 512;
        }
        this.saveStatus |= 8;
    }

    public void imageComplete(int n) {
        byte[] byArray = new byte[4];
        byte[] byArray2 = new byte[512];
        if (!this.imageCompleteDone) {
            this.pixmapDeflater.finish();
            while (!this.pixmapDeflater.finished()) {
                int n2 = this.pixmapDeflater.deflate(byArray2);
                try {
                    this.writeFileHandle.write(byArray2, 0, n2);
                }
                catch (IOException iOException) {
                    this.saveStatus = 64;
                }
                this.byteCount += n2;
                this.idatDataSize += (long)n2;
                this.crcCounter.update(byArray2, 0, n2);
            }
            ByteArrayConversion.ulongAsBytesBE(this.crcCounter.getValue(), byArray, 0, byArray.length);
            try {
                this.writeFileHandle.write(byArray);
            }
            catch (IOException iOException) {
                this.saveStatus = 64;
            }
            this.byteCount += byArray.length;
            ByteArrayConversion.uintAsBytesBE(0, byArray, 0, byArray.length);
            try {
                this.writeFileHandle.write(byArray);
            }
            catch (IOException iOException) {
                this.saveStatus = 64;
            }
            this.byteCount += byArray.length;
            try {
                this.writeFileHandle.write(this.IEND_CHUNK_TYPE);
            }
            catch (IOException iOException) {
                this.saveStatus = 64;
            }
            this.byteCount += this.IEND_CHUNK_TYPE.length;
            this.crcCounter.reset();
            this.crcCounter.update(this.IEND_CHUNK_TYPE);
            ByteArrayConversion.ulongAsBytesBE(this.crcCounter.getValue(), byArray, 0, byArray.length);
            try {
                this.writeFileHandle.write(byArray);
            }
            catch (IOException iOException) {
                this.saveStatus = 64;
            }
            this.byteCount += byArray.length;
            if (this.writeFileHandle != null) {
                try {
                    this.writeFileHandle.close();
                }
                catch (IOException iOException) {
                    this.saveStatus = 64;
                }
            }
            try {
                RandomAccessFile randomAccessFile = new RandomAccessFile(this.savePath, "rw");
                randomAccessFile.seek(this.idatChunkSizeOffset);
                ByteArrayConversion.ulongAsBytesBE(this.idatDataSize, byArray, 0, byArray.length);
                randomAccessFile.write(byArray);
                randomAccessFile.close();
            }
            catch (IOException iOException) {
                System.out.println("IOException occurred opening RandomAccessFile : " + iOException);
            }
            this.imageCompleteDone = true;
        }
        this.saveStatus |= 0x20;
    }

    private synchronized void writeHeader() {
        byte[] byArray = new byte[4];
        this.byteCount = 0;
        try {
            this.writeFileHandle.write(this.PNG_IDENTIFICATION_BYTES);
        }
        catch (IOException iOException) {
            this.saveStatus = 64;
        }
        this.byteCount += this.PNG_IDENTIFICATION_BYTES.length;
        ByteArrayConversion.uintAsBytesBE(13, byArray, 0, 4);
        try {
            this.writeFileHandle.write(byArray);
        }
        catch (IOException iOException) {
            this.saveStatus = 64;
        }
        this.byteCount += byArray.length;
        try {
            this.writeFileHandle.write(this.IHDR_CHUNK_TYPE);
        }
        catch (IOException iOException) {
            this.saveStatus = 64;
        }
        this.byteCount += this.IHDR_CHUNK_TYPE.length;
        byte[] byArray2 = new byte[13];
        int n = 0;
        ByteArrayConversion.uintAsBytesBE(this.width, byArray2, n, n + 4);
        ByteArrayConversion.uintAsBytesBE(this.height, byArray2, n += 4, n + 4);
        n += 4;
        byArray2[n++] = 8;
        byArray2[n++] = this.includeAlphaChannel ? 6 : 2;
        byArray2[n++] = 0;
        byArray2[n++] = 0;
        byArray2[n++] = 0;
        try {
            this.writeFileHandle.write(byArray2);
        }
        catch (IOException iOException) {
            this.saveStatus = 64;
        }
        this.byteCount += byArray2.length;
        this.crcCounter.reset();
        this.crcCounter.update(this.IHDR_CHUNK_TYPE);
        this.crcCounter.update(byArray2);
        ByteArrayConversion.ulongAsBytesBE(this.crcCounter.getValue(), byArray, 0, byArray.length);
        try {
            this.writeFileHandle.write(byArray);
        }
        catch (IOException iOException) {
            this.saveStatus = 64;
        }
        this.byteCount += byArray.length;
        this.headerIsWritten = true;
        this.pixmapDeflater = new Deflater();
        this.idatChunkSizeOffset = this.byteCount;
        ByteArrayConversion.uintAsBytesBE(0, byArray, 0, byArray.length);
        try {
            this.writeFileHandle.write(byArray);
        }
        catch (IOException iOException) {
            this.saveStatus = 64;
        }
        this.byteCount += byArray.length;
        this.idatDataSize = 0L;
        try {
            this.writeFileHandle.write(this.IDAT_CHUNK_TYPE);
        }
        catch (IOException iOException) {
            this.saveStatus = 64;
        }
        this.byteCount += this.IDAT_CHUNK_TYPE.length;
        this.crcCounter.reset();
        this.crcCounter.update(this.IDAT_CHUNK_TYPE);
    }
}

