/*
 * Decompiled with CFR 0.152.
 */
package fi.faidon.jis;

import fi.faidon.jis.ImageSaverInterface;
import fi.faidon.util.ByteArrayConversion;
import java.awt.Toolkit;
import java.awt.image.ColorModel;
import java.awt.image.ImageConsumer;
import java.awt.image.ImageProducer;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.Hashtable;

public class JPEGImageSaver
extends ImageSaverInterface
implements Serializable,
ImageConsumer {
    public static final String FORMAT_CODE = "JPEG";
    public static final String FORMAT_COMPLETE_NAME = "JPEG/JFIF";
    public static final String FORMAT_EXTENSION = "jpg";
    private final int DCTSIZE = 8;
    private final int DCTSIZE2 = 64;
    private final int NUM_QUANT_TBLS = 4;
    private final int NUM_HUFF_TBLS = 4;
    private final int NUM_ARITH_TBLS = 16;
    private final int MAX_COMPS_IN_SCAN = 4;
    private final int MAX_SAMP_FACTOR = 4;
    private final int C_MAX_BLOCKS_IN_MCU = 10;
    private final int JCS_UNKNOWN = 0;
    private final int JCS_GRAYSCALE = 1;
    private final int JCS_RGB = 2;
    private final int JCS_YCbCr = 3;
    private final int JCS_CMYK = 4;
    private final int JCS_YCCK = 5;
    private final int JDCT_ISLOW = 0;
    private final int JDCT_IFAST = 1;
    private final int JDCT_FLOAT = 2;
    private final int JDCT_DEFAULT = 0;
    private final int JDITHER_NONE = 0;
    private final int JDITHER_ORDERED = 1;
    private final int JDITHER_FS = 2;
    private final byte[] JFIF_ID_STRING;
    private final byte[] JFIF_VERSION;
    private final int JFIF_APP0_MARKER_LENGTH = 16;
    private final byte MARKER_START = -1;
    private final byte M_SOF0 = -64;
    private final byte M_SOF1 = -63;
    private final byte M_SOF2 = -62;
    private final byte M_SOF3 = -61;
    private final byte M_SOF5 = -59;
    private final byte M_SOF6 = -58;
    private final byte M_SOF7 = -57;
    private final byte M_SOF9 = -55;
    private final byte M_SOF10 = -54;
    private final byte M_SOF11 = -53;
    private final byte M_SOF13 = -51;
    private final byte M_SOF14 = -50;
    private final byte M_SOF15 = -49;
    private final byte M_DHT = -60;
    private final byte M_DAC = -52;
    private final byte M_RST0 = -48;
    private final byte M_RST1 = -47;
    private final byte M_RST2 = -46;
    private final byte M_RST3 = -45;
    private final byte M_RST4 = -44;
    private final byte M_RST5 = -43;
    private final byte M_RST6 = -42;
    private final byte M_RST7 = -41;
    private final byte M_SOI = -40;
    private final byte M_EOI = -39;
    private final byte M_SOS = -38;
    private final byte M_DQT = -37;
    private final byte M_DNL = -36;
    private final byte M_DRI = -35;
    private final byte M_DHP = -34;
    private final byte M_EXP = -33;
    private final byte M_APP0 = -32;
    private final byte M_APP1 = -31;
    private final byte M_APP2 = -30;
    private final byte M_APP3 = -29;
    private final byte M_APP4 = -28;
    private final byte M_APP5 = -27;
    private final byte M_APP6 = -26;
    private final byte M_APP7 = -25;
    private final byte M_APP8 = -24;
    private final byte M_APP9 = -23;
    private final byte M_APP10 = -22;
    private final byte M_APP11 = -21;
    private final byte M_APP12 = -20;
    private final byte M_APP13 = -19;
    private final byte M_APP14 = -18;
    private final byte M_APP15 = -17;
    private final byte M_JPG0 = -16;
    private final byte M_JPG13 = -3;
    private final byte M_COM = -2;
    private final byte M_TEM = 1;
    private final int M_ERROR = 256;
    private FileOutputStream writeFileHandle;
    private int width;
    private int height;
    private int saveStatus;
    private int byteCount;
    private int dataPrecision;
    private int numComponents;
    private int bytesPerPixel;
    private boolean headerIsWritten;
    private boolean imageCompleteDone;

    public JPEGImageSaver() {
        byte[] byArray = new byte[5];
        byArray[0] = 74;
        byArray[1] = 70;
        byArray[2] = 73;
        byArray[3] = 70;
        this.JFIF_ID_STRING = byArray;
        this.JFIF_VERSION = new byte[]{1, 1};
        this.JFIF_APP0_MARKER_LENGTH = 16;
        this.MARKER_START = (byte)-1;
        this.M_SOF0 = (byte)-64;
        this.M_SOF1 = (byte)-63;
        this.M_SOF2 = (byte)-62;
        this.M_SOF3 = (byte)-61;
        this.M_SOF5 = (byte)-59;
        this.M_SOF6 = (byte)-58;
        this.M_SOF7 = (byte)-57;
        this.M_SOF9 = (byte)-55;
        this.M_SOF10 = (byte)-54;
        this.M_SOF11 = (byte)-53;
        this.M_SOF13 = (byte)-51;
        this.M_SOF14 = (byte)-50;
        this.M_SOF15 = (byte)-49;
        this.M_DHT = (byte)-60;
        this.M_DAC = (byte)-52;
        this.M_RST0 = (byte)-48;
        this.M_RST1 = (byte)-47;
        this.M_RST2 = (byte)-46;
        this.M_RST3 = (byte)-45;
        this.M_RST4 = (byte)-44;
        this.M_RST5 = (byte)-43;
        this.M_RST6 = (byte)-42;
        this.M_RST7 = (byte)-41;
        this.M_SOI = (byte)-40;
        this.M_EOI = (byte)-39;
        this.M_SOS = (byte)-38;
        this.M_DQT = (byte)-37;
        this.M_DNL = (byte)-36;
        this.M_DRI = (byte)-35;
        this.M_DHP = (byte)-34;
        this.M_EXP = (byte)-33;
        this.M_APP0 = (byte)-32;
        this.M_APP1 = (byte)-31;
        this.M_APP2 = (byte)-30;
        this.M_APP3 = (byte)-29;
        this.M_APP4 = (byte)-28;
        this.M_APP5 = (byte)-27;
        this.M_APP6 = (byte)-26;
        this.M_APP7 = (byte)-25;
        this.M_APP8 = (byte)-24;
        this.M_APP9 = (byte)-23;
        this.M_APP10 = (byte)-22;
        this.M_APP11 = (byte)-21;
        this.M_APP12 = (byte)-20;
        this.M_APP13 = (byte)-19;
        this.M_APP14 = (byte)-18;
        this.M_APP15 = (byte)-17;
        this.M_JPG0 = (byte)-16;
        this.M_JPG13 = (byte)-3;
        this.M_COM = (byte)-2;
        this.M_TEM = 1;
        this.M_ERROR = 256;
        this.headerIsWritten = false;
        this.imageCompleteDone = false;
        this.bytesPerPixel = 3;
        this.dataPrecision = 8;
        this.numComponents = 3;
    }

    public String getFormatCode() {
        return FORMAT_CODE;
    }

    public String getFormatString() {
        return FORMAT_COMPLETE_NAME;
    }

    public String getFormatExtension() {
        return FORMAT_EXTENSION;
    }

    public boolean saveIt() {
        if (this.saveImage == null) {
            return false;
        }
        this.saveStatus = 0;
        try {
            this.writeFileHandle = new FileOutputStream(this.savePath);
        }
        catch (IOException iOException) {
            System.out.println("IOException occurred opening FileOutputStream : " + iOException);
        }
        if (this.writeFileHandle == null) {
            return false;
        }
        ImageProducer imageProducer = this.saveImage.getSource();
        if (imageProducer == null) {
            return false;
        }
        imageProducer.startProduction(this);
        return true;
    }

    public int checkSave() {
        return this.saveStatus;
    }

    public void setProperties(Hashtable hashtable) {
        this.saveStatus |= 4;
    }

    public void setHints(int n) {
    }

    public void setColorModel(ColorModel colorModel) {
    }

    public void setDimensions(int n, int n2) {
        this.width = n;
        this.height = n2;
        this.saveStatus |= 3;
    }

    public void setPixels(int n, int n2, int n3, int n4, ColorModel colorModel, byte[] byArray, int n5, int n6) {
        int[] nArray = new int[byArray.length];
        int n7 = n5;
        while (n7 < byArray.length) {
            nArray[n7] = colorModel.getRGB(byArray[n7] & 0xFF);
            ++n7;
        }
        this.setPixels(n, n2, n3, n4, ColorModel.getRGBdefault(), nArray, n5, n6);
    }

    public void setPixels(int n, int n2, int n3, int n4, ColorModel colorModel, int[] nArray, int n5, int n6) {
        if (!this.headerIsWritten) {
            this.writeHeader();
        }
        this.saveStatus |= 8;
    }

    public void imageComplete(int n) {
        byte[] byArray = new byte[2];
        if (!this.imageCompleteDone) {
            byArray[0] = -1;
            byArray[1] = -39;
            try {
                this.writeFileHandle.write(byArray);
            }
            catch (IOException iOException) {
                this.saveStatus = 64;
            }
            this.byteCount += byArray.length;
            if (this.writeFileHandle != null) {
                try {
                    this.writeFileHandle.close();
                }
                catch (IOException iOException) {
                    this.saveStatus = 64;
                }
            }
            this.imageCompleteDone = true;
        }
        this.saveStatus |= 0x20;
    }

    private synchronized void writeHeader() {
        byte[] byArray = new byte[1];
        byte[] byArray2 = new byte[2];
        this.byteCount = 0;
        byArray2[0] = -1;
        byArray2[1] = -40;
        try {
            this.writeFileHandle.write(byArray2);
        }
        catch (IOException iOException) {
            this.saveStatus = 64;
        }
        this.byteCount += byArray2.length;
        byArray2[1] = -32;
        try {
            this.writeFileHandle.write(byArray2);
        }
        catch (IOException iOException) {
            this.saveStatus = 64;
        }
        this.byteCount += byArray2.length;
        ByteArrayConversion.uintAsBytesBE(16, byArray2, 0, byArray2.length);
        try {
            this.writeFileHandle.write(byArray2);
        }
        catch (IOException iOException) {
            this.saveStatus = 64;
        }
        this.byteCount += byArray2.length;
        try {
            this.writeFileHandle.write(this.JFIF_ID_STRING);
        }
        catch (IOException iOException) {
            this.saveStatus = 64;
        }
        this.byteCount += this.JFIF_ID_STRING.length;
        try {
            this.writeFileHandle.write(this.JFIF_VERSION);
        }
        catch (IOException iOException) {
            this.saveStatus = 64;
        }
        this.byteCount += this.JFIF_VERSION.length;
        ByteArrayConversion.uintAsBytesBE(1, byArray, 0, byArray.length);
        try {
            this.writeFileHandle.write(byArray);
        }
        catch (IOException iOException) {
            this.saveStatus = 64;
        }
        this.byteCount += byArray.length;
        int n = Toolkit.getDefaultToolkit().getScreenResolution();
        ByteArrayConversion.uintAsBytesBE(n, byArray2, 0, byArray2.length);
        try {
            this.writeFileHandle.write(byArray2);
        }
        catch (IOException iOException) {
            this.saveStatus = 64;
        }
        try {
            this.writeFileHandle.write(byArray2);
        }
        catch (IOException iOException) {
            this.saveStatus = 64;
        }
        this.byteCount += 2 * byArray2.length;
        ByteArrayConversion.uintAsBytesBE(0, byArray2, 0, byArray2.length);
        try {
            this.writeFileHandle.write(byArray2);
        }
        catch (IOException iOException) {
            this.saveStatus = 64;
        }
        this.byteCount += byArray2.length;
        this.writeDQT(0);
        this.writeDQT(1);
        this.writeSOF((byte)-64);
        this.writeDHT(0, false);
        this.headerIsWritten = true;
    }

    private synchronized int writeDQT(int n) {
        byte[] byArray = new byte[1];
        byte[] byArray2 = new byte[]{-1, -37};
        try {
            this.writeFileHandle.write(byArray2);
        }
        catch (IOException iOException) {
            this.saveStatus = 64;
        }
        this.byteCount += byArray2.length;
        int n2 = 0;
        int n3 = 3;
        ByteArrayConversion.uintAsBytesBE(n3 += n2 == 1 ? 128 : 64, byArray2, 0, byArray2.length);
        try {
            this.writeFileHandle.write(byArray2);
        }
        catch (IOException iOException) {
            this.saveStatus = 64;
        }
        this.byteCount += byArray2.length;
        ByteArrayConversion.uintAsBytesBE(n2, byArray, 0, byArray.length);
        try {
            this.writeFileHandle.write(byArray);
        }
        catch (IOException iOException) {
            this.saveStatus = 64;
        }
        this.byteCount += byArray.length;
        ByteArrayConversion.uintAsBytesBE(0, byArray, 0, byArray.length);
        int n4 = 0;
        while (n4 < 64) {
            try {
                this.writeFileHandle.write(byArray);
            }
            catch (IOException iOException) {
                this.saveStatus = 64;
            }
            this.byteCount += byArray.length;
            ++n4;
        }
        return n2;
    }

    private synchronized void writeDHT(int n, boolean bl) {
        byte[] byArray = new byte[1];
        byte[] byArray2 = new byte[]{-1, -60};
        try {
            this.writeFileHandle.write(byArray2);
        }
        catch (IOException iOException) {
            this.saveStatus = 64;
        }
        this.byteCount += byArray2.length;
        int n2 = 16;
        int n3 = n2 + 2 + 1 + 16;
        ByteArrayConversion.uintAsBytesBE(n3, byArray2, 0, byArray2.length);
        try {
            this.writeFileHandle.write(byArray2);
        }
        catch (IOException iOException) {
            this.saveStatus = 64;
        }
        this.byteCount += byArray2.length;
        ByteArrayConversion.uintAsBytesBE(n, byArray, 0, byArray.length);
        try {
            this.writeFileHandle.write(byArray);
        }
        catch (IOException iOException) {
            this.saveStatus = 64;
        }
        this.byteCount += byArray.length;
        byArray[0] = 0;
        int n4 = 1;
        while (n4 <= 16) {
            try {
                this.writeFileHandle.write(byArray);
            }
            catch (IOException iOException) {
                this.saveStatus = 64;
            }
            this.byteCount += byArray.length;
            ++n4;
        }
        try {
            this.writeFileHandle.write(new byte[n2]);
        }
        catch (IOException iOException) {
            this.saveStatus = 64;
        }
        this.byteCount += n2;
    }

    private synchronized void writeSOF(byte by) {
        byte[] byArray = new byte[1];
        byte[] byArray2 = new byte[]{-1, by};
        try {
            this.writeFileHandle.write(byArray2);
        }
        catch (IOException iOException) {
            this.saveStatus = 64;
        }
        this.byteCount += byArray2.length;
        int n = 3 * this.numComponents + 2 + 5 + 1;
        ByteArrayConversion.uintAsBytesBE(n, byArray2, 0, byArray2.length);
        try {
            this.writeFileHandle.write(byArray2);
        }
        catch (IOException iOException) {
            this.saveStatus = 64;
        }
        this.byteCount += byArray2.length;
        ByteArrayConversion.uintAsBytesBE(this.dataPrecision, byArray, 0, byArray.length);
        try {
            this.writeFileHandle.write(byArray);
        }
        catch (IOException iOException) {
            this.saveStatus = 64;
        }
        this.byteCount += byArray.length;
        ByteArrayConversion.uintAsBytesBE(this.height, byArray2, 0, byArray2.length);
        try {
            this.writeFileHandle.write(byArray2);
        }
        catch (IOException iOException) {
            this.saveStatus = 64;
        }
        ByteArrayConversion.uintAsBytesBE(this.width, byArray2, 0, byArray2.length);
        try {
            this.writeFileHandle.write(byArray2);
        }
        catch (IOException iOException) {
            this.saveStatus = 64;
        }
        this.byteCount += 2 * byArray2.length;
        ByteArrayConversion.uintAsBytesBE(this.numComponents, byArray, 0, byArray.length);
        try {
            this.writeFileHandle.write(byArray);
        }
        catch (IOException iOException) {
            this.saveStatus = 64;
        }
        this.byteCount += byArray.length;
        int n2 = 0;
        while (n2 < this.numComponents) {
            ByteArrayConversion.uintAsBytesBE(n2 + 1, byArray, 0, byArray.length);
            try {
                this.writeFileHandle.write(byArray);
            }
            catch (IOException iOException) {
                this.saveStatus = 64;
            }
            ByteArrayConversion.uintAsBytesBE(0, byArray, 0, byArray.length);
            try {
                this.writeFileHandle.write(byArray);
            }
            catch (IOException iOException) {
                this.saveStatus = 64;
            }
            ByteArrayConversion.uintAsBytesBE(0, byArray, 0, byArray.length);
            try {
                this.writeFileHandle.write(byArray);
            }
            catch (IOException iOException) {
                this.saveStatus = 64;
            }
            this.byteCount += 3 * byArray.length;
            ++n2;
        }
    }
}

