/*
 * Decompiled with CFR 0.152.
 */
package fi.faidon.protection;

import java.io.InputStream;
import java.net.URL;
import java.util.Calendar;
import java.util.GregorianCalendar;

public class SerialNumberManager {
    public static final String STR_REG_VERIFICATION_FAILED = "Unregistered version or evaluation period expired!";
    protected static final String STR_REG_INFO_FILE_NAME = "RegInfo";
    protected static final String STR_REG_INFO_ENTRY_NAME = "fi/faidon/protection/RegInfo";
    protected static final String STR_TMP_PACKAGE_FILE_NAME = "regpack.tmp";
    protected static final String STR_VERSION_ENTRY_NAME = "Version.txt";
    protected final String STR_CONFIG_FILE_NAME = "config";
    protected final String STR_VERSION_TAG = "Version";
    protected final String STR_SERIAL_NO_TAG = "Serial#";
    protected final String STR_TAG_VALUE_SEPARATOR = ":";
    protected final String STR_COMPANY_CODE = "FADN";
    protected final String STR_PRODUCT_CODE = "JVG";
    protected final String STR_SER_NO_FIELD_SEPARATOR = "-";
    protected final int CHECKSUM_STR_LEN = 4;
    protected final int EVALUATION_VERSION_TYPE = 5;
    protected final int REGISTERED_VERSION_TYPE = 8;
    protected final int EVALUATION_DAYS = 30;
    protected String companyCode;
    protected String productCode;
    protected String version;
    protected int year;
    protected int month;
    protected int day;
    protected int hour;
    protected int minutes;
    protected int seconds;
    protected int type;
    protected int checksum;
    private static boolean currentPackageIsVerified;

    public boolean verifyCurrentPackage() {
        if (currentPackageIsVerified) {
            return true;
        }
        byte[] byArray = new byte[1024];
        URL uRL = this.getClass().getResource(STR_REG_INFO_FILE_NAME);
        if (uRL == null) {
            return false;
        }
        try {
            InputStream inputStream = uRL.openStream();
            int n = inputStream.read(byArray);
            String string = new String(byArray, 0, n);
            if (!this.verifySerialNumber(string)) {
                return false;
            }
        }
        catch (Exception exception) {
            return false;
        }
        currentPackageIsVerified = true;
        return true;
    }

    public String getSerialNumber(String string, boolean bl) {
        Calendar calendar = Calendar.getInstance();
        this.version = string;
        this.seconds = calendar.get(13);
        this.year = calendar.get(1);
        this.minutes = calendar.get(12);
        this.month = calendar.get(2);
        this.hour = calendar.get(11);
        this.day = calendar.get(5);
        this.type = bl ? 5 : 8;
        return this.makeSerialNoFromFields();
    }

    public boolean verifySerialNumber(String string) {
        if (!this.getFieldsFromSerialNo(string)) {
            return false;
        }
        int n = this.calcChecksum();
        String string2 = String.valueOf(n);
        n = new Integer(string2 = string2.substring(Math.max(0, string2.length() - 4)));
        if (n != this.checksum) {
            return false;
        }
        if (this.type != 8) {
            GregorianCalendar gregorianCalendar;
            Calendar calendar = Calendar.getInstance();
            if (calendar.before(gregorianCalendar = new GregorianCalendar(1900 + this.year, this.month, this.day, this.hour, this.minutes, this.seconds))) {
                return false;
            }
            gregorianCalendar.add(5, 30);
            if (calendar.after(gregorianCalendar)) {
                return false;
            }
        }
        return true;
    }

    protected String makeSerialNoFromFields() {
        int n = "FADN".length() + "JVG".length() + this.version.length() + "-".length() + 6 + "-".length() + 6 + 1 + 4;
        StringBuffer stringBuffer = new StringBuffer(n);
        stringBuffer.append("FADN");
        stringBuffer.append("JVG");
        stringBuffer.append(this.version);
        stringBuffer.append("-");
        String string = String.valueOf(this.seconds);
        if (string.length() < 2) {
            stringBuffer.append('0');
        }
        stringBuffer.append(string);
        string = String.valueOf(this.year);
        if (string.length() > 3) {
            string = string.substring(2);
        }
        if (string.length() < 2) {
            stringBuffer.append('0');
        }
        this.year = new Integer(string);
        stringBuffer.append(string);
        string = String.valueOf(this.minutes);
        if (string.length() < 2) {
            stringBuffer.append('0');
        }
        stringBuffer.append(string);
        stringBuffer.append("-");
        string = String.valueOf(this.month);
        if (string.length() < 2) {
            stringBuffer.append('0');
        }
        stringBuffer.append(string);
        string = String.valueOf(this.hour);
        if (string.length() < 2) {
            stringBuffer.append('0');
        }
        stringBuffer.append(string);
        string = String.valueOf(this.day);
        if (string.length() < 2) {
            stringBuffer.append('0');
        }
        stringBuffer.append(string);
        string = String.valueOf(this.type);
        stringBuffer.append(string);
        this.checksum = this.calcChecksum();
        string = String.valueOf(this.checksum);
        int n2 = 0;
        while (n2 < 4 - string.length()) {
            stringBuffer.append('0');
            ++n2;
        }
        stringBuffer.append(string.substring(Math.max(0, string.length() - 4)));
        String string2 = new String(stringBuffer);
        return string2;
    }

    protected boolean getFieldsFromSerialNo(String string) {
        String string2;
        try {
            int n = string.indexOf("-");
            string2 = string.substring(n + 1);
            int n2 = 0;
            this.companyCode = string.substring(n2, "FADN".length());
            this.productCode = string.substring(n2 += "FADN".length(), n2 + "JVG".length());
            this.version = string.substring(n2 += "JVG".length(), n);
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            return false;
        }
        try {
            this.seconds = new Integer(string2.substring(0, 2));
            this.year = new Integer(string2.substring(2, 4));
            this.minutes = new Integer(string2.substring(4, 6));
            this.month = new Integer(string2.substring(7, 9));
            this.hour = new Integer(string2.substring(9, 11));
            this.day = new Integer(string2.substring(11, 13));
            this.type = new Integer(string2.substring(13, 14));
            this.checksum = new Integer(string2.substring(14, 18));
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        return true;
    }

    private int calcChecksum() {
        return (this.seconds * 4 + this.minutes * 2 + this.hour * 4 + this.year + this.month * 4 + this.day + this.type * 3) * 679 / 29;
    }
}

