
/*****************************************************************************
 *														                     *
 *                              TestAllFormats.java                          *
 *                                                                           *
 * Small command-line application for demonstrating the image saving beans.  *
 *                                                                           *
 * Created by Kary FRAMLING 30/4/1998                                        *
 *                                                                           *
 *****************************************************************************/

import java.io.*;
import java.awt.*;
import fi.faidon.jis.*;
import java.awt.image.ImageObserver;

public class TestAllFormats
{

	//=============================================================================
	// main 
	//=============================================================================
	/**
	 * Program entry point.
	 *
	 * @author Kary FR&Auml;MLING
	 */
	//=============================================================================
	public static void main(String argv[])
	{
		File		current_dir;
		Image		img;
		String		current_path, img_path;
		ImageSaverObject	tga_is, tis_is, pict_is, bmp_is;

		// See that we have a source and a destination image name.
		if ( argv.length < 2 ) {
			System.out.println("Usage: ImageSaverObject <source image file> <dest image file>");
			System.exit(1);
		}

		// Get the launch directory of the application.
		current_dir = new File(".");
		current_dir = new File(current_dir.getAbsolutePath());
		current_path = current_dir.getParent(); 

		// We use an image relative to our launch directory.
		img_path = current_path + File.separator + argv[0];
		img = Toolkit.getDefaultToolkit().getImage(img_path);
		tga_is = new ImageSaverObject();
		tga_is.saveToFile(img, argv[1] + "." + TargaImageSaver.FORMAT_EXTENSION, TargaImageSaver.FORMAT_CODE);
		tis_is = new ImageSaverObject();
		tis_is.saveToFile(img, argv[1] + "." + TIFFImageSaver.FORMAT_EXTENSION, TIFFImageSaver.FORMAT_CODE);
		pict_is = new ImageSaverObject();
		pict_is.saveToFile(img, argv[1] + "." + PICTImageSaver.FORMAT_EXTENSION, PICTImageSaver.FORMAT_CODE);
		bmp_is = new ImageSaverObject();
		bmp_is.saveToFile(img, argv[1] + "." + BMPImageSaver.FORMAT_EXTENSION, BMPImageSaver.FORMAT_CODE);

		// Wait until saving is ready.
		while ( 
			(tga_is.checkSave() & ( ImageObserver.ALLBITS | ImageObserver.ABORT | ImageObserver.ERROR )) == 0 || 
			(tis_is.checkSave() & ( ImageObserver.ALLBITS | ImageObserver.ABORT | ImageObserver.ERROR )) == 0 ||
			(pict_is.checkSave() & ( ImageObserver.ALLBITS | ImageObserver.ABORT | ImageObserver.ERROR )) == 0 ||
			(bmp_is.checkSave() & ( ImageObserver.ALLBITS | ImageObserver.ABORT | ImageObserver.ERROR )) == 0
		) {
			System.out.println("Waiting for save to finish!");
			try { Thread.sleep(100); } 
			catch ( InterruptedException e ) { System.exit(1); }
		}
		System.exit(0);
	}

}
