/*
 * Decompiled with CFR 0.152.
 */
package fi.faidon.jis;

import fi.faidon.jis.ImageSaverInterface;
import java.awt.image.ColorModel;
import java.awt.image.ImageConsumer;
import java.awt.image.ImageProducer;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.Hashtable;

public class BMPImageSaver
extends ImageSaverInterface
implements Serializable,
ImageConsumer {
    public static final String FORMAT_CODE = "BMP";
    public static final String FORMAT_COMPLETE_NAME = "Windows/OS2 Bitmap";
    public static final String FORMAT_EXTENSION = "bmp";
    private final byte[] TYPE_BMP_BUF = new byte[]{66, 77};
    private final int BITMAP_FILE_HDR_SIZE = 14;
    private final int BITMAP_HDR_SIZE = 40;
    private final int BITS_PER_PIXEL = 24;
    private final int BYTES_PER_PIXEL = 3;
    private FileOutputStream writeFileHandle;
    private int width;
    private int height;
    private int saveStatus;
    private int byteCount;
    private byte[] pixBuf;
    private boolean hdrWritten;
    private boolean imageWritten;

    public String getFormatCode() {
        return FORMAT_CODE;
    }

    public String getFormatString() {
        return FORMAT_COMPLETE_NAME;
    }

    public String getFormatExtension() {
        return FORMAT_EXTENSION;
    }

    public boolean saveIt() {
        if (this.saveImage == null) {
            return false;
        }
        this.saveStatus = 0;
        try {
            this.writeFileHandle = new FileOutputStream(this.savePath);
        }
        catch (IOException iOException) {
            System.out.println("IOException occurred opening FileOutputStream : " + iOException);
        }
        if (this.writeFileHandle == null) {
            return false;
        }
        this.hdrWritten = false;
        this.imageWritten = false;
        ImageProducer imageProducer = this.saveImage.getSource();
        if (imageProducer == null) {
            return false;
        }
        imageProducer.startProduction(this);
        return true;
    }

    public int checkSave() {
        return this.saveStatus;
    }

    public void setProperties(Hashtable hashtable) {
        this.saveStatus |= 4;
    }

    public void setHints(int n) {
    }

    public void setColorModel(ColorModel colorModel) {
    }

    public void setDimensions(int n, int n2) {
        byte[] byArray = new byte[2];
        byte[] byArray2 = new byte[4];
        this.width = n;
        this.height = n2;
        if (!this.hdrWritten) {
            this.byteCount = 0;
            try {
                this.writeFileHandle.write(this.TYPE_BMP_BUF);
            }
            catch (IOException iOException) {
                System.out.println("Error!");
                this.saveStatus = 64;
            }
            this.byteCount += this.TYPE_BMP_BUF.length;
            int n3 = 3 * this.width * this.height;
            this.uintAsLittleEndianBytes(n3 + 14 + 40, byArray2, 0, byArray2.length);
            try {
                this.writeFileHandle.write(byArray2);
            }
            catch (IOException iOException) {
                this.saveStatus = 64;
            }
            this.byteCount += byArray2.length;
            this.uintAsLittleEndianBytes(0, byArray, 0, byArray.length);
            try {
                this.writeFileHandle.write(byArray);
            }
            catch (IOException iOException) {
                this.saveStatus = 64;
            }
            try {
                this.writeFileHandle.write(byArray);
            }
            catch (IOException iOException) {
                this.saveStatus = 64;
            }
            this.byteCount += 2 * byArray.length;
            this.uintAsLittleEndianBytes(54, byArray2, 0, byArray2.length);
            try {
                this.writeFileHandle.write(byArray2);
            }
            catch (IOException iOException) {
                this.saveStatus = 64;
            }
            this.byteCount += byArray2.length;
            this.uintAsLittleEndianBytes(40, byArray2, 0, byArray2.length);
            try {
                this.writeFileHandle.write(byArray2);
            }
            catch (IOException iOException) {
                this.saveStatus = 64;
            }
            this.byteCount += byArray2.length;
            this.uintAsLittleEndianBytes(this.width, byArray2, 0, byArray2.length);
            try {
                this.writeFileHandle.write(byArray2);
            }
            catch (IOException iOException) {
                this.saveStatus = 64;
            }
            this.uintAsLittleEndianBytes(this.height, byArray2, 0, byArray2.length);
            try {
                this.writeFileHandle.write(byArray2);
            }
            catch (IOException iOException) {
                this.saveStatus = 64;
            }
            this.byteCount += 2 * byArray2.length;
            this.uintAsLittleEndianBytes(1, byArray, 0, byArray.length);
            try {
                this.writeFileHandle.write(byArray);
            }
            catch (IOException iOException) {
                this.saveStatus = 64;
            }
            this.byteCount += byArray.length;
            this.uintAsLittleEndianBytes(24, byArray, 0, byArray.length);
            try {
                this.writeFileHandle.write(byArray);
            }
            catch (IOException iOException) {
                this.saveStatus = 64;
            }
            this.byteCount += byArray.length;
            this.uintAsLittleEndianBytes(0, byArray2, 0, byArray2.length);
            try {
                this.writeFileHandle.write(byArray2);
            }
            catch (IOException iOException) {
                this.saveStatus = 64;
            }
            this.byteCount += byArray2.length;
            this.uintAsLittleEndianBytes(n3, byArray2, 0, byArray2.length);
            try {
                this.writeFileHandle.write(byArray2);
            }
            catch (IOException iOException) {
                this.saveStatus = 64;
            }
            this.byteCount += byArray2.length;
            this.uintAsLittleEndianBytes(11700, byArray2, 0, byArray2.length);
            try {
                this.writeFileHandle.write(byArray2);
            }
            catch (IOException iOException) {
                this.saveStatus = 64;
            }
            try {
                this.writeFileHandle.write(byArray2);
            }
            catch (IOException iOException) {
                this.saveStatus = 64;
            }
            this.byteCount += 2 * byArray2.length;
            this.uintAsLittleEndianBytes(0, byArray2, 0, byArray2.length);
            try {
                this.writeFileHandle.write(byArray2);
            }
            catch (IOException iOException) {
                this.saveStatus = 64;
            }
            try {
                this.writeFileHandle.write(byArray2);
            }
            catch (IOException iOException) {
                this.saveStatus = 64;
            }
            this.byteCount += 2 * byArray2.length;
            this.pixBuf = new byte[3 * this.width * this.height];
            this.hdrWritten = true;
        }
        this.saveStatus |= 3;
    }

    public void setPixels(int n, int n2, int n3, int n4, ColorModel colorModel, byte[] byArray, int n5, int n6) {
        int n7 = n2 * 3 * this.width;
        int n8 = 0;
        while (n8 < n4) {
            int n9 = 0;
            while (n9 < n3) {
                int n10 = colorModel.getRGB(byArray[n5 + n8 * n6 + n9] & 0xFF);
                this.pixBuf[n7++] = (byte)(n10 & 0xFF);
                this.pixBuf[n7++] = (byte)(n10 >> 8 & 0xFF);
                this.pixBuf[n7++] = (byte)(n10 >> 16 & 0xFF);
                ++n9;
            }
            ++n8;
        }
        this.saveStatus |= 8;
    }

    public void setPixels(int n, int n2, int n3, int n4, ColorModel colorModel, int[] nArray, int n5, int n6) {
        int n7 = n2 * 3 * this.width;
        int n8 = 0;
        while (n8 < n4) {
            int n9 = 0;
            while (n9 < n3) {
                int n10 = colorModel.getRGB(nArray[n5 + n8 * n6 + n9]);
                this.pixBuf[n7++] = (byte)(n10 & 0xFF);
                this.pixBuf[n7++] = (byte)(n10 >> 8 & 0xFF);
                this.pixBuf[n7++] = (byte)(n10 >> 16 & 0xFF);
                ++n9;
            }
            ++n8;
        }
        this.saveStatus |= 8;
    }

    public void imageComplete(int n) {
        if (this.imageWritten) {
            return;
        }
        int n2 = this.width % 4;
        byte[] byArray = new byte[n2];
        int n3 = (this.height - 1) * this.width * 3;
        while (n3 >= 0) {
            try {
                this.writeFileHandle.write(this.pixBuf, n3, this.width * 3);
            }
            catch (IOException iOException) {
                this.saveStatus = 64;
            }
            this.byteCount += this.width * 3;
            if (n2 != 0) {
                try {
                    this.writeFileHandle.write(byArray);
                }
                catch (IOException iOException) {
                    this.saveStatus = 64;
                }
                this.byteCount += byArray.length;
            }
            n3 -= this.width * 3;
        }
        this.imageWritten = true;
        this.saveStatus |= 0x20;
    }

    private void uintAsLittleEndianBytes(int n, byte[] byArray, int n2, int n3) {
        int n4 = n2;
        int n5 = 0;
        while (n4 < n3) {
            byArray[n4] = (byte)(n >> n5 & 0xFF);
            ++n4;
            n5 += 8;
        }
    }

    private void intAsLittleEndianBytes(int n, byte[] byArray, int n2, int n3) {
        if (n < 0) {
            int n4 = -n;
            int n5 = (int)Math.pow(2.0, (n3 - n2) * 8 - 1);
            this.uintAsLittleEndianBytes(n5 - n4, byArray, n2, n3);
            int n6 = n3 - 1;
            byArray[n6] = (byte)(byArray[n6] | 0x80);
            return;
        }
        this.uintAsLittleEndianBytes(n, byArray, n2, n3);
    }
}

