/* This file is part of MINPANTU.
   See file `COPYRIGHT' for pertinent copyright notices.

   Functions defining and solving the differential equations
   describing the motion of the balls. */


#ifndef INCL_MOTION
#define INCL_MOTION 1


/* Given the locations and speeds of the balls on the playing field,
   compute the accelerations affecting them, i.e. the right-hand-side
   of the differential equations. */
extern void derive_state(double *state, double *Dstate);

/* As above, but a more efficient but inaccurate version. */
extern void sloppy_derive_state(double *state, double *Dstate);

/* Given the current state of balls in `state' at time `t', and a
   function evaluating the right-hand-side of the set of differential
   equations that describe the motion of the balls, compute the
   approximate state of the balls at time `t + step_size' into
   `state'. */
extern void integrate_step(double *state,
			   void (*derivator)(double *, double *),
			   double step_size);

/* The step length in integrating the ODE's describing the motion of
   the balls (in "seconds").  Should be small enough to obtain a
   sufficiently correct motion of the balls. */
#define INTEGRATE_STEP 0.025	/* A */


#endif /* INCL_MOTION */
