public final class Token {
    public static final int NONE = -1;
    // ASCII characters mix with other integer values.
    public static final int SEMICOLON = ';';
    public static final int PLUS = '+';
    public static final int MINUS = '-';
    public static final int TIMES = '*';
    public static final int DIVIDE = '/';
    public static final int IF = 256;
    public static final int THEN = 257;
    public static final int PRINT = 258;
    public static final int NUMBER = 259;
    public static final int IDENTIFIER = 260;
    // Everything above has been implemented already, but the code to
    // use the definitions below is to be implemented by you in the
    // Lexer!
    public static final int MOD = 261;
    public static final int OPEN_PAREN = '(';
    public static final int CLOSE_PAREN = ')';
    public static final int ASSIGN = 262;
    public static final int WHILE = 263;
    public static final int DO = 264;
    public static final int BEGIN = 265;
    public static final int END = 266;
    public static final int DONE = 267;

    public int token;	// The value of `token' is one of NONE to DONE
    public int i;	// The integer value associated with the token
    public String s;	// The string value associated with the token
}
