import Token;
import Lexer;
import java.io.*;
import java.lang.*;

public class Parser {
    Lexer lexer;
    Token token;

    void match(int expected_token) throws IOException {
	// This corresponds slightly to 'SHIFT' in yacc whereas
	// returns correspond to 'REDUCE's.
	if (expected_token == token.NONE || expected_token == token.token)
	    token = lexer.read_next_token();
	else
	    lexer.error("Syntax error");
    }
    void match() throws IOException { match(token.NONE); }

    int label_counter;
    int get_label() { return label_counter++; }

    void factor() throws IOException {
	switch (token.token) {
	case token.OPEN_PAREN:
	    match();
	    expr();
	    match(token.CLOSE_PAREN);
	    break;
	case token.NUMBER:
	    System.out.println("push " + token.i);
	    match();
	    break;
	default:
	    lexer.error("Syntax error");
	}
    }

    void term() throws IOException {
	factor();
	while (token.token == token.TIMES || token.token == token.DIVIDE) {
	    // Save 'token' into variable `t' since 'match()' changes it.
	    int t = token.token;
	    match();
	    factor();
	    System.out.println((char) t);
	}
    }

    void expr() throws IOException {
	term();
	while (token.token == token.PLUS || token.token == token.MINUS) {
	    int t = token.token;
	    match();
	    term();
	    System.out.println((char) t);
	}
    }

    void stmt() throws IOException {
	int LA;
    
	switch (token.token) {
	case token.PRINT:
	    match();
	    expr();
	    System.out.println("print");
	    break;
	case token.IF:
	    LA = get_label();
	    match();
	    expr();
	    match(token.THEN);
	    System.out.println("gofalse L" + LA);
	    stmt();
	    System.out.println("label L" + LA);
	    break;
	default:
	    lexer.error("Syntax error, expected a statement");
	    break;
	}
    }

    void stmts() throws IOException {
	stmt();
    }

    public void parse() throws IOException {
	match();
	stmts();
	if (token.token != token.DONE)
	    lexer.error("Syntax error");
    }

    public Parser(Lexer l) {
	label_counter = 0;
	lexer = l;
    }
}
