import Token;
import java.io.*;
import java.lang.*;

public class Lexer {
    public int line_number = 1;
    private PushbackInputStream input;
    
    int check_keyword(String s) {
	if (s.compareTo("print") == 0) return Token.PRINT;
	if (s.compareTo("if") == 0) return Token.IF;
	if (s.compareTo("then") == 0) return Token.THEN;
	return Token.NONE;
    }
    
    boolean is_alnum(int ch) {
	// java.lang.Character lacks `isAlnum' and some other important
	// methods, dammit!
	return ch == '_'
	    || (ch >= '0' && ch <= '9')
	    || (ch >= 'a' && ch <= 'z')
	    || (ch >= 'A' && ch <= 'Z');
    }
    
    boolean is_space(int ch) {
	// java.lang.Character.isSpace() seems to have become
	// deprecated in newer javas, so define our own, though not a
	// very good one.
	return ch == ' ' || ch == '\t' || ch == '\n';
    }
    
    
    public Token read_next_token() throws IOException {
	Token token = new Token();
	int ch;
	
	// Read away whitespaces.
	do {
	    ch = input.read();
	    if (ch == -1) {
		token.token = token.DONE;
		return token;
	    }
	    if (ch == '\n')
		line_number++;
	} while (is_space(ch));
	
	if (Character.isDigit((char) ch)) {
	    // It's a number.
	    token.i = ch - '0';
	    ch = input.read();
	    while (Character.isDigit((char) ch)) {
		token.i = 10 * token.i + ch - '0';
		ch = input.read();
	    }
	    input.unread(ch);
	    token.token = token.NUMBER;
	} else if (is_alnum(ch)) {
	    // It's either a (reserved) keyword or an identifier.
	    StringBuffer s = new StringBuffer();
	    do {
		s.append((char) ch);
		ch = input.read();
	    } while (is_alnum(ch));
	    input.unread(ch);
	    token.s = s.toString();
	    token.token = check_keyword(token.s);
	    if (token.token == Token.NONE)
		token.token = Token.IDENTIFIER;
	} else
	    token.token = ch;
	
	return token;
    }
    
    public Lexer(PushbackInputStream s) throws IOException {
	input = s;
    }
    
    public void error(String msg) {
	System.err.println(msg + " on line " + line_number);
	System.exit(1);
    }
}
