/* This file is part of alpha (= Alpha Loves to Perform Hasty Assembler).
 * See file COPYRIGHT for pertinent copyright notices.
 */

#ifdef DEBUG

#ifndef MAKE_UNDO_STORE
#define MAKE_UNDO_STORE(p) \
  do { \
    undo_info->address = (word_t *) (p); \
    undo_info->old_value = * (word_t *) (p); \
  } while (0)
#endif

#ifndef UNDO_STORE
#define UNDO_STORE \
  do { \
    *(undo_info->address) = undo_info->old_value; \
  } while (0)
#endif

#ifndef MAKE_UNDO_MEMCPY
#define MAKE_UNDO_MEMCPY(to, nbytes) \
  do { \
    /* XXX Undone */ \
  } while (0)
#endif

#ifndef UNDO_MEMCPY
#define UNDO_MEMCPY \
  do { \
    /* XXX Undone */ \
  } while (0)
#endif

#endif /* DEBUG */


#ifndef FAST

#ifndef ASSERT
#define ASSERT(x, msg) \
  do { \
    if (!(x)) { \
      fprintf(stderr, msg); \
      goto do_exit; \
    } \
  } while (0)
#endif

#ifndef DECLARE_STRING
#define DECLARE_STRING(x) declare_string(x)
#endif

#ifndef DISCARD_STRING
#define DISCARD_STRING(x) discard_string(x)
#endif

#ifndef CHECK_STRING
#define CHECK_STRING(x) \
  do { \
    if (!check_string(x)) \
      goto do_exit; \
  } while (0)
#endif

#ifndef CHECK_ADDR
#define CHECK_ADDR(x) \
  do { \
    if (!check_addr((word_t *) (x))) \
      goto do_exit; \
  } while (0)

#endif

#ifndef CHECK_CODE
#define CHECK_CODE(x) \
  do { \
    if (!check_code((word_t *) (x))) \
      goto do_exit; \
  } while (0)
#endif

#else

#ifndef ASSERT
#define ASSERT(x, msg) do { } while (0)
#endif

#ifndef DECLARE_STRING
#define DECLARE_STRING(x) /* */
#endif

#ifndef DISCARD_STRING
#define DISCARD_STRING(x) /* */
#endif

#ifndef CHECK_STRING
#define CHECK_STRING(x) do { } while (0)
#endif

#ifndef CHECK_ADDR
#define CHECK_ADDR(x) ((word_t *) (x))
#endif

#ifndef CHECK_CODE
#define CHECK_CODE(x) do { } while (0)
#endif

#endif /* else not FAST */


#ifdef AGGRESSIVE

#ifndef CLUTTER_CALLER_SAVED_REGS_1
#define CLUTTER_CALLER_SAVED_REGS_1 \
  do { \
    reg_v0.integer = reg_at.integer = 0xDEADBEEF; \
  } while (0)
#endif

#ifndef CLUTTER_CALLER_SAVED_REGS_2
#define CLUTTER_CALLER_SAVED_REGS_2 \
  do { \
    reg_t0.integer = reg_t1.integer = reg_t2.integer = reg_t3.integer = \
      reg_t4.integer = reg_t5.integer = reg_t6.integer = reg_t7.integer = \
        reg_t8.integer = reg_t9.integer = reg_t10.integer = reg_t11.integer = \
	  reg_a0.integer = reg_a1.integer = reg_a2.integer = \
            reg_a3.integer = reg_a4.integer = reg_a5.integer = \
	      reg_gp.integer = 0xDEADBEEF; \
  } while (0)
#endif

#else

#define CLUTTER_CALLER_SAVED_REGS_1 /* */
#define CLUTTER_CALLER_SAVED_REGS_2 /* */

#endif /* else AGGRESSIVE */



INSN(lda,
   {
     pc[2].ptr->ptr = refer_label(pc[2].string);
     pc += 3; 
   },
   { },
   {
     *pc[1].ptr = *pc[2].ptr;
     pc += 3;
   },
   MAKE_UNDO_STORE(pc[1].ptr),
   UNDO_STORE)

INSN(ldiq,
   { pc += 3; },
   { },
   {
     *pc[1].ptr = pc[2];
     pc += 3;
   },
   MAKE_UNDO_STORE(pc[1].ptr),
   UNDO_STORE)

INSN(ldq,
   { pc += 4; },
   CHECK_ADDR(pc[2].integer + pc[3].ptr->integer),
   {
     *pc[1].ptr = * (word_t *) (pc[2].integer + pc[3].ptr->integer);
     pc += 4;
   },
   MAKE_UNDO_STORE(pc[1].ptr),
   UNDO_STORE)

INSN(stq,
   { pc += 4; },
   CHECK_ADDR(pc[2].integer + pc[3].ptr->integer),
   {
     * (word_t *) (pc[2].integer + pc[3].ptr->integer) = *pc[1].ptr;
     pc += 4;
   },
   MAKE_UNDO_STORE(pc[2].integer + pc[3].ptr->integer),
   UNDO_STORE)
     
INSN(addq,
   { pc += 4; },
   { },
   {
     pc[3].ptr->integer = pc[1].ptr->integer + pc[2].ptr->integer;
     pc += 4;
   },
   MAKE_UNDO_STORE(pc[3].ptr),
   UNDO_STORE)

INSN(addq_c,
   { pc += 4; },
   { },
   {
     pc[3].ptr->integer = pc[1].ptr->integer + pc[2].integer;
     pc += 4;
   },
   MAKE_UNDO_STORE(pc[3].ptr),
   UNDO_STORE)
     
INSN(s4addq,
   { pc += 4; },
   { },
   {
     pc[3].ptr->integer = 4 * pc[1].ptr->integer + pc[2].ptr->integer;
     pc += 4;
   },
   MAKE_UNDO_STORE(pc[3].ptr),
   UNDO_STORE)

INSN(s4addq_c,
   { pc += 4; },
   { },
   {
     pc[3].ptr->integer = 4 * pc[1].ptr->integer + pc[2].integer;
     pc += 4;
   },
   MAKE_UNDO_STORE(pc[3].ptr),
   UNDO_STORE)
     
INSN(s8addq,
   { pc += 4; },
   { },
   {
     pc[3].ptr->integer = 8 * pc[1].ptr->integer + pc[2].ptr->integer;
     pc += 4;
   },
   MAKE_UNDO_STORE(pc[3].ptr),
   UNDO_STORE)

INSN(s8addq_c,
   { pc += 4; },
   { },
   {
     pc[3].ptr->integer = 8 * pc[1].ptr->integer + pc[2].integer;
     pc += 4;
   },
   MAKE_UNDO_STORE(pc[3].ptr),
   UNDO_STORE)
     
INSN(subq,
   { pc += 4; },
   { },
   {
     pc[3].ptr->integer = pc[1].ptr->integer - pc[2].ptr->integer;
     pc += 4;
   },
   MAKE_UNDO_STORE(pc[3].ptr),
   UNDO_STORE)

INSN(subq_c,
   { pc += 4; },
   { },
   {
     pc[3].ptr->integer = pc[1].ptr->integer - pc[2].integer;
     pc += 4;
   },
   MAKE_UNDO_STORE(pc[3].ptr),
   UNDO_STORE)
     
INSN(s4subq,
   { pc += 4; },
   { },
   {
     pc[3].ptr->integer = 4 * pc[1].ptr->integer - pc[2].ptr->integer;
     pc += 4;
   },
   MAKE_UNDO_STORE(pc[3].ptr),
   UNDO_STORE)

INSN(s4subq_c,
   { pc += 4; },
   { },
   {
     pc[3].ptr->integer = 4 * pc[1].ptr->integer - pc[2].integer;
     pc += 4;
   },
   MAKE_UNDO_STORE(pc[3].ptr),
   UNDO_STORE)
     
INSN(s8subq,
   { pc += 4; },
   { },
   {
     pc[3].ptr->integer = 8 * pc[1].ptr->integer - pc[2].ptr->integer;
     pc += 4;
   },
   MAKE_UNDO_STORE(pc[3].ptr),
   UNDO_STORE)

INSN(s8subq_c,
   { pc += 4; },
   { },
   {
     pc[3].ptr->integer = 8 * pc[1].ptr->integer - pc[2].integer;
     pc += 4;
   },
   MAKE_UNDO_STORE(pc[3].ptr),
   UNDO_STORE)
     
INSN(absq,
   { pc += 3; },
   { },
   { 
     pc[2].ptr->integer = abs(pc[1].ptr->integer);
     pc += 3;
   },
   MAKE_UNDO_STORE(pc[2].ptr),
   UNDO_STORE)

INSN(absq_c,
   { pc += 3; },
   { },
   { 
     pc[2].ptr->integer = abs(pc[1].integer);
     pc += 3;
   },
   MAKE_UNDO_STORE(pc[2].ptr),
   UNDO_STORE)

INSN(negq,
   { pc += 3; },
   { },
   { 
     pc[2].ptr->integer = -pc[1].ptr->integer;
     pc += 3;
   },
   MAKE_UNDO_STORE(pc[2].ptr),
   UNDO_STORE)

INSN(negq_c,
   { pc += 3; },
   { },
   { 
     pc[2].ptr->integer = -pc[1].integer;
     pc += 3;
   },
   MAKE_UNDO_STORE(pc[2].ptr),
   UNDO_STORE)

INSN(mulq,
   { pc += 4; },
   { },
   {
     pc[3].ptr->integer = pc[1].ptr->integer * pc[2].ptr->integer;
     pc += 4;
   },
   MAKE_UNDO_STORE(pc[3].ptr),
   UNDO_STORE)

INSN(mulq_c,
   { pc += 4; },
   { },
   {
     pc[3].ptr->integer = pc[1].ptr->integer * pc[2].integer;
     pc += 4;
   },
   MAKE_UNDO_STORE(pc[3].ptr),
   UNDO_STORE)
     
INSN(divq,
   { pc += 4; },
   ASSERT(pc[2].ptr->integer != 0, "division by zero"),
   {
     pc[3].ptr->integer = pc[1].ptr->integer / pc[2].ptr->integer;
     pc += 4;
   },
   MAKE_UNDO_STORE(pc[3].ptr),
   UNDO_STORE)

INSN(divq_c,
   { pc += 4; },
   ASSERT(pc[2].integer != 0, "division by zero"),
   {
     pc[3].ptr->integer = pc[1].ptr->integer / pc[2].integer;
     pc += 4;
   },
   MAKE_UNDO_STORE(pc[3].ptr),
   UNDO_STORE)
     
INSN(remq,
   { pc += 4; },
   ASSERT(pc[2].ptr->integer != 0, "reminder by zero"),
   {
     pc[3].ptr->integer = pc[1].ptr->integer % pc[2].ptr->integer;
     pc += 4;
   },
   MAKE_UNDO_STORE(pc[3].ptr),
   UNDO_STORE)

INSN(remq_c,
   { pc += 4; },
   ASSERT(pc[2].integer != 0, "reminder by zero"),
   {
     pc[3].ptr->integer = pc[1].ptr->integer % pc[2].integer;
     pc += 4;
   },
   MAKE_UNDO_STORE(pc[3].ptr),
   UNDO_STORE)
     
INSN(sll,
   { pc += 4; },
   { },
   {
     pc[3].ptr->integer = pc[1].ptr->integer << pc[2].ptr->integer;
     pc += 4;
   },
   MAKE_UNDO_STORE(pc[3].ptr),
   UNDO_STORE)

INSN(sll_c,
   { pc += 4; },
   { },
   {
     pc[3].ptr->integer = pc[1].ptr->integer << pc[2].integer;
     pc += 4;
   },
   MAKE_UNDO_STORE(pc[3].ptr),
   UNDO_STORE)
     
INSN(sra,
   { pc += 4; },
   { },
   {
     pc[3].ptr->integer = pc[1].ptr->integer >> pc[2].ptr->integer;
     pc += 4;
   },
   MAKE_UNDO_STORE(pc[3].ptr),
   UNDO_STORE)

INSN(sra_c,
   { pc += 4; },
   { },
   {
     pc[3].ptr->integer = pc[1].ptr->integer >> pc[2].integer;
     pc += 4;
   },
   MAKE_UNDO_STORE(pc[3].ptr),
   UNDO_STORE)
     
INSN(mov,
   { pc += 3; },
   { },
   {
     *pc[2].ptr = *pc[1].ptr;
     pc += 3;
   },
   MAKE_UNDO_STORE(pc[2].ptr),
   UNDO_STORE)

INSN(cmpeq,
   { pc += 4; },
   { },
   {
     pc[3].ptr->integer = (pc[1].ptr->integer == pc[2].ptr->integer);
     pc += 4;
   },
   MAKE_UNDO_STORE(pc[3].ptr),
   UNDO_STORE)

INSN(cmpeq_c,
   { pc += 4; },
   { },
   {
     pc[3].ptr->integer = (pc[1].ptr->integer == pc[2].integer);
     pc += 4;
   },
   MAKE_UNDO_STORE(pc[3].ptr),
   UNDO_STORE)
     
INSN(cmplt,
   { pc += 4; },
   { },
   {
     pc[3].ptr->integer = (pc[1].ptr->integer < pc[2].ptr->integer);
     pc += 4;
   },
   MAKE_UNDO_STORE(pc[3].ptr),
   UNDO_STORE)

INSN(cmplt_c,
   { pc += 4; },
   { },
   {
     pc[3].ptr->integer = (pc[1].ptr->integer < pc[2].integer);
     pc += 4;
   },
   MAKE_UNDO_STORE(pc[3].ptr),
   UNDO_STORE)
     
INSN(cmple,
   { pc += 4; },
   { },
   {
     pc[3].ptr->integer = (pc[1].ptr->integer <= pc[2].ptr->integer);
     pc += 4;
   },
   MAKE_UNDO_STORE(pc[3].ptr),
   UNDO_STORE)

INSN(cmple_c,
   { pc += 4; },
   { },
   {
     pc[3].ptr->integer = (pc[1].ptr->integer <= pc[2].integer);
     pc += 4;
   },
   MAKE_UNDO_STORE(pc[3].ptr),
   UNDO_STORE)
     
INSN(br,
   {
     pc[1].ptr = refer_label(pc[1].string);
     pc += 2;
   },
   { },
   { pc = pc[1].ptr; },
   { },
   { })
     
INSN(beq,
   {
     pc[2].ptr = refer_label(pc[2].string);
     pc += 3;
   },
   { },
   { 
     if (pc[1].ptr->integer == 0)
       pc = pc[2].ptr;
     else
       pc += 3;
   },
   { },
   { })
     
INSN(bne,
   {
     pc[2].ptr = refer_label(pc[2].string);
     pc += 3;
   },
   { },
   { 
     if (pc[1].ptr->integer != 0)
       pc = pc[2].ptr;
     else
       pc += 3;
   },
   { },
   { })
     
INSN(blt,
   {
     pc[2].ptr = refer_label(pc[2].string);
     pc += 3;
   },
   { },
   { 
     if (pc[1].ptr->integer < 0)
       pc = pc[2].ptr;
     else
       pc += 3;
   },
   { },
   { })
     
INSN(ble,
   {
     pc[2].ptr = refer_label(pc[2].string);
     pc += 3;
   },
   { },
   { 
     if (pc[1].ptr->integer <= 0)
       pc = pc[2].ptr; 
     else
       pc += 3;
   },
   { },
   { })
     
INSN(bgt,
   {
     pc[2].ptr = refer_label(pc[2].string);
     pc += 3;
   },
   { },
   { 
     if (pc[1].ptr->integer > 0)
       pc = pc[2].ptr; 
     else
       pc += 3;
   },
   { },
   { })
     
INSN(bge,
   {
     pc[2].ptr = refer_label(pc[2].string);
     pc += 3;
   },
   { },
   { 
     if (pc[1].ptr->integer >= 0)
       pc = pc[2].ptr;
     else
       pc += 3;
   },
   { },
   { })
     
     
INSN(jsr,
   {
     pc[1].ptr = refer_label(pc[1].string);
     pc += 2; 
   },
   { },
   {
     reg_ra.ptr = pc + 2;
     pc = pc[1].ptr;
   },
   MAKE_UNDO_STORE(reg_ra.ptr),
   UNDO_STORE)

INSN(bsr,
   {
     pc[1].ptr = refer_label(pc[1].string);
     pc += 2; 
   },
   { },
   {
     reg_ra.ptr = pc + 2;
     pc = pc[1].ptr;
   },
   MAKE_UNDO_STORE(reg_ra.ptr),
   UNDO_STORE)

INSN(ret,
   { pc++; },
   CHECK_CODE(reg_ra.ptr),
   { pc = reg_ra.ptr; },
   { },
   { })

INSN(cmoveq,
   { pc += 4; },
   { },
   {
     if (pc[1].ptr->integer == 0)
       *pc[3].ptr = *pc[2].ptr;
     pc += 4;
   },
   MAKE_UNDO_STORE(pc[3].ptr),
   UNDO_STORE)

INSN(cmoveq_c,
   { pc += 4; },
   { },
   {
     if (pc[1].ptr->integer == 0)
       pc[3].ptr->integer = pc[2].integer;
     pc += 4;
   },
   MAKE_UNDO_STORE(pc[3].ptr),
   UNDO_STORE)
     
INSN(cmovne,
   { pc += 4; },
   { },
   {
     if (pc[1].ptr->integer != 0)
       *pc[3].ptr = *pc[2].ptr;
     pc += 4;
   },
   MAKE_UNDO_STORE(pc[3].ptr),
   UNDO_STORE)

INSN(cmovne_c,
   { pc += 4; },
   { },
   {
     if (pc[1].ptr->integer != 0)
       pc[3].ptr->integer = pc[2].integer;
     pc += 4;
   },
   MAKE_UNDO_STORE(pc[3].ptr),
   UNDO_STORE)
     
INSN(cmovlt,
   { pc += 4; },
   { },
   {
     if (pc[1].ptr->integer < 0)
       *pc[3].ptr = *pc[2].ptr;
     pc += 4;
   },
   MAKE_UNDO_STORE(pc[3].ptr),
   UNDO_STORE)

INSN(cmovlt_c,
   { pc += 4; },
   { },
   {
     if (pc[1].ptr->integer < 0)
       pc[3].ptr->integer = pc[2].integer;
     pc += 4;
   },
   MAKE_UNDO_STORE(pc[3].ptr),
   UNDO_STORE)
     
INSN(cmovle,
   { pc += 4; },
   { },
   {
     if (pc[1].ptr->integer <= 0)
       *pc[3].ptr = *pc[2].ptr;
     pc += 4;
   },
   MAKE_UNDO_STORE(pc[3].ptr),
   UNDO_STORE)

INSN(cmovle_c,
   { pc += 4; },
   { },
   {
     if (pc[1].ptr->integer <= 0)
       pc[3].ptr->integer = pc[2].integer;
     pc += 4;
   },
   MAKE_UNDO_STORE(pc[3].ptr),
   UNDO_STORE)
     
INSN(cmovgt,
   { pc += 4; },
   { },
   {
     if (pc[1].ptr->integer > 0)
       *pc[3].ptr = *pc[2].ptr;
     pc += 4;
   },
   MAKE_UNDO_STORE(pc[3].ptr),
   UNDO_STORE)

INSN(cmovgt_c,
   { pc += 4; },
   { },
   {
     if (pc[1].ptr->integer > 0)
       pc[3].ptr->integer = pc[2].integer;
     pc += 4;
   },
   MAKE_UNDO_STORE(pc[3].ptr),
   UNDO_STORE)
     
INSN(cmovge,
   { pc += 4; },
   { },
   {
     if (pc[1].ptr->integer >= 0)
       *pc[3].ptr = *pc[2].ptr;
     pc += 4;
   },
   MAKE_UNDO_STORE(pc[3].ptr),
   UNDO_STORE)

INSN(cmovge_c,
   { pc += 4; },
   { },
   {
     if (pc[1].ptr->integer >= 0)
       pc[3].ptr->integer = pc[2].integer;
     pc += 4;
   },
   MAKE_UNDO_STORE(pc[3].ptr),
   UNDO_STORE)



INSN(UICC_ReadInt, 
   { pc++; },
   { },
   {
     CLUTTER_CALLER_SAVED_REGS_1;
     scanf("%ld", &reg_v0);
     pc = reg_ra.ptr;
     CLUTTER_CALLER_SAVED_REGS_2;
   },
   MAKE_UNDO_STORE(&reg_v0),
   UNDO_STORE)

INSN(UICC_ReadString,
   { pc++; },
   { },
   {
     char buf[1024];
     char *res;
     CLUTTER_CALLER_SAVED_REGS_1;
     gets(buf);
     res = (char *) malloc(strlen(buf)+1);
     if (res == NULL) {
       fprintf(stderr, "Memory exhausted in UICC_ReadString\n");
       exit(1);
     }
     strcpy(res, buf);
     DECLARE_STRING(res);
     reg_v0.string = res;
     pc = reg_ra.ptr;
     CLUTTER_CALLER_SAVED_REGS_2;
  },
   MAKE_UNDO_STORE(&reg_v0),
   {
     DISCARD_STRING(reg_v0.string);
     free(reg_v0.string);
     UNDO_STORE;
   })

INSN(UICC_WriteInt,
   { pc++; },
   { },
   { 
     CLUTTER_CALLER_SAVED_REGS_1;
     printf("%ld", reg_a0.integer);
     pc = reg_ra.ptr;
     CLUTTER_CALLER_SAVED_REGS_2;
   },
   { },
   { })

INSN(UICC_WriteString,
   { pc++; },
   CHECK_STRING(reg_a0.string),
   {
     CLUTTER_CALLER_SAVED_REGS_1;
     printf("%s", reg_a0.string);
     pc = reg_ra.ptr;
     CLUTTER_CALLER_SAVED_REGS_2;
   },
   { },
   { })

INSN(UICC_AllocateString,
   { pc++; },
   { },
   {
     char *res;
     CLUTTER_CALLER_SAVED_REGS_1;
     res = (char *) malloc(reg_a0.integer + 1);
     if (res == NULL) {
       fprintf(stderr, "Memory exhausted in UICC_AllocateString\n");
       exit(1);
     }
     *res = '\0';
     DECLARE_STRING(res);
     reg_v0.string = res;
     pc = reg_ra.ptr;
     CLUTTER_CALLER_SAVED_REGS_2;
   },
   MAKE_UNDO_STORE(&reg_v0),
   {
     CHECK_STRING(reg_v0.string);
     free(reg_v0.string);
     UNDO_STORE;
   })

INSN(UICC_FreeString,
   { pc++; },
   CHECK_STRING(reg_a0.string),
   {
     CLUTTER_CALLER_SAVED_REGS_1;
#ifndef STEP
     free(reg_a0.string);
#endif
     pc = reg_ra.ptr;
     CLUTTER_CALLER_SAVED_REGS_2;
   },
   {
     undo_info->undo_extra = (void *) reg_a0.string;
   },
   {
     reg_a0.string = (char *) undo_info->undo_extra;
   })

INSN(UICC_StringToInt,
   { pc++; },
   CHECK_STRING(reg_a0.string),
   {
     CLUTTER_CALLER_SAVED_REGS_1;
     reg_v0.integer = atol(reg_a0.string);
     pc = reg_ra.ptr;
     CLUTTER_CALLER_SAVED_REGS_2;
   },
   MAKE_UNDO_STORE(&reg_v0),
   UNDO_STORE)

INSN(UICC_IntToString,
   { pc++; },
   { },
   {
     char buf[20];
     char *res;
     CLUTTER_CALLER_SAVED_REGS_1;
     sprintf(buf, "%ld", reg_a0);
     res = (char *) malloc(strlen(buf) + 1);
     if (res == NULL) {
       fprintf(stderr, "Memory exhausted in UICC_IntToString\n");
       exit(1);
     }
     strcpy(res, buf);
     DECLARE_STRING(res);
     reg_v0.string = res;
     pc = reg_ra.ptr;
     CLUTTER_CALLER_SAVED_REGS_2;
   },
   MAKE_UNDO_STORE(&reg_v0),
   {
     DISCARD_STRING(reg_v0.string);
     free(reg_v0.string);
     UNDO_STORE;
   })

INSN(UICC_StringLength,
   { pc++; },
   CHECK_STRING(reg_a0.string),
   {
     CLUTTER_CALLER_SAVED_REGS_1;
     reg_v0.integer = strlen(reg_a0.string);
     pc = reg_ra.ptr;
     CLUTTER_CALLER_SAVED_REGS_2;
   },
   MAKE_UNDO_STORE(&reg_v0),
   UNDO_STORE)


INSN(UICC_StringCompare,
   { pc++; },
   { 
     CHECK_STRING(reg_a0.string);
     CHECK_STRING(reg_a1.string);
   },
   {
     CLUTTER_CALLER_SAVED_REGS_1;
     reg_v0.integer = strcmp(reg_a0.string, reg_a1.string);
     pc = reg_ra.ptr;
     CLUTTER_CALLER_SAVED_REGS_2;
   },
   MAKE_UNDO_STORE(&reg_v0),
   UNDO_STORE)

INSN(UICC_CopyIntoString,
   { pc++; },
   {
     CHECK_STRING(reg_a0.string);
     CHECK_STRING(reg_a1.string);
   },
   {
     int l;
     CLUTTER_CALLER_SAVED_REGS_1;
     l = strlen(reg_a1.string);
     memcpy(reg_a1.string + reg_a2.integer, reg_a0.string, reg_a3.integer);
     if (l < reg_a2.integer + reg_a3.integer)
       reg_a1.string[reg_a2.integer + reg_a3.integer] = '\0';
     pc = reg_ra.ptr;
     CLUTTER_CALLER_SAVED_REGS_2;
   },
   MAKE_UNDO_MEMCPY(reg_a1.string + reg_a2.integer, reg_a3.integer + 1),
   UNDO_MEMCPY)

INSN(UICC_CopyFromString,
   { pc++; },
   {
     CHECK_STRING(reg_a0.string);
     CHECK_STRING(reg_a1.string);
   },
   {
     CLUTTER_CALLER_SAVED_REGS_1;
     strncpy(reg_a0.string, reg_a1.string + reg_a2.integer, reg_a3.integer);
     reg_a0.string[reg_a3.integer] = '\0';
     pc = reg_ra.ptr;
     CLUTTER_CALLER_SAVED_REGS_2;
   },
   MAKE_UNDO_MEMCPY(reg_a0.string, reg_a3.integer + 1),
   UNDO_MEMCPY)

INSN(UICC_Arguments,
   { pc++; },
   { },
   {
     CLUTTER_CALLER_SAVED_REGS_1;
     reg_v0.integer = number_of_arguments;
     pc = reg_ra.ptr;
     CLUTTER_CALLER_SAVED_REGS_2;
   },
   MAKE_UNDO_STORE(&reg_v0),
   UNDO_STORE)

INSN(UICC_Argument,
   { pc++; },
   {
     if (reg_a0.integer < 0 || reg_a0.integer >= number_of_arguments) {
       fprintf(stderr, "No such argument %d\n", reg_a0.integer);
       exit(1); /* XXX */
     }
   },
   {
     CLUTTER_CALLER_SAVED_REGS_1;
     reg_v0.string = arg_strings[reg_a0.integer];
     pc = reg_ra.ptr;
     CLUTTER_CALLER_SAVED_REGS_2;
   },
   MAKE_UNDO_STORE(&reg_v0),
   UNDO_STORE)

INSN(UICC_ProgramName,
   { pc++; },
   { },
   {
     CLUTTER_CALLER_SAVED_REGS_1;
     reg_v0.string = prog_name;
     pc = reg_ra.ptr;
     CLUTTER_CALLER_SAVED_REGS_2;
   },
   MAKE_UNDO_STORE(&reg_v0),
   UNDO_STORE)

INSN(UICC_exit,
   { pc++; },
   { },
   { goto do_exit; },
   { },
   { })
