%{
/* This file is part of alpha (= Alpha Loves to Perform Hasty Assembler).
 * See file COPYRIGHT for pertinent copyright notices.
 */

#include <stdio.h>
#include "exe.h"

void clierror(char *msg)
{
  fprintf(stderr, "%s\n", msg);
}

%}

%union {
  int i;
}

%token NL
%token RUN STEP BACK PRINT TRACE
%token <i> REG INT

%%

lines:	  line NL lines
	| NL lines
	| error NL lines
	|
	;

line:	  RUN 			{
				  cli_command = RUN_COMMAND;
				  YYACCEPT;
				}
	| STEP			{
				  cli_command = STEP_COMMAND;
				  YYACCEPT;
				}
	| BACK			{
#ifdef DEBUG
				  cli_command = BACK_COMMAND;
				  YYACCEPT;
#else
				  printf("  BACK not implemented in aggressive mode.\n"); 
#endif
				}
	| PRINT REG		{ 
				  printf("  $%d = 0x%08x\n", $2, reg[$2]); 
				  printf("> ");
				}
	| TRACE			{
				  tracing = !tracing;
				  printf("Tracing now %s\n", 
				         tracing ? "on" : "off");
				  printf("> ");
				}
	;

%%
