%{
/* This file is part of alpha (= Alpha Loves to Perform Hasty Assembler).
 * See file COPYRIGHT for pertinent copyright notices.
 */

#include <strings.h>
#include "cli-parse.h"

%}

%%

[ \t]			{ ; }
run			{ return RUN; }
r			{ return RUN; }
step			{ return STEP; }
s			{ return STEP; }
back			{ return BACK; }
b			{ return BACK; }
print			{ return PRINT; }
p			{ return PRINT; }
trace			{ return TRACE; }
t			{ return TRACE; }

-?(0|[1-9][0-9]*)       { clilval.i = atoi(clitext); return INT; }
$[1-2]?[0-9]            { clilval.i = atoi(clitext+1); return REG; }
$3[01]                  { clilval.i = atoi(clitext+1); return REG; }

\n			{ return NL; }
.			{ return *yytext; }

%%

int cliwrap(void)
{
  return 1;
}
