%{
/* This file is part of alpha (= Alpha Loves to Perform Hasty Assembler).
 * See file COPYRIGHT for pertinent copyright notices.
 */

#include <stdio.h>
#include "exe.h"

extern int asmlex(void);

int asmerror(char *msg)
{
  fprintf(stderr, "%s on line %d\n", msg, asm_lineno);
  exit(1);
}

%}


%start program

%union {
  char *s;
  long i;
}

%token <s> TOKEN LABEL STRING
%token <i> INT REG
%token DOT_ALIGN DOT_ASCII DOT_COMM DOT_DATA DOT_ENT DOT_END DOT_GLOBL DOT_TEXT
%token LDA LDIQ LDQ STQ
%token ADDQ S4ADDQ S8ADDQ SUBQ S4SUBQ S8SUBQ
%token ABSQ NEGQ MULQ DIVQ REMQ SLL SRA MOV
%token CMPEQ CMPNE CMPLT CMPLE CMPGT CMPGE
%token BR BEQ BNE BGT BGE BLE BLT
%token CMOVEQ CMOVNE CMOVGT CMOVGE CMOVLE CMOVLT
%token JSR BSR LDGP RET
%token CPP_LINE

%%

program:  program string_const		{ }
	| program routine		{ }
	| program DOT_TEXT		{ }
	| program DOT_DATA		{ }
	|
	;

string_const: LABEL DOT_ASCII STRING	{
					  define_mem_label($1, 
							   (word_t *) $3);
#ifndef FAST
					  declare_string($3);
#endif
					}
	;

routine:  routine_prelude routine_instructions DOT_END TOKEN
	;

routine_prelude: possible_align 
	  DOT_GLOBL TOKEN 
	  DOT_ENT TOKEN
	;

possible_align: DOT_ALIGN INT
	|
	;

routine_instructions: routine_instructions insn
	|
	;

insn:	  LDA REG ',' TOKEN		{ 
					  ADD_MNEMONIC(lda);
					  ADD_COMMENT("lda");
					  ADD_DST_REG($2);
					  ADD_LABEL_REF($4);
					}
	| LDA REG ',' INT '(' REG ')'	{
					  ADD_MNEMONIC(addq_c);
					  ADD_COMMENT("lda (addq_c)");
					  ADD_SRC_REG($6);
					  ADD_IMM($4);
					  ADD_DST_REG($2);
					}
	| LDIQ REG ',' INT		{
					  ADD_MNEMONIC(ldiq);
					  ADD_COMMENT("ldiq");
					  ADD_DST_REG($2);
					  ADD_IMM($4);
					}
	| LDQ REG ',' INT '(' REG ')'	{
					  ADD_MNEMONIC(ldq);
					  ADD_COMMENT("ldq");
					  ADD_DST_REG($2);
					  ADD_IMM($4);
					  ADD_SRC_REG($6);
					}
	| STQ REG ',' INT '(' REG ')'	{
					  ADD_MNEMONIC(stq);
					  ADD_COMMENT("stq");
					  ADD_SRC_REG($2);
					  ADD_IMM($4);
					  ADD_SRC_REG($6);
					}
	| ADDQ REG ',' REG ',' REG	{
					  ADD_MNEMONIC(addq);
					  ADD_COMMENT("addq");
					  ADD_SRC_REG($2);
					  ADD_SRC_REG($4);
					  ADD_DST_REG($6);
					}
	| ADDQ REG ',' INT ',' REG	{
					  ADD_MNEMONIC(addq_c);
					  ADD_COMMENT("addq_c");
					  ADD_SRC_REG($2);
					  ADD_IMM($4);
					  ADD_DST_REG($6);
					}
	| S4ADDQ REG ',' REG ',' REG	{
					  ADD_MNEMONIC(s4addq);
					  ADD_COMMENT("s4addq");
					  ADD_SRC_REG($2);
					  ADD_SRC_REG($4);
					  ADD_DST_REG($6);
					}
	| S4ADDQ REG ',' INT ',' REG	{
					  ADD_MNEMONIC(s4addq_c);
					  ADD_COMMENT("s4addq_c");
					  ADD_SRC_REG($2);
					  ADD_IMM($4);
					  ADD_DST_REG($6);
					}
	| S8ADDQ REG ',' REG ',' REG	{
					  ADD_MNEMONIC(s8addq);
					  ADD_COMMENT("s8addq");
					  ADD_SRC_REG($2);
					  ADD_SRC_REG($4);
					  ADD_DST_REG($6);
					}
	| S8ADDQ REG ',' INT ',' REG	{
					  ADD_MNEMONIC(s8addq_c);
					  ADD_COMMENT("s8addq_c");
					  ADD_SRC_REG($2);
					  ADD_IMM($4);
					  ADD_DST_REG($6);
					}
	| SUBQ REG ',' REG ',' REG	{
					  ADD_MNEMONIC(subq);
					  ADD_COMMENT("subq");
					  ADD_SRC_REG($2);
					  ADD_SRC_REG($4);
					  ADD_DST_REG($6);
					}
	| SUBQ REG ',' INT ',' REG	{
					  ADD_MNEMONIC(subq_c);
					  ADD_COMMENT("subq_c");
					  ADD_SRC_REG($2);
					  ADD_IMM($4);
					  ADD_DST_REG($6);
					}
	| S4SUBQ REG ',' REG ',' REG	{
					  ADD_MNEMONIC(s4subq);
					  ADD_COMMENT("s4subq");
					  ADD_SRC_REG($2);
					  ADD_SRC_REG($4);
					  ADD_DST_REG($6);
					}
	| S4SUBQ REG ',' INT ',' REG	{
					  ADD_MNEMONIC(s4subq_c);
					  ADD_COMMENT("s4subq_c");
					  ADD_SRC_REG($2);
					  ADD_IMM($4);
					  ADD_DST_REG($6);
					}
	| S8SUBQ REG ',' REG ',' REG	{
					  ADD_MNEMONIC(s8subq);
					  ADD_COMMENT("s8subq");
					  ADD_SRC_REG($2);
					  ADD_SRC_REG($4);
					  ADD_DST_REG($6);
					}
	| S8SUBQ REG ',' INT ',' REG	{
					  ADD_MNEMONIC(s8subq_c);
					  ADD_COMMENT("s8subq_c");
					  ADD_SRC_REG($2);
					  ADD_IMM($4);
					  ADD_DST_REG($6);
					}
	| ABSQ REG ',' REG		{
					  ADD_MNEMONIC(absq);
					  ADD_COMMENT("absq");
					  ADD_SRC_REG($2);
					  ADD_DST_REG($4);
					}
	| ABSQ REG ',' INT		{
					  ADD_MNEMONIC(absq_c);
					  ADD_COMMENT("absq_c");
					  ADD_SRC_REG($2);
					  ADD_IMM($4);
					}
	| NEGQ REG ',' REG		{
					  ADD_MNEMONIC(negq);
					  ADD_COMMENT("negq");
					  ADD_SRC_REG($2);
					  ADD_DST_REG($4);
					}
	| NEGQ REG ',' INT		{
					  ADD_MNEMONIC(negq_c);
					  ADD_COMMENT("negq_c");
					  ADD_SRC_REG($2);
					  ADD_IMM($4);
					}
	| MULQ REG ',' REG ',' REG	{
					  ADD_MNEMONIC(mulq);
					  ADD_COMMENT("mulq");
					  ADD_SRC_REG($2);
					  ADD_SRC_REG($4);
					  ADD_DST_REG($6);
					}
	| MULQ REG ',' INT ',' REG	{
					  ADD_MNEMONIC(mulq_c);
					  ADD_COMMENT("mulq_c");
					  ADD_SRC_REG($2);
					  ADD_IMM($4);
					  ADD_DST_REG($6);
					}
	| DIVQ REG ',' REG ',' REG	{
					  ADD_MNEMONIC(divq);
					  ADD_COMMENT("divq");
					  ADD_SRC_REG($2);
					  ADD_SRC_REG($4);
					  ADD_DST_REG($6);
					}
	| DIVQ REG ',' INT ',' REG	{
					  ADD_MNEMONIC(divq_c);
					  ADD_COMMENT("divq_c");
					  ADD_SRC_REG($2);
					  ADD_IMM($4);
					  ADD_DST_REG($6);
					}
	| REMQ REG ',' REG ',' REG	{
					  ADD_MNEMONIC(remq);
					  ADD_COMMENT("remq");
					  ADD_SRC_REG($2);
					  ADD_SRC_REG($4);
					  ADD_DST_REG($6);
					}
	| REMQ REG ',' INT ',' REG	{
					  ADD_MNEMONIC(remq_c);
					  ADD_COMMENT("remq_c");
					  ADD_SRC_REG($2);
					  ADD_IMM($4);
					  ADD_DST_REG($6);
					}
	| SLL REG ',' REG ',' REG	{
					  ADD_MNEMONIC(sll);
					  ADD_COMMENT("sll");
					  ADD_SRC_REG($2);
					  ADD_SRC_REG($4);
					  ADD_DST_REG($6);
					}
	| SLL REG ',' INT ',' REG	{
					  ADD_MNEMONIC(sll_c);
					  ADD_COMMENT("sll_c");
					  ADD_SRC_REG($2);
					  ADD_IMM($4);
					  ADD_DST_REG($6);
					}
	| SRA REG ',' REG ',' REG	{
					  ADD_MNEMONIC(sra);
					  ADD_COMMENT("sra");
					  ADD_SRC_REG($2);
					  ADD_SRC_REG($4);
					  ADD_DST_REG($6);
					}
	| SRA REG ',' INT ',' REG	{
					  ADD_MNEMONIC(sra_c);
					  ADD_COMMENT("sra_c");
					  ADD_SRC_REG($2);
					  ADD_IMM($4);
					  ADD_DST_REG($6);
					}
	| MOV REG ',' REG		{
					  ADD_MNEMONIC(mov);
					  ADD_COMMENT("mov");
					  ADD_SRC_REG($2);
					  ADD_DST_REG($4);
					}
	| CMPEQ REG ',' REG ',' REG	{
					  ADD_MNEMONIC(cmpeq);
					  ADD_COMMENT("cmpeq");
					  ADD_SRC_REG($2);
					  ADD_SRC_REG($4);
					  ADD_DST_REG($6);
					}
	| CMPEQ REG ',' INT ',' REG	{
					  ADD_MNEMONIC(cmpeq_c);
					  ADD_COMMENT("cmpeq_c");
					  ADD_SRC_REG($2);
					  ADD_IMM($4);
					  ADD_DST_REG($6);
					}
	| CMPLT REG ',' REG ',' REG	{
					  ADD_MNEMONIC(cmplt);
					  ADD_COMMENT("cmplt");
					  ADD_SRC_REG($2);
					  ADD_SRC_REG($4);
					  ADD_DST_REG($6);
					}
	| CMPLT REG ',' INT ',' REG	{
					  ADD_MNEMONIC(cmplt_c);
					  ADD_COMMENT("cmplt_c");
					  ADD_SRC_REG($2);
					  ADD_IMM($4);
					  ADD_DST_REG($6);
					}
	| CMPLE REG ',' REG ',' REG	{
					  ADD_MNEMONIC(cmple);
					  ADD_COMMENT("cmple");
					  ADD_SRC_REG($2);
					  ADD_SRC_REG($4);
					  ADD_DST_REG($6);
					}
	| CMPLE REG ',' INT ',' REG	{
					  ADD_MNEMONIC(cmple_c);
					  ADD_COMMENT("cmple_c");
					  ADD_SRC_REG($2);
					  ADD_IMM($4);
					  ADD_DST_REG($6);
					}
	| BR TOKEN			{
					  ADD_MNEMONIC(br);
					  ADD_COMMENT("br");
					  ADD_LABEL_REF($2);
					}
	| BEQ REG ',' TOKEN		{
					  ADD_MNEMONIC(beq);
					  ADD_COMMENT("beq");
					  ADD_SRC_REG($2);
					  ADD_LABEL_REF($4);
					}
	| BNE REG ',' TOKEN		{
					  ADD_MNEMONIC(bne);
					  ADD_COMMENT("bne");
					  ADD_SRC_REG($2);
					  ADD_LABEL_REF($4);
					}
	| BLT REG ',' TOKEN		{
					  ADD_MNEMONIC(blt);
					  ADD_COMMENT("blt");
					  ADD_SRC_REG($2);
					  ADD_LABEL_REF($4);
					}
	| BLE REG ',' TOKEN		{
					  ADD_MNEMONIC(ble);
					  ADD_COMMENT("ble");
					  ADD_SRC_REG($2);
					  ADD_LABEL_REF($4);
					}	
	| BGT REG ',' TOKEN		{
					  ADD_MNEMONIC(bgt);
					  ADD_COMMENT("bgt");
					  ADD_SRC_REG($2);
					  ADD_LABEL_REF($4);
					}
	| BGE REG ',' TOKEN		{
					  ADD_MNEMONIC(bge);
					  ADD_COMMENT("bge");
					  ADD_SRC_REG($2);
					  ADD_LABEL_REF($4);
					}
	| CMOVEQ REG ',' REG ',' REG	{
					  ADD_MNEMONIC(cmoveq);
					  ADD_COMMENT("cmoveq");
					  ADD_SRC_REG($2);
					  ADD_SRC_REG($4);
					  ADD_DST_REG($6);
					}
	| CMOVEQ REG ',' INT ',' REG	{
					  ADD_MNEMONIC(cmoveq_c);
					  ADD_COMMENT("cmoveq_c");
					  ADD_SRC_REG($2);
					  ADD_IMM($4);
					  ADD_DST_REG($6);
					}
	| CMOVNE REG ',' REG ',' REG	{
					  ADD_MNEMONIC(cmovne);
					  ADD_COMMENT("cmovne");
					  ADD_SRC_REG($2);
					  ADD_SRC_REG($4);
					  ADD_DST_REG($6);
					}
	| CMOVNE REG ',' INT ',' REG	{
					  ADD_MNEMONIC(cmovne_c);
					  ADD_COMMENT("cmovne_c");
					  ADD_SRC_REG($2);
					  ADD_IMM($4);
					  ADD_DST_REG($6);
					}
	| CMOVLT REG ',' REG ',' REG	{
					  ADD_MNEMONIC(cmovlt);
					  ADD_COMMENT("cmovlt");
					  ADD_SRC_REG($2);
					  ADD_SRC_REG($4);
					  ADD_DST_REG($6);
					}
	| CMOVLT REG ',' INT ',' REG	{
					  ADD_MNEMONIC(cmovlt_c);
					  ADD_COMMENT("cmovlt_c");
					  ADD_SRC_REG($2);
					  ADD_IMM($4);
					  ADD_DST_REG($6);
					}
	| CMOVLE REG ',' REG ',' REG	{
					  ADD_MNEMONIC(cmovle);
					  ADD_COMMENT("cmovle");
					  ADD_SRC_REG($2);
					  ADD_SRC_REG($4);
					  ADD_DST_REG($6);
					}
	| CMOVLE REG ',' INT ',' REG	{
					  ADD_MNEMONIC(cmovle_c);
					  ADD_COMMENT("cmovle_c");
					  ADD_SRC_REG($2);
					  ADD_IMM($4);
					  ADD_DST_REG($6);
					}
	| CMOVGT REG ',' REG ',' REG	{
					  ADD_MNEMONIC(cmovgt);
					  ADD_COMMENT("cmovgt");
					  ADD_SRC_REG($2);
					  ADD_SRC_REG($4);
					  ADD_DST_REG($6);
					}
	| CMOVGT REG ',' INT ',' REG	{
					  ADD_MNEMONIC(cmovgt_c);
					  ADD_COMMENT("cmovgt_c");
					  ADD_SRC_REG($2);
					  ADD_IMM($4);
					  ADD_DST_REG($6);
					}
	| CMOVGE REG ',' REG ',' REG	{
					  ADD_MNEMONIC(cmovge);
					  ADD_COMMENT("cmovge");
					  ADD_SRC_REG($2);
					  ADD_SRC_REG($4);
					  ADD_DST_REG($6);
					}
	| CMOVGE REG ',' INT ',' REG	{
					  ADD_MNEMONIC(cmovge_c);
					  ADD_COMMENT("cmovge_c");
					  ADD_SRC_REG($2);
					  ADD_IMM($4);
					  ADD_DST_REG($6);
					}
	| JSR TOKEN			{
					  ADD_MNEMONIC(jsr);
					  ADD_COMMENT("jsr");
					  ADD_LABEL_REF($2);
					}
	| BSR TOKEN			{
					  ADD_MNEMONIC(bsr);
					  ADD_COMMENT("bsr");
					  ADD_LABEL_REF($2);
					}
	| RET REG ',' '(' REG ')' ',' INT {
					  ADD_MNEMONIC(ret);
					  ADD_COMMENT("ret");
					  if ($2 != 31 
					      || $5 != 26 
					      || $8 != 1) {
					    fprintf(stderr,
					            "Can only 'ret zero, (ra), 1', don't know how to ret anything else.\n");
					    exit(1);
					  }
					}
	| LABEL				{ ADD_CODE_LABEL($1); }
	| LDGP REG ',' INT '(' REG ')'	{ /* XXX */ }
	;

%%


extern FILE *asmin;

void asm_file(char *asm_filename)
{
  char buf[200];

  sprintf(buf, "gcc -E -x c -I. %s", asm_filename);
  asmin = popen(buf, "r");
  if (asmin == NULL) {
    fprintf(stderr, "Failed to open or cpp file \"%s\"\n", asm_filename);
    exit(1);
  }
/*  asmdebug = 1; */
  asmparse();
  pclose(asmin);
}
