%{
/* This file is part of alpha (= Alpha Loves to Perform Hasty Assembler).
 * See file COPYRIGHT for pertinent copyright notices.
 */

#include <stdlib.h>
#include <string.h>
#include "asm-parse.h"


int asm_lineno = 1;

/* XXX  This function is ugly.  Improve. */

char *strmangle(char *s)
{
  char *res = malloc(strlen(s) + 1), *w = res;

  s++;				/* Skips beginning '"'. */
  while (*s != '"') {
    if (*s == '\\') {
      s++;
      if (*s == 'n') {
	*w++ = '\n';
	s++;
	continue;
      }
      if (*s == 't') {
	*w++ = '\t';
	s++;
	continue;
      }
    }
    *w++ = *s++;
  }
  *w = '\0';
  return res;
}

%}


%%

\n			{ asm_lineno++; }
[ \t]			{ ; /* Skip whitespaces. */ }
\#[ ][0-9]+[ ]\"[^\"]*\".*\n	{
			  /* cpp generated line comments. XXX This assumes
			   * only the user file has errors... 
			   */
			  asm_lineno = atoi(yytext + 2);
			}
\#.*\n			{ asm_lineno++; /* Skip comments. */ }
\"[^\"]*\"		{ asmlval.s = strmangle(asmtext); return STRING; }
-?(0|[1-9][0-9]*)	{ asmlval.i = atoi(asmtext); return INT; }
$[1-2]?[0-9]		{ asmlval.i = atoi(asmtext+1); return REG; }
$3[01]			{ asmlval.i = atoi(asmtext+1); return REG; }
\.align			{ return DOT_ALIGN; }
\.ascii			{ return DOT_ASCII; }
\.comm			{ return DOT_COMM; }
\.data			{ return DOT_DATA; }
\.ent			{ return DOT_ENT; }
\.end			{ return DOT_END; }
\.globl			{ return DOT_GLOBL; }
\.text			{ return DOT_TEXT; }
lda			{ return LDA; }
ldiq			{ return LDIQ; }
ldq			{ return LDQ; }
stq			{ return STQ; }
addq			{ return ADDQ; }
s4addq			{ return S4ADDQ; }
s8addq			{ return S8ADDQ; }
subq			{ return SUBQ; }
s4subq			{ return S4SUBQ; }
s8subq			{ return S8SUBQ; }
absq			{ return ABSQ; }
negq			{ return NEGQ; }
mulq			{ return MULQ; }
divq			{ return DIVQ; }
remq			{ return REMQ; }
sll			{ return SLL; }
sra			{ return SRA; }
mov			{ return MOV; }
cmpeq			{ return CMPEQ; }
cmpne			{ return CMPNE; }
cmplt			{ return CMPLT; }
cmple			{ return CMPLE; }
cmpgt			{ return CMPGT; }
cmpge			{ return CMPGE; }
br			{ return BR; }
beq			{ return BEQ; }
bne			{ return BNE; }
blt			{ return BLT; }
ble			{ return BLE; }
bgt			{ return BGT; }
bge			{ return BGE; }
cmoveq			{ return CMOVEQ; }
cmovne			{ return CMOVNE; }
cmovlt			{ return CMOVLT; }
cmovle			{ return CMOVLE; }
cmovgt			{ return CMOVGT; }
cmovge			{ return CMOVGE; }
jsr			{ return JSR; }
bsr			{ return BSR; }
ldgp			{ return LDGP; }
ret			{ return RET; }
[a-zA-Z$][a-zA-Z0-9_$.]*	{
			  asmlval.s = strdup(asmtext);
			  return TOKEN;
			}
[a-zA-Z$][a-zA-Z0-9_$.]*:	{
			  asmlval.s = strdup(asmtext);
			  /* Chop off the last semicolon. */
			  asmlval.s[strlen(asmlval.s) - 1] = '\0';
			  return LABEL;
			}
.			{ return *asmtext; }

%%

int asmwrap(void)
{
  return 1;
}
